/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.TableOrder;

public class MultiplePiePlot
extends Plot
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -355377800470807389L;
    private JFreeChart pieChart;
    private CategoryDataset dataset;
    private TableOrder dataExtractOrder;
    private double limit = 0.0;
    private Comparable aggregatedItemsKey;
    private transient Paint aggregatedItemsPaint;
    private transient Map sectionPaints;
    private transient Shape legendItemShape;

    public MultiplePiePlot() {
        this(null);
    }

    public MultiplePiePlot(CategoryDataset categoryDataset) {
        this.setDataset(categoryDataset);
        PiePlot piePlot = new PiePlot(null);
        piePlot.setIgnoreNullValues(true);
        this.pieChart = new JFreeChart(piePlot);
        this.pieChart.removeLegend();
        this.dataExtractOrder = TableOrder.BY_COLUMN;
        this.pieChart.setBackgroundPaint(null);
        TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.setTitle(textTitle);
        this.aggregatedItemsKey = "Other";
        this.aggregatedItemsPaint = Color.lightGray;
        this.sectionPaints = new HashMap();
        this.legendItemShape = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        if (this.dataset != null) {
            this.dataset.removeChangeListener(this);
        }
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            this.setDatasetGroup(categoryDataset.getGroup());
            categoryDataset.addChangeListener(this);
        }
        this.datasetChanged(new DatasetChangeEvent(this, categoryDataset));
    }

    public JFreeChart getPieChart() {
        return this.pieChart;
    }

    public void setPieChart(JFreeChart jFreeChart) {
        ParamChecks.nullNotPermitted(jFreeChart, "pieChart");
        if (!(jFreeChart.getPlot() instanceof PiePlot)) {
            throw new IllegalArgumentException("The 'pieChart' argument must be a chart based on a PiePlot.");
        }
        this.pieChart = jFreeChart;
        this.fireChangeEvent();
    }

    public TableOrder getDataExtractOrder() {
        return this.dataExtractOrder;
    }

    public void setDataExtractOrder(TableOrder tableOrder) {
        ParamChecks.nullNotPermitted(tableOrder, "order");
        this.dataExtractOrder = tableOrder;
        this.fireChangeEvent();
    }

    public double getLimit() {
        return this.limit;
    }

    public void setLimit(double d2) {
        this.limit = d2;
        this.fireChangeEvent();
    }

    public Comparable getAggregatedItemsKey() {
        return this.aggregatedItemsKey;
    }

    public void setAggregatedItemsKey(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        this.aggregatedItemsKey = comparable;
        this.fireChangeEvent();
    }

    public Paint getAggregatedItemsPaint() {
        return this.aggregatedItemsPaint;
    }

    public void setAggregatedItemsPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.aggregatedItemsPaint = paint;
        this.fireChangeEvent();
    }

    @Override
    public String getPlotType() {
        return "Multiple Pie Plot";
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "shape");
        this.legendItemShape = shape;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        int n2;
        int n3;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        if (DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            return;
        }
        int n4 = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowCount() : this.dataset.getColumnCount();
        int n5 = (int)Math.ceil(Math.sqrt(n4));
        if (n5 > (n3 = (int)Math.ceil((double)n4 / (double)n5)) && rectangle2D.getWidth() < rectangle2D.getHeight()) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
        }
        this.prefetchSectionPaints();
        n2 = (int)rectangle2D.getX();
        int n6 = (int)rectangle2D.getY();
        int n7 = (int)rectangle2D.getWidth() / n5;
        int n8 = (int)rectangle2D.getHeight() / n3;
        int n9 = 0;
        int n10 = 0;
        int n11 = n3 * n5 - n4;
        int n12 = 0;
        Rectangle rectangle = new Rectangle();
        for (int i2 = 0; i2 < n4; ++i2) {
            rectangle.setBounds(n2 + n12 + n7 * n10, n6 + n8 * n9, n7, n8);
            String string = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowKey(i2).toString() : this.dataset.getColumnKey(i2).toString();
            this.pieChart.setTitle(string);
            CategoryToPieDataset categoryToPieDataset = new CategoryToPieDataset(this.dataset, this.dataExtractOrder, i2);
            PieDataset pieDataset = this.limit > 0.0 ? DatasetUtilities.createConsolidatedPieDataset(categoryToPieDataset, this.aggregatedItemsKey, this.limit) : categoryToPieDataset;
            PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
            piePlot.setDataset(pieDataset);
            piePlot.setPieIndex(i2);
            for (int i3 = 0; i3 < pieDataset.getItemCount(); ++i3) {
                Comparable comparable = pieDataset.getKey(i3);
                Paint paint = comparable.equals(this.aggregatedItemsKey) ? this.aggregatedItemsPaint : (Paint)this.sectionPaints.get(comparable);
                piePlot.setSectionPaint(comparable, paint);
            }
            ChartRenderingInfo chartRenderingInfo = null;
            if (plotRenderingInfo != null) {
                chartRenderingInfo = new ChartRenderingInfo();
            }
            this.pieChart.draw(graphics2D, rectangle, chartRenderingInfo);
            if (plotRenderingInfo != null) {
                assert (chartRenderingInfo != null);
                plotRenderingInfo.getOwner().getEntityCollection().addAll(chartRenderingInfo.getEntityCollection());
                plotRenderingInfo.addSubplotInfo(chartRenderingInfo.getPlotInfo());
            }
            if (++n10 != n5) continue;
            n10 = 0;
            if (++n9 != n3 - 1 || n11 == 0) continue;
            n12 = n11 * n7 / 2;
        }
    }

    private void prefetchSectionPaints() {
        PiePlot piePlot = (PiePlot)this.getPieChart().getPlot();
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            for (int i2 = 0; i2 < this.dataset.getColumnCount(); ++i2) {
                Comparable comparable = this.dataset.getColumnKey(i2);
                Paint paint = piePlot.getSectionPaint(comparable);
                if (paint == null && (paint = (Paint)this.sectionPaints.get(comparable)) == null) {
                    paint = this.getDrawingSupplier().getNextPaint();
                }
                this.sectionPaints.put(comparable, paint);
            }
        } else {
            for (int i3 = 0; i3 < this.dataset.getRowCount(); ++i3) {
                Comparable comparable = this.dataset.getRowKey(i3);
                Paint paint = piePlot.getSectionPaint(comparable);
                if (paint == null && (paint = (Paint)this.sectionPaints.get(comparable)) == null) {
                    paint = this.getDrawingSupplier().getNextPaint();
                }
                this.sectionPaints.put(comparable, paint);
            }
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset == null) {
            return legendItemCollection;
        }
        List list = null;
        this.prefetchSectionPaints();
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            list = this.dataset.getColumnKeys();
        } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
            list = this.dataset.getRowKeys();
        }
        if (list == null) {
            return legendItemCollection;
        }
        int n2 = 0;
        for (Object object : list) {
            String string;
            String string2 = string = object.toString();
            Paint paint = (Paint)this.sectionPaints.get(object);
            LegendItem legendItem = new LegendItem(string, string2, null, null, this.getLegendItemShape(), paint, Plot.DEFAULT_OUTLINE_STROKE, paint);
            legendItem.setSeriesKey((Comparable)object);
            legendItem.setSeriesIndex(n2);
            legendItem.setDataset(this.getDataset());
            legendItemCollection.add(legendItem);
            ++n2;
        }
        if (this.limit > 0.0) {
            Object object;
            object = new LegendItem(this.aggregatedItemsKey.toString(), this.aggregatedItemsKey.toString(), null, null, this.getLegendItemShape(), this.aggregatedItemsPaint, Plot.DEFAULT_OUTLINE_STROKE, this.aggregatedItemsPaint);
            legendItemCollection.add((LegendItem)object);
        }
        return legendItemCollection;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultiplePiePlot)) {
            return false;
        }
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)object;
        if (this.dataExtractOrder != multiplePiePlot.dataExtractOrder) {
            return false;
        }
        if (this.limit != multiplePiePlot.limit) {
            return false;
        }
        if (!this.aggregatedItemsKey.equals(multiplePiePlot.aggregatedItemsKey)) {
            return false;
        }
        if (!PaintUtilities.equal(this.aggregatedItemsPaint, multiplePiePlot.aggregatedItemsPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.pieChart, multiplePiePlot.pieChart)) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendItemShape, multiplePiePlot.legendItemShape)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        MultiplePiePlot multiplePiePlot = (MultiplePiePlot)super.clone();
        multiplePiePlot.pieChart = (JFreeChart)this.pieChart.clone();
        multiplePiePlot.sectionPaints = new HashMap(this.sectionPaints);
        multiplePiePlot.legendItemShape = ShapeUtilities.clone(this.legendItemShape);
        return multiplePiePlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.aggregatedItemsPaint, objectOutputStream);
        SerialUtilities.writeShape(this.legendItemShape, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.aggregatedItemsPaint = SerialUtilities.readPaint(objectInputStream);
        this.legendItemShape = SerialUtilities.readShape(objectInputStream);
        this.sectionPaints = new HashMap();
    }
}

