/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ArrayUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public class FastScatterPlot
extends Plot
implements Serializable,
Cloneable,
Pannable,
ValueAxisPlot,
Zoomable {
    private static final long serialVersionUID = 7871545897358563521L;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    private float[][] data;
    private Range xDataRange;
    private Range yDataRange;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private transient Paint paint;
    private boolean domainGridlinesVisible;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean domainPannable;
    private boolean rangePannable;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public FastScatterPlot() {
        this(null, new NumberAxis("X"), new NumberAxis("Y"));
    }

    public FastScatterPlot(float[][] fArray, ValueAxis valueAxis, ValueAxis valueAxis2) {
        ParamChecks.nullNotPermitted(valueAxis, "domainAxis");
        ParamChecks.nullNotPermitted(valueAxis2, "rangeAxis");
        this.data = fArray;
        this.xDataRange = this.calculateXDataRange(fArray);
        this.yDataRange = this.calculateYDataRange(fArray);
        this.domainAxis = valueAxis;
        this.domainAxis.setPlot(this);
        this.domainAxis.addChangeListener(this);
        this.rangeAxis = valueAxis2;
        this.rangeAxis.setPlot(this);
        this.rangeAxis.addChangeListener(this);
        this.paint = Color.red;
        this.domainGridlinesVisible = true;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinesVisible = true;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Fast_Scatter_Plot");
    }

    public float[][] getData() {
        return this.data;
    }

    public void setData(float[][] fArray) {
        this.data = fArray;
        this.fireChangeEvent();
    }

    @Override
    public PlotOrientation getOrientation() {
        return PlotOrientation.VERTICAL;
    }

    public ValueAxis getDomainAxis() {
        return this.domainAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) {
        ParamChecks.nullNotPermitted(valueAxis, "axis");
        this.domainAxis = valueAxis;
        this.fireChangeEvent();
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        ParamChecks.nullNotPermitted(valueAxis, "axis");
        this.rangeAxis = valueAxis;
        this.fireChangeEvent();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.fireChangeEvent();
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl2) {
        if (this.domainGridlinesVisible != bl2) {
            this.domainGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl2) {
        if (this.rangeGridlinesVisible != bl2) {
            this.rangeGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeGridlinePaint = paint;
        this.fireChangeEvent();
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.domainAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.BOTTOM, axisSpace);
        axisSpace = this.rangeAxis.reserveSpace(graphics2D, this, rectangle2D, RectangleEdge.LEFT, axisSpace);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
        this.drawBackground(graphics2D, rectangle2D2);
        AxisState axisState = this.domainAxis.draw(graphics2D, rectangle2D2.getMaxY(), rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
        AxisState axisState2 = this.rangeAxis.draw(graphics2D, rectangle2D2.getMinX(), rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
        this.drawDomainGridlines(graphics2D, rectangle2D2, axisState.getTicks());
        this.drawRangeGridlines(graphics2D, rectangle2D2, axisState2.getTicks());
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip(rectangle2D2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        this.render(graphics2D, rectangle2D2, plotRenderingInfo, null);
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D2);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, CrosshairState crosshairState) {
        graphics2D.setPaint(this.paint);
        if (this.data != null) {
            for (int i2 = 0; i2 < this.data[0].length; ++i2) {
                float f2 = this.data[0][i2];
                float f3 = this.data[1][i2];
                int n2 = (int)this.domainAxis.valueToJava2D(f2, rectangle2D, RectangleEdge.BOTTOM);
                int n3 = (int)this.rangeAxis.valueToJava2D(f3, rectangle2D, RectangleEdge.LEFT);
                graphics2D.fillRect(n2, n3, 1, 1);
            }
        }
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (!this.isDomainGridlinesVisible()) {
            return;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (ValueTick valueTick : list) {
            double d2 = this.domainAxis.valueToJava2D(valueTick.getValue(), rectangle2D, RectangleEdge.BOTTOM);
            Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            graphics2D.setPaint(this.getDomainGridlinePaint());
            graphics2D.setStroke(this.getDomainGridlineStroke());
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (!this.isRangeGridlinesVisible()) {
            return;
        }
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (ValueTick valueTick : list) {
            double d2 = this.rangeAxis.valueToJava2D(valueTick.getValue(), rectangle2D, RectangleEdge.LEFT);
            Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            graphics2D.setPaint(this.getRangeGridlinePaint());
            graphics2D.setStroke(this.getRangeGridlineStroke());
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (valueAxis == this.domainAxis) {
            range = this.xDataRange;
        } else if (valueAxis == this.rangeAxis) {
            range = this.yDataRange;
        }
        return range;
    }

    private Range calculateXDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f2 = Float.POSITIVE_INFINITY;
            float f3 = Float.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < fArray[0].length; ++i2) {
                float f4 = fArray[0][i2];
                if (f4 < f2) {
                    f2 = f4;
                }
                if (!(f4 > f3)) continue;
                f3 = f4;
            }
            if (f2 <= f3) {
                range = new Range(f2, f3);
            }
        }
        return range;
    }

    private Range calculateYDataRange(float[][] fArray) {
        Range range = null;
        if (fArray != null) {
            float f2 = Float.POSITIVE_INFINITY;
            float f3 = Float.NEGATIVE_INFINITY;
            for (int i2 = 0; i2 < fArray[0].length; ++i2) {
                float f4 = fArray[1][i2];
                if (f4 < f2) {
                    f2 = f4;
                }
                if (!(f4 > f3)) continue;
                f3 = f4;
            }
            if (f2 <= f3) {
                range = new Range(f2, f3);
            }
        }
        return range;
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.domainAxis.resizeRange(d2);
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        if (bl2) {
            double d3 = point2D.getX();
            double d4 = this.domainAxis.java2DToValue(d3, plotRenderingInfo.getDataArea(), RectangleEdge.BOTTOM);
            this.domainAxis.resizeRange2(d2, d4);
        } else {
            this.domainAxis.resizeRange(d2);
        }
    }

    @Override
    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.domainAxis.zoomRange(d2, d3);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.rangeAxis.resizeRange(d2);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        if (bl2) {
            double d3 = point2D.getY();
            double d4 = this.rangeAxis.java2DToValue(d3, plotRenderingInfo.getDataArea(), RectangleEdge.LEFT);
            this.rangeAxis.resizeRange2(d2, d4);
        } else {
            this.rangeAxis.resizeRange(d2);
        }
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.rangeAxis.zoomRange(d2, d3);
    }

    @Override
    public boolean isDomainZoomable() {
        return true;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    @Override
    public boolean isDomainPannable() {
        return this.domainPannable;
    }

    public void setDomainPannable(boolean bl2) {
        this.domainPannable = bl2;
    }

    @Override
    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean bl2) {
        this.rangePannable = bl2;
    }

    @Override
    public void panDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isDomainPannable() || this.domainAxis == null) {
            return;
        }
        double d3 = this.domainAxis.getRange().getLength();
        double d4 = d2 * d3;
        if (this.domainAxis.isInverted()) {
            d4 = -d4;
        }
        this.domainAxis.setRange(this.domainAxis.getLowerBound() + d4, this.domainAxis.getUpperBound() + d4);
    }

    @Override
    public void panRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isRangePannable() || this.rangeAxis == null) {
            return;
        }
        double d3 = this.rangeAxis.getRange().getLength();
        double d4 = d2 * d3;
        if (this.rangeAxis.isInverted()) {
            d4 = -d4;
        }
        this.rangeAxis.setRange(this.rangeAxis.getLowerBound() + d4, this.rangeAxis.getUpperBound() + d4);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof FastScatterPlot)) {
            return false;
        }
        FastScatterPlot fastScatterPlot = (FastScatterPlot)object;
        if (this.domainPannable != fastScatterPlot.domainPannable) {
            return false;
        }
        if (this.rangePannable != fastScatterPlot.rangePannable) {
            return false;
        }
        if (!ArrayUtilities.equal(this.data, fastScatterPlot.data)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainAxis, fastScatterPlot.domainAxis)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeAxis, fastScatterPlot.rangeAxis)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, fastScatterPlot.paint)) {
            return false;
        }
        if (this.domainGridlinesVisible != fastScatterPlot.domainGridlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, fastScatterPlot.domainGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, fastScatterPlot.domainGridlineStroke)) {
            return false;
        }
        if (!this.rangeGridlinesVisible == fastScatterPlot.rangeGridlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, fastScatterPlot.rangeGridlinePaint)) {
            return false;
        }
        return ObjectUtilities.equal(this.rangeGridlineStroke, fastScatterPlot.rangeGridlineStroke);
    }

    @Override
    public Object clone() {
        FastScatterPlot fastScatterPlot = (FastScatterPlot)super.clone();
        if (this.data != null) {
            fastScatterPlot.data = ArrayUtilities.clone(this.data);
        }
        if (this.domainAxis != null) {
            fastScatterPlot.domainAxis = (ValueAxis)this.domainAxis.clone();
            fastScatterPlot.domainAxis.setPlot(fastScatterPlot);
            fastScatterPlot.domainAxis.addChangeListener(fastScatterPlot);
        }
        if (this.rangeAxis != null) {
            fastScatterPlot.rangeAxis = (ValueAxis)this.rangeAxis.clone();
            fastScatterPlot.rangeAxis.setPlot(fastScatterPlot);
            fastScatterPlot.rangeAxis.addChangeListener(fastScatterPlot);
        }
        return fastScatterPlot;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        if (this.domainAxis != null) {
            this.domainAxis.addChangeListener(this);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.addChangeListener(this);
        }
    }
}

