/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.CrosshairLabelGenerator;
import org.jfree.chart.labels.StandardCrosshairLabelGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class Crosshair
implements Serializable,
Cloneable,
PublicCloneable {
    private boolean visible;
    private double value;
    private transient Paint paint;
    private transient Stroke stroke;
    private boolean labelVisible;
    private RectangleAnchor labelAnchor;
    private CrosshairLabelGenerator labelGenerator;
    private double labelXOffset;
    private double labelYOffset;
    private Font labelFont;
    private transient Paint labelPaint;
    private transient Paint labelBackgroundPaint;
    private boolean labelOutlineVisible;
    private transient Stroke labelOutlineStroke;
    private transient Paint labelOutlinePaint;
    private transient PropertyChangeSupport pcs;

    public Crosshair() {
        this(0.0);
    }

    public Crosshair(double d2) {
        this(d2, Color.black, new BasicStroke(1.0f));
    }

    public Crosshair(double d2, Paint paint, Stroke stroke) {
        ParamChecks.nullNotPermitted(paint, "paint");
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.visible = true;
        this.value = d2;
        this.paint = paint;
        this.stroke = stroke;
        this.labelVisible = false;
        this.labelGenerator = new StandardCrosshairLabelGenerator();
        this.labelAnchor = RectangleAnchor.BOTTOM_LEFT;
        this.labelXOffset = 3.0;
        this.labelYOffset = 3.0;
        this.labelFont = new Font("Tahoma", 0, 12);
        this.labelPaint = Color.black;
        this.labelBackgroundPaint = new Color(0, 0, 255, 63);
        this.labelOutlineVisible = true;
        this.labelOutlinePaint = Color.black;
        this.labelOutlineStroke = new BasicStroke(0.5f);
        this.pcs = new PropertyChangeSupport(this);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl2) {
        boolean bl3 = this.visible;
        this.visible = bl2;
        this.pcs.firePropertyChange("visible", bl3, bl2);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d2) {
        Double d3 = new Double(this.value);
        this.value = d2;
        this.pcs.firePropertyChange("value", d3, new Double(d2));
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        Paint paint2 = this.paint;
        this.paint = paint;
        this.pcs.firePropertyChange("paint", paint2, paint);
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        Stroke stroke2 = this.stroke;
        this.stroke = stroke;
        this.pcs.firePropertyChange("stroke", stroke2, stroke);
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl2) {
        boolean bl3 = this.labelVisible;
        this.labelVisible = bl2;
        this.pcs.firePropertyChange("labelVisible", bl3, bl2);
    }

    public CrosshairLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(CrosshairLabelGenerator crosshairLabelGenerator) {
        ParamChecks.nullNotPermitted(crosshairLabelGenerator, "generator");
        CrosshairLabelGenerator crosshairLabelGenerator2 = this.labelGenerator;
        this.labelGenerator = crosshairLabelGenerator;
        this.pcs.firePropertyChange("labelGenerator", crosshairLabelGenerator2, crosshairLabelGenerator);
    }

    public RectangleAnchor getLabelAnchor() {
        return this.labelAnchor;
    }

    public void setLabelAnchor(RectangleAnchor rectangleAnchor) {
        RectangleAnchor rectangleAnchor2 = this.labelAnchor;
        this.labelAnchor = rectangleAnchor;
        this.pcs.firePropertyChange("labelAnchor", rectangleAnchor2, rectangleAnchor);
    }

    public double getLabelXOffset() {
        return this.labelXOffset;
    }

    public void setLabelXOffset(double d2) {
        Double d3 = new Double(this.labelXOffset);
        this.labelXOffset = d2;
        this.pcs.firePropertyChange("labelXOffset", d3, new Double(d2));
    }

    public double getLabelYOffset() {
        return this.labelYOffset;
    }

    public void setLabelYOffset(double d2) {
        Double d3 = new Double(this.labelYOffset);
        this.labelYOffset = d2;
        this.pcs.firePropertyChange("labelYOffset", d3, new Double(d2));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        Font font2 = this.labelFont;
        this.labelFont = font;
        this.pcs.firePropertyChange("labelFont", font2, font);
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        Paint paint2 = this.labelPaint;
        this.labelPaint = paint;
        this.pcs.firePropertyChange("labelPaint", paint2, paint);
    }

    public Paint getLabelBackgroundPaint() {
        return this.labelBackgroundPaint;
    }

    public void setLabelBackgroundPaint(Paint paint) {
        Paint paint2 = this.labelBackgroundPaint;
        this.labelBackgroundPaint = paint;
        this.pcs.firePropertyChange("labelBackgroundPaint", paint2, paint);
    }

    public boolean isLabelOutlineVisible() {
        return this.labelOutlineVisible;
    }

    public void setLabelOutlineVisible(boolean bl2) {
        boolean bl3 = this.labelOutlineVisible;
        this.labelOutlineVisible = bl2;
        this.pcs.firePropertyChange("labelOutlineVisible", bl3, bl2);
    }

    public Paint getLabelOutlinePaint() {
        return this.labelOutlinePaint;
    }

    public void setLabelOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        Paint paint2 = this.labelOutlinePaint;
        this.labelOutlinePaint = paint;
        this.pcs.firePropertyChange("labelOutlinePaint", paint2, paint);
    }

    public Stroke getLabelOutlineStroke() {
        return this.labelOutlineStroke;
    }

    public void setLabelOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        Stroke stroke2 = this.labelOutlineStroke;
        this.labelOutlineStroke = stroke;
        this.pcs.firePropertyChange("labelOutlineStroke", stroke2, stroke);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Crosshair)) {
            return false;
        }
        Crosshair crosshair = (Crosshair)object;
        if (this.visible != crosshair.visible) {
            return false;
        }
        if (this.value != crosshair.value) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, crosshair.paint)) {
            return false;
        }
        if (!this.stroke.equals(crosshair.stroke)) {
            return false;
        }
        if (this.labelVisible != crosshair.labelVisible) {
            return false;
        }
        if (!this.labelGenerator.equals(crosshair.labelGenerator)) {
            return false;
        }
        if (!this.labelAnchor.equals(crosshair.labelAnchor)) {
            return false;
        }
        if (this.labelXOffset != crosshair.labelXOffset) {
            return false;
        }
        if (this.labelYOffset != crosshair.labelYOffset) {
            return false;
        }
        if (!this.labelFont.equals(crosshair.labelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelPaint, crosshair.labelPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelBackgroundPaint, crosshair.labelBackgroundPaint)) {
            return false;
        }
        if (this.labelOutlineVisible != crosshair.labelOutlineVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.labelOutlinePaint, crosshair.labelOutlinePaint)) {
            return false;
        }
        return this.labelOutlineStroke.equals(crosshair.labelOutlineStroke);
    }

    public int hashCode() {
        int n2 = 7;
        n2 = HashUtilities.hashCode(n2, this.visible);
        n2 = HashUtilities.hashCode(n2, this.value);
        n2 = HashUtilities.hashCode(n2, this.paint);
        n2 = HashUtilities.hashCode(n2, this.stroke);
        n2 = HashUtilities.hashCode(n2, this.labelVisible);
        n2 = HashUtilities.hashCode(n2, this.labelAnchor);
        n2 = HashUtilities.hashCode(n2, this.labelGenerator);
        n2 = HashUtilities.hashCode(n2, this.labelXOffset);
        n2 = HashUtilities.hashCode(n2, this.labelYOffset);
        n2 = HashUtilities.hashCode(n2, this.labelFont);
        n2 = HashUtilities.hashCode(n2, this.labelPaint);
        n2 = HashUtilities.hashCode(n2, this.labelBackgroundPaint);
        n2 = HashUtilities.hashCode(n2, this.labelOutlineVisible);
        n2 = HashUtilities.hashCode(n2, this.labelOutlineStroke);
        n2 = HashUtilities.hashCode(n2, this.labelOutlinePaint);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writeStroke(this.stroke, objectOutputStream);
        SerialUtilities.writePaint(this.labelPaint, objectOutputStream);
        SerialUtilities.writePaint(this.labelBackgroundPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.labelOutlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.labelOutlinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.stroke = SerialUtilities.readStroke(objectInputStream);
        this.labelPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelBackgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.labelOutlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.labelOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.pcs = new PropertyChangeSupport(this);
    }
}

