/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.needle.ArrowNeedle;
import org.jfree.chart.needle.LineNeedle;
import org.jfree.chart.needle.LongNeedle;
import org.jfree.chart.needle.MeterNeedle;
import org.jfree.chart.needle.MiddlePinNeedle;
import org.jfree.chart.needle.PinNeedle;
import org.jfree.chart.needle.PlumNeedle;
import org.jfree.chart.needle.PointerNeedle;
import org.jfree.chart.needle.ShipNeedle;
import org.jfree.chart.needle.WindNeedle;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.data.general.DefaultValueDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public class CompassPlot
extends Plot
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6924382802125527395L;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int labelType;
    private Font labelFont;
    private boolean drawBorder = false;
    private transient Paint roseHighlightPaint = Color.black;
    private transient Paint rosePaint = Color.yellow;
    private transient Paint roseCenterPaint = Color.white;
    private Font compassFont = new Font("Arial", 0, 10);
    private transient Ellipse2D circle1;
    private transient Ellipse2D circle2;
    private transient Area a1;
    private transient Area a2;
    private transient Rectangle2D rect1;
    private ValueDataset[] datasets = new ValueDataset[1];
    private MeterNeedle[] seriesNeedle = new MeterNeedle[1];
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");
    protected double revolutionDistance = 360.0;

    public CompassPlot() {
        this(new DefaultValueDataset());
    }

    public CompassPlot(ValueDataset valueDataset) {
        if (valueDataset != null) {
            this.datasets[0] = valueDataset;
            valueDataset.addChangeListener(this);
        }
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.rect1 = new Rectangle2D.Double();
        this.setSeriesNeedle(0);
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != n2) {
            this.labelType = n2;
            this.fireChangeEvent();
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.labelFont = font;
        this.fireChangeEvent();
    }

    public Paint getRosePaint() {
        return this.rosePaint;
    }

    public void setRosePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rosePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getRoseCenterPaint() {
        return this.roseCenterPaint;
    }

    public void setRoseCenterPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.roseCenterPaint = paint;
        this.fireChangeEvent();
    }

    public Paint getRoseHighlightPaint() {
        return this.roseHighlightPaint;
    }

    public void setRoseHighlightPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.roseHighlightPaint = paint;
        this.fireChangeEvent();
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl2) {
        this.drawBorder = bl2;
        this.fireChangeEvent();
    }

    public void setSeriesPaint(int n2, Paint paint) {
        if (n2 >= 0 && n2 < this.seriesNeedle.length) {
            this.seriesNeedle[n2].setFillPaint(paint);
        }
    }

    public void setSeriesOutlinePaint(int n2, Paint paint) {
        if (n2 >= 0 && n2 < this.seriesNeedle.length) {
            this.seriesNeedle[n2].setOutlinePaint(paint);
        }
    }

    public void setSeriesOutlineStroke(int n2, Stroke stroke) {
        if (n2 >= 0 && n2 < this.seriesNeedle.length) {
            this.seriesNeedle[n2].setOutlineStroke(stroke);
        }
    }

    public void setSeriesNeedle(int n2) {
        this.setSeriesNeedle(0, n2);
    }

    public void setSeriesNeedle(int n2, int n3) {
        switch (n3) {
            case 0: {
                this.setSeriesNeedle(n2, new ArrowNeedle(true));
                this.setSeriesPaint(n2, Color.red);
                this.seriesNeedle[n2].setHighlightPaint(Color.white);
                break;
            }
            case 1: {
                this.setSeriesNeedle(n2, new LineNeedle());
                break;
            }
            case 2: {
                LongNeedle longNeedle = new LongNeedle();
                longNeedle.setRotateY(0.5);
                this.setSeriesNeedle(n2, longNeedle);
                break;
            }
            case 3: {
                this.setSeriesNeedle(n2, new PinNeedle());
                break;
            }
            case 4: {
                this.setSeriesNeedle(n2, new PlumNeedle());
                break;
            }
            case 5: {
                this.setSeriesNeedle(n2, new PointerNeedle());
                break;
            }
            case 6: {
                this.setSeriesPaint(n2, null);
                this.setSeriesOutlineStroke(n2, new BasicStroke(3.0f));
                this.setSeriesNeedle(n2, new ShipNeedle());
                break;
            }
            case 7: {
                this.setSeriesPaint(n2, Color.blue);
                this.setSeriesNeedle(n2, new WindNeedle());
                break;
            }
            case 8: {
                this.setSeriesNeedle(n2, new ArrowNeedle(true));
                break;
            }
            case 9: {
                this.setSeriesNeedle(n2, new MiddlePinNeedle());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognised type.");
            }
        }
    }

    public void setSeriesNeedle(int n2, MeterNeedle meterNeedle) {
        if (meterNeedle != null && n2 < this.seriesNeedle.length) {
            this.seriesNeedle[n2] = meterNeedle;
        }
        this.fireChangeEvent();
    }

    public ValueDataset[] getDatasets() {
        return this.datasets;
    }

    public void addDataset(ValueDataset valueDataset) {
        this.addDataset(valueDataset, null);
    }

    public void addDataset(ValueDataset valueDataset, MeterNeedle meterNeedle) {
        if (valueDataset != null) {
            int n2 = this.datasets.length + 1;
            ValueDataset[] valueDatasetArray = new ValueDataset[n2];
            MeterNeedle[] meterNeedleArray = new MeterNeedle[n2];
            n2 -= 2;
            while (n2 >= 0) {
                valueDatasetArray[n2] = this.datasets[n2];
                meterNeedleArray[n2] = this.seriesNeedle[n2];
                --n2;
            }
            n2 = this.datasets.length;
            valueDatasetArray[n2] = valueDataset;
            meterNeedleArray[n2] = meterNeedle != null ? meterNeedle : meterNeedleArray[n2 - 1];
            ValueDataset[] valueDatasetArray2 = this.datasets;
            MeterNeedle[] meterNeedleArray2 = this.seriesNeedle;
            this.datasets = valueDatasetArray;
            this.seriesNeedle = meterNeedleArray;
            --n2;
            while (n2 >= 0) {
                valueDatasetArray2[n2] = null;
                meterNeedleArray2[n2] = null;
                --n2;
            }
            valueDataset.addChangeListener(this);
        }
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        Shape shape;
        int n2;
        double d2;
        int n3;
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        if (this.drawBorder) {
            this.drawBackground(graphics2D, rectangle2D);
        }
        int n4 = (int)(rectangle2D.getWidth() / 2.0);
        int n5 = (int)(rectangle2D.getHeight() / 2.0);
        int n6 = n4;
        if (n5 < n4) {
            n6 = n5;
        }
        int n7 = 2 * --n6;
        this.circle1.setFrame((n4 += (int)rectangle2D.getMinX()) - n6, (n5 += (int)rectangle2D.getMinY()) - n6, n7, n7);
        this.circle2.setFrame(n4 - n6 + 15, n5 - n6 + 15, n7 - 30, n7 - 30);
        graphics2D.setPaint(this.rosePaint);
        this.a1 = new Area(this.circle1);
        this.a2 = new Area(this.circle2);
        this.a1.subtract(this.a2);
        graphics2D.fill(this.a1);
        graphics2D.setPaint(this.roseCenterPaint);
        int n8 = n7 - 30;
        graphics2D.fillOval(n4 - n6 + 15, n5 - n6 + 15, n8, n8);
        graphics2D.setPaint(this.roseHighlightPaint);
        graphics2D.drawOval(n4 - n6, n5 - n6, n7, n7);
        n8 = n7 - 20;
        graphics2D.drawOval(n4 - n6 + 10, n5 - n6 + 10, n8, n8);
        n8 = n7 - 30;
        graphics2D.drawOval(n4 - n6 + 15, n5 - n6 + 15, n8, n8);
        n8 = n7 - 80;
        graphics2D.drawOval(n4 - n6 + 40, n5 - n6 + 40, n8, n8);
        int n9 = n6 - 20;
        int n10 = n6 - 32;
        for (n3 = 0; n3 < 360; n3 += 15) {
            d2 = Math.toRadians(n3);
            n8 = n4 - (int)(Math.sin(d2) * (double)n10);
            int n11 = n4 - (int)(Math.sin(d2) * (double)n9);
            n2 = n5 - (int)(Math.cos(d2) * (double)n10);
            int n12 = n5 - (int)(Math.cos(d2) * (double)n9);
            graphics2D.drawLine(n8, n2, n11, n12);
        }
        graphics2D.setPaint(this.roseHighlightPaint);
        n10 = n6 - 26;
        n9 = 7;
        for (n3 = 45; n3 < 360; n3 += 90) {
            d2 = Math.toRadians(n3);
            n8 = n4 - (int)(Math.sin(d2) * (double)n10);
            n2 = n5 - (int)(Math.cos(d2) * (double)n10);
            graphics2D.fillOval(n8 - n9, n2 - n9, 2 * n9, 2 * n9);
        }
        for (n3 = 0; n3 < 360; n3 += 90) {
            d2 = Math.toRadians(n3);
            n8 = n4 - (int)(Math.sin(d2) * (double)n10);
            n2 = n5 - (int)(Math.cos(d2) * (double)n10);
            shape = new Polygon();
            shape.addPoint(n8 - n9, n2);
            shape.addPoint(n8, n2 + n9);
            shape.addPoint(n8 + n9, n2);
            shape.addPoint(n8, n2 - n9);
            graphics2D.fillPolygon((Polygon)shape);
        }
        n10 = n6 - 42;
        Font font = this.getCompassFont(n6);
        graphics2D.setFont(font);
        graphics2D.drawString(localizationResources.getString("N"), n4 - 5, n5 - n10 + font.getSize());
        graphics2D.drawString(localizationResources.getString("S"), n4 - 5, n5 + n10 - 5);
        graphics2D.drawString(localizationResources.getString("W"), n4 - n10 + 5, n5 + 5);
        graphics2D.drawString(localizationResources.getString("E"), n4 + n10 - font.getSize(), n5 + 5);
        n2 = n6 / 2;
        n8 = n6 / 6;
        shape = new Rectangle2D.Double(n4 - n8, n5 - n2, 2 * n8, 2 * n2);
        int n13 = this.seriesNeedle.length;
        for (int i2 = this.datasets.length - 1; i2 >= 0; --i2) {
            ValueDataset valueDataset = this.datasets[i2];
            if (valueDataset == null || valueDataset.getValue() == null) continue;
            double d3 = valueDataset.getValue().doubleValue() % this.revolutionDistance;
            d3 = d3 / this.revolutionDistance * 360.0;
            int n14 = i2 % n13;
            this.seriesNeedle[n14].draw(graphics2D, (Rectangle2D)shape, d3);
        }
        if (this.drawBorder) {
            this.drawOutline(graphics2D, rectangle2D);
        }
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Compass_Plot");
    }

    @Override
    public LegendItemCollection getLegendItems() {
        return null;
    }

    @Override
    public void zoom(double d2) {
    }

    protected Font getCompassFont(int n2) {
        float f2 = (float)n2 / 10.0f;
        if (f2 < 8.0f) {
            f2 = 8.0f;
        }
        Font font = this.compassFont.deriveFont(f2);
        return font;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CompassPlot)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        CompassPlot compassPlot = (CompassPlot)object;
        if (this.labelType != compassPlot.labelType) {
            return false;
        }
        if (!ObjectUtilities.equal(this.labelFont, compassPlot.labelFont)) {
            return false;
        }
        if (this.drawBorder != compassPlot.drawBorder) {
            return false;
        }
        if (!PaintUtilities.equal(this.roseHighlightPaint, compassPlot.roseHighlightPaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rosePaint, compassPlot.rosePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.roseCenterPaint, compassPlot.roseCenterPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.compassFont, compassPlot.compassFont)) {
            return false;
        }
        if (!Arrays.equals(this.seriesNeedle, compassPlot.seriesNeedle)) {
            return false;
        }
        return this.getRevolutionDistance() == compassPlot.getRevolutionDistance();
    }

    @Override
    public Object clone() {
        CompassPlot compassPlot = (CompassPlot)super.clone();
        if (this.circle1 != null) {
            compassPlot.circle1 = (Ellipse2D)this.circle1.clone();
        }
        if (this.circle2 != null) {
            compassPlot.circle2 = (Ellipse2D)this.circle2.clone();
        }
        if (this.a1 != null) {
            compassPlot.a1 = (Area)this.a1.clone();
        }
        if (this.a2 != null) {
            compassPlot.a2 = (Area)this.a2.clone();
        }
        if (this.rect1 != null) {
            compassPlot.rect1 = (Rectangle2D)this.rect1.clone();
        }
        compassPlot.datasets = (ValueDataset[])this.datasets.clone();
        compassPlot.seriesNeedle = (MeterNeedle[])this.seriesNeedle.clone();
        for (int i2 = 0; i2 < this.datasets.length; ++i2) {
            if (compassPlot.datasets[i2] == null) continue;
            compassPlot.datasets[i2].addChangeListener(compassPlot);
        }
        return compassPlot;
    }

    public void setRevolutionDistance(double d2) {
        if (d2 > 0.0) {
            this.revolutionDistance = d2;
        }
    }

    public double getRevolutionDistance() {
        return this.revolutionDistance;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.rosePaint, objectOutputStream);
        SerialUtilities.writePaint(this.roseCenterPaint, objectOutputStream);
        SerialUtilities.writePaint(this.roseHighlightPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.rosePaint = SerialUtilities.readPaint(objectInputStream);
        this.roseCenterPaint = SerialUtilities.readPaint(objectInputStream);
        this.roseHighlightPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

