/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;

public class CombinedRangeCategoryPlot
extends CategoryPlot
implements PlotChangeListener {
    private static final long serialVersionUID = 7260210007554504515L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotArea;

    public CombinedRangeCategoryPlot() {
        this(new NumberAxis());
    }

    public CombinedRangeCategoryPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d2) {
        this.gap = d2;
        this.fireChangeEvent();
    }

    public void add(CategoryPlot categoryPlot) {
        this.add(categoryPlot, 1);
    }

    public void add(CategoryPlot categoryPlot, int n2) {
        ParamChecks.nullNotPermitted(categoryPlot, "subplot");
        if (n2 <= 0) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n2);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setRangeAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        categoryPlot.addChangeListener(this);
        this.subplots.add(categoryPlot);
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(CategoryPlot categoryPlot) {
        ParamChecks.nullNotPermitted(categoryPlot, "subplot");
        int n2 = -1;
        int n3 = this.subplots.size();
        for (int i2 = 0; n2 == -1 && i2 < n3; ++i2) {
            if (this.subplots.get(i2) != categoryPlot) continue;
            n2 = i2;
        }
        if (n2 != -1) {
            ValueAxis valueAxis;
            this.subplots.remove(n2);
            categoryPlot.setParent(null);
            categoryPlot.removeChangeListener(this);
            ValueAxis valueAxis2 = this.getRangeAxis();
            if (valueAxis2 != null) {
                valueAxis2.configure();
            }
            if ((valueAxis = this.getRangeAxis(1)) != null) {
                valueAxis.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n2 = this.subplots.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i2);
            n3 += categoryPlot.getWeight();
        }
        this.subplotArea = new Rectangle2D[n2];
        double d2 = ((RectangularShape)cloneable).getX();
        double d3 = ((RectangularShape)cloneable).getY();
        double d4 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d4 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n2 - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n2 - 1);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i3);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d5 = d4 * (double)categoryPlot.getWeight() / (double)n3;
                this.subplotArea[i3] = new Rectangle2D.Double(d2, d3, d5, ((RectangularShape)cloneable).getHeight());
                d2 = d2 + d5 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d6 = d4 * (double)categoryPlot.getWeight() / (double)n3;
                this.subplotArea[i3] = new Rectangle2D.Double(d2, d3, ((RectangularShape)cloneable).getWidth(), d6);
                d3 = d3 + d6 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateDomainAxisSpace(graphics2D, this.subplotArea[i3], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getRangeAxis();
        RectangleEdge rectangleEdge = this.getRangeAxisEdge();
        double d2 = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i2);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            Point2D point2D2 = null;
            if (point2D != null && this.subplotArea[i2].contains(point2D)) {
                point2D2 = point2D;
            }
            categoryPlot.draw(graphics2D, this.subplotArea[i2], point2D2, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    @Override
    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    @Override
    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.setNotify(false);
        super.setShadowGenerator(shadowGenerator);
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setShadowGenerator(shadowGenerator);
        }
        this.setNotify(true);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            for (CategoryPlot categoryPlot : this.subplots) {
                range = Range.combine(range, categoryPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (CategoryPlot categoryPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setFixedDomainAxisSpace(axisSpace, false);
        }
    }

    @Override
    public void handleClick(int n2, int n3, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n2, n3)) {
            for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
                CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i2);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i2);
                categoryPlot.handleClick(n2, n3, plotRenderingInfo2);
            }
        }
    }

    @Override
    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedRangeCategoryPlot)) {
            return false;
        }
        CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)object;
        if (this.gap != combinedRangeCategoryPlot.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, combinedRangeCategoryPlot.subplots)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)super.clone();
        combinedRangeCategoryPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedRangeCategoryPlot.subplots) {
            plot.setParent(combinedRangeCategoryPlot);
        }
        ValueAxis valueAxis = combinedRangeCategoryPlot.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        return combinedRangeCategoryPlot;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
    }
}

