/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;

public class CombinedDomainXYPlot
extends XYPlot
implements PlotChangeListener {
    private static final long serialVersionUID = -7765545541261907383L;
    private List<XYPlot> subplots = new ArrayList<XYPlot>();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedDomainXYPlot() {
        this(new NumberAxis());
    }

    public CombinedDomainXYPlot(ValueAxis valueAxis) {
        super(null, valueAxis, null, null);
    }

    @Override
    public String getPlotType() {
        return "Combined_Domain_XYPlot";
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d2) {
        this.gap = d2;
        this.fireChangeEvent();
    }

    @Override
    public boolean isRangePannable() {
        for (XYPlot xYPlot : this.subplots) {
            if (!xYPlot.isRangePannable()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setRangePannable(boolean bl2) {
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setRangePannable(bl2);
        }
    }

    @Override
    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setOrientation(plotOrientation);
        }
    }

    @Override
    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.setNotify(false);
        super.setShadowGenerator(shadowGenerator);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setShadowGenerator(shadowGenerator);
        }
        this.setNotify(true);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            for (XYPlot xYPlot : this.subplots) {
                range = Range.combine(range, xYPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    public void add(XYPlot xYPlot) {
        this.add(xYPlot, 1);
    }

    public void add(XYPlot xYPlot, int n2) {
        ParamChecks.nullNotPermitted(xYPlot, "subplot");
        if (n2 <= 0) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        xYPlot.setParent(this);
        xYPlot.setWeight(n2);
        xYPlot.setInsets(RectangleInsets.ZERO_INSETS, false);
        xYPlot.setDomainAxis(null);
        xYPlot.addChangeListener(this);
        this.subplots.add(xYPlot);
        ValueAxis valueAxis = this.getDomainAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(XYPlot xYPlot) {
        ParamChecks.nullNotPermitted(xYPlot, "subplot");
        int n2 = -1;
        int n3 = this.subplots.size();
        for (int i2 = 0; n2 == -1 && i2 < n3; ++i2) {
            if (this.subplots.get(i2) != xYPlot) continue;
            n2 = i2;
        }
        if (n2 != -1) {
            this.subplots.remove(n2);
            xYPlot.setParent(null);
            xYPlot.removeChangeListener(this);
            ValueAxis valueAxis = this.getDomainAxis();
            if (valueAxis != null) {
                valueAxis.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedDomainAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getDomainAxis();
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((ValueAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n2 = this.subplots.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            XYPlot xYPlot = this.subplots.get(i2);
            n3 += xYPlot.getWeight();
        }
        this.subplotAreas = new Rectangle2D[n2];
        double d2 = ((RectangularShape)cloneable).getX();
        double d3 = ((RectangularShape)cloneable).getY();
        double d4 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n2 - 1);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d4 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n2 - 1);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            XYPlot xYPlot = this.subplots.get(i3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d4 * (double)xYPlot.getWeight() / (double)n3;
                this.subplotAreas[i3] = new Rectangle2D.Double(d2, d3, d5, ((RectangularShape)cloneable).getHeight());
                d2 = d2 + d5 + this.gap;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double d6 = d4 * (double)xYPlot.getWeight() / (double)n3;
                this.subplotAreas[i3] = new Rectangle2D.Double(d2, d3, ((RectangularShape)cloneable).getWidth(), d6);
                d3 = d3 + d6 + this.gap;
            }
            AxisSpace axisSpace3 = xYPlot.calculateRangeAxisSpace(graphics2D, this.subplotAreas[i3], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.setFixedRangeAxisSpaceForSubplots(null);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedRangeAxisSpaceForSubplots(axisSpace);
        ValueAxis valueAxis = this.getDomainAxis();
        RectangleEdge rectangleEdge = this.getDomainAxisEdge();
        double d2 = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = valueAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(valueAxis, axisState);
        for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
            XYPlot xYPlot = this.subplots.get(i2);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            xYPlot.draw(graphics2D, this.subplotAreas[i2], point2D, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (XYPlot xYPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d2, plotRenderingInfo, point2D, false);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        XYPlot xYPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot2 != null) {
            xYPlot2.zoomRangeAxes(d2, plotRenderingInfo, point2D, bl2);
        } else {
            for (XYPlot xYPlot2 : this.getSubplots()) {
                xYPlot2.zoomRangeAxes(d2, plotRenderingInfo, point2D, bl2);
            }
        }
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot2 != null) {
            xYPlot2.zoomRangeAxes(d2, d3, plotRenderingInfo, point2D);
        } else {
            for (XYPlot xYPlot2 : this.getSubplots()) {
                xYPlot2.zoomRangeAxes(d2, d3, plotRenderingInfo, point2D);
            }
        }
    }

    @Override
    public void panRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        XYPlot xYPlot = this.findSubplot(plotRenderingInfo, point2D);
        if (xYPlot == null) {
            return;
        }
        if (!xYPlot.isRangePannable()) {
            return;
        }
        PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(plotRenderingInfo.getSubplotIndex(point2D));
        if (plotRenderingInfo2 == null) {
            return;
        }
        for (int i2 = 0; i2 < xYPlot.getRangeAxisCount(); ++i2) {
            ValueAxis valueAxis = xYPlot.getRangeAxis(i2);
            if (valueAxis == null) continue;
            valueAxis.pan(d2);
        }
    }

    public XYPlot findSubplot(PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        ParamChecks.nullNotPermitted(plotRenderingInfo, "info");
        ParamChecks.nullNotPermitted(point2D, "source");
        XYPlot xYPlot = null;
        int n2 = plotRenderingInfo.getSubplotIndex(point2D);
        if (n2 >= 0) {
            xYPlot = this.subplots.get(n2);
        }
        return xYPlot;
    }

    @Override
    public void setRenderer(XYItemRenderer xYItemRenderer) {
        super.setRenderer(xYItemRenderer);
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setRenderer(xYItemRenderer);
        }
    }

    @Override
    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        super.setFixedRangeAxisSpace(axisSpace);
        this.setFixedRangeAxisSpaceForSubplots(axisSpace);
        this.fireChangeEvent();
    }

    protected void setFixedRangeAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (XYPlot xYPlot : this.subplots) {
            xYPlot.setFixedRangeAxisSpace(axisSpace, false);
        }
    }

    @Override
    public void handleClick(int n2, int n3, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n2, n3)) {
            for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
                XYPlot xYPlot = this.subplots.get(i2);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i2);
                xYPlot.handleClick(n2, n3, plotRenderingInfo2);
            }
        }
    }

    @Override
    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedDomainXYPlot)) {
            return false;
        }
        CombinedDomainXYPlot combinedDomainXYPlot = (CombinedDomainXYPlot)object;
        if (this.gap != combinedDomainXYPlot.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, combinedDomainXYPlot.subplots)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        CombinedDomainXYPlot combinedDomainXYPlot = (CombinedDomainXYPlot)super.clone();
        combinedDomainXYPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedDomainXYPlot.subplots) {
            plot.setParent(combinedDomainXYPlot);
        }
        ValueAxis valueAxis = combinedDomainXYPlot.getDomainAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        return combinedDomainXYPlot;
    }
}

