/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.PlotChangeListener;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;

public class CombinedDomainCategoryPlot
extends CategoryPlot
implements PlotChangeListener {
    private static final long serialVersionUID = 8207194522653701572L;
    private List subplots = new ArrayList();
    private double gap = 5.0;
    private transient Rectangle2D[] subplotAreas;

    public CombinedDomainCategoryPlot() {
        this(new CategoryAxis());
    }

    public CombinedDomainCategoryPlot(CategoryAxis categoryAxis) {
        super(null, categoryAxis, null, null);
    }

    public double getGap() {
        return this.gap;
    }

    public void setGap(double d2) {
        this.gap = d2;
        this.fireChangeEvent();
    }

    public void add(CategoryPlot categoryPlot) {
        this.add(categoryPlot, 1);
    }

    public void add(CategoryPlot categoryPlot, int n2) {
        ParamChecks.nullNotPermitted(categoryPlot, "subplot");
        if (n2 < 1) {
            throw new IllegalArgumentException("Require weight >= 1.");
        }
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n2);
        categoryPlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0));
        categoryPlot.setDomainAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        categoryPlot.addChangeListener(this);
        this.subplots.add(categoryPlot);
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            categoryAxis.configure();
        }
        this.fireChangeEvent();
    }

    public void remove(CategoryPlot categoryPlot) {
        ParamChecks.nullNotPermitted(categoryPlot, "subplot");
        int n2 = -1;
        int n3 = this.subplots.size();
        for (int i2 = 0; n2 == -1 && i2 < n3; ++i2) {
            if (this.subplots.get(i2) != categoryPlot) continue;
            n2 = i2;
        }
        if (n2 != -1) {
            this.subplots.remove(n2);
            categoryPlot.setParent(null);
            categoryPlot.removeChangeListener(this);
            CategoryAxis categoryAxis = this.getDomainAxis();
            if (categoryAxis != null) {
                categoryAxis.configure();
            }
            this.fireChangeEvent();
        }
    }

    public List getSubplots() {
        if (this.subplots != null) {
            return Collections.unmodifiableList(this.subplots);
        }
        return Collections.EMPTY_LIST;
    }

    public CategoryPlot findSubplot(PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        ParamChecks.nullNotPermitted(plotRenderingInfo, "info");
        ParamChecks.nullNotPermitted(point2D, "source");
        CategoryPlot categoryPlot = null;
        int n2 = plotRenderingInfo.getSubplotIndex(point2D);
        if (n2 >= 0) {
            categoryPlot = (CategoryPlot)this.subplots.get(n2);
        }
        return categoryPlot;
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d2, plotRenderingInfo, point2D, false);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        CategoryPlot categoryPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (categoryPlot2 != null) {
            categoryPlot2.zoomRangeAxes(d2, plotRenderingInfo, point2D, bl2);
        } else {
            for (CategoryPlot categoryPlot2 : this.getSubplots()) {
                categoryPlot2.zoomRangeAxes(d2, plotRenderingInfo, point2D, bl2);
            }
        }
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        CategoryPlot categoryPlot2 = this.findSubplot(plotRenderingInfo, point2D);
        if (categoryPlot2 != null) {
            categoryPlot2.zoomRangeAxes(d2, d3, plotRenderingInfo, point2D);
        } else {
            for (CategoryPlot categoryPlot2 : this.getSubplots()) {
                categoryPlot2.zoomRangeAxes(d2, d3, plotRenderingInfo, point2D);
            }
        }
    }

    @Override
    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedDomainAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getDomainAxis();
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((CategoryAxis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            } else if (this.getDrawSharedDomainAxis()) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n2 = this.subplots.size();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i2);
            n3 += categoryPlot.getWeight();
        }
        this.subplotAreas = new Rectangle2D[n2];
        double d2 = ((RectangularShape)cloneable).getX();
        double d3 = ((RectangularShape)cloneable).getY();
        double d4 = 0.0;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d4 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n2 - 1);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d4 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n2 - 1);
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d4 * (double)categoryPlot.getWeight() / (double)n3;
                this.subplotAreas[i3] = new Rectangle2D.Double(d2, d3, d5, ((RectangularShape)cloneable).getHeight());
                d2 = d2 + d5 + this.gap;
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double d6 = d4 * (double)categoryPlot.getWeight() / (double)n3;
                this.subplotAreas[i3] = new Rectangle2D.Double(d2, d3, ((RectangularShape)cloneable).getWidth(), d6);
                d3 = d3 + d6 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateRangeAxisSpace(graphics2D, this.subplotAreas[i3], null);
            axisSpace.ensureAtLeast(axisSpace3);
        }
        return axisSpace;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangle2D.setRect(rectangle2D.getX() + rectangleInsets.getLeft(), rectangle2D.getY() + rectangleInsets.getTop(), rectangle2D.getWidth() - rectangleInsets.getLeft() - rectangleInsets.getRight(), rectangle2D.getHeight() - rectangleInsets.getTop() - rectangleInsets.getBottom());
        this.setFixedRangeAxisSpaceForSubplots(null);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedRangeAxisSpaceForSubplots(axisSpace);
        CategoryAxis categoryAxis = this.getDomainAxis();
        RectangleEdge rectangleEdge = this.getDomainAxisEdge();
        double d2 = RectangleEdge.coordinate(rectangle2D2, rectangleEdge);
        AxisState axisState = categoryAxis.draw(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge, plotRenderingInfo);
        if (plotState == null) {
            plotState = new PlotState();
        }
        plotState.getSharedAxisStates().put(categoryAxis, axisState);
        for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i2);
            PlotRenderingInfo plotRenderingInfo2 = null;
            if (plotRenderingInfo != null) {
                plotRenderingInfo2 = new PlotRenderingInfo(plotRenderingInfo.getOwner());
                plotRenderingInfo.addSubplotInfo(plotRenderingInfo2);
            }
            Point2D point2D2 = null;
            if (point2D != null && this.subplotAreas[i2].contains(point2D)) {
                point2D2 = point2D;
            }
            categoryPlot.draw(graphics2D, this.subplotAreas[i2], point2D2, plotState, plotRenderingInfo2);
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setDataArea(rectangle2D2);
        }
    }

    protected void setFixedRangeAxisSpaceForSubplots(AxisSpace axisSpace) {
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setFixedRangeAxisSpace(axisSpace, false);
        }
    }

    @Override
    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    @Override
    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.setNotify(false);
        super.setShadowGenerator(shadowGenerator);
        for (CategoryPlot categoryPlot : this.subplots) {
            categoryPlot.setShadowGenerator(shadowGenerator);
        }
        this.setNotify(true);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        return super.getDataRange(valueAxis);
    }

    @Override
    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = this.getFixedLegendItems();
        if (legendItemCollection == null) {
            legendItemCollection = new LegendItemCollection();
            if (this.subplots != null) {
                for (CategoryPlot categoryPlot : this.subplots) {
                    LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                    legendItemCollection.addAll(legendItemCollection2);
                }
            }
        }
        return legendItemCollection;
    }

    @Override
    public List getCategories() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        if (this.subplots != null) {
            for (CategoryPlot categoryPlot : this.subplots) {
                List list = categoryPlot.getCategories();
                for (Comparable comparable : list) {
                    if (arrayList.contains(comparable)) continue;
                    arrayList.add(comparable);
                }
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public List getCategoriesForAxis(CategoryAxis categoryAxis) {
        return this.getCategories();
    }

    @Override
    public void handleClick(int n2, int n3, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n2, n3)) {
            for (int i2 = 0; i2 < this.subplots.size(); ++i2) {
                CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(i2);
                PlotRenderingInfo plotRenderingInfo2 = plotRenderingInfo.getSubplotInfo(i2);
                categoryPlot.handleClick(n2, n3, plotRenderingInfo2);
            }
        }
    }

    @Override
    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        this.notifyListeners(plotChangeEvent);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CombinedDomainCategoryPlot)) {
            return false;
        }
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)object;
        if (this.gap != combinedDomainCategoryPlot.gap) {
            return false;
        }
        if (!ObjectUtilities.equal(this.subplots, combinedDomainCategoryPlot.subplots)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        CombinedDomainCategoryPlot combinedDomainCategoryPlot = (CombinedDomainCategoryPlot)super.clone();
        combinedDomainCategoryPlot.subplots = (List)ObjectUtilities.deepClone(this.subplots);
        for (Plot plot : combinedDomainCategoryPlot.subplots) {
            plot.setParent(combinedDomainCategoryPlot);
        }
        return combinedDomainCategoryPlot;
    }
}

