/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.annotations.CategoryAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisCollection;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.event.AnnotationChangeEvent;
import org.jfree.chart.event.AnnotationChangeListener;
import org.jfree.chart.event.ChartChangeEventType;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.CategoryCrosshairState;
import org.jfree.chart.plot.CategoryMarker;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Pannable;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.plot.Zoomable;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.util.CloneUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.chart.util.ShadowGenerator;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;
import org.jfree.util.SortOrder;

public class CategoryPlot
extends Plot
implements Serializable,
Cloneable,
AnnotationChangeListener,
RendererChangeListener,
Pannable,
ValueAxisPlot,
Zoomable,
PublicCloneable {
    private static final long serialVersionUID = -3537691700434728188L;
    public static final boolean DEFAULT_DOMAIN_GRIDLINES_VISIBLE = false;
    public static final boolean DEFAULT_RANGE_GRIDLINES_VISIBLE = true;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final Font DEFAULT_VALUE_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation;
    private RectangleInsets axisOffset;
    private Map<Integer, CategoryAxis> domainAxes;
    private Map<Integer, AxisLocation> domainAxisLocations;
    private boolean drawSharedDomainAxis;
    private Map<Integer, ValueAxis> rangeAxes;
    private Map<Integer, AxisLocation> rangeAxisLocations;
    private Map<Integer, CategoryDataset> datasets;
    private TreeMap datasetToDomainAxesMap;
    private TreeMap datasetToRangeAxesMap;
    private Map<Integer, CategoryItemRenderer> renderers;
    private DatasetRenderingOrder renderingOrder = DatasetRenderingOrder.REVERSE;
    private SortOrder columnRenderingOrder = SortOrder.ASCENDING;
    private SortOrder rowRenderingOrder = SortOrder.ASCENDING;
    private boolean domainGridlinesVisible;
    private CategoryAnchor domainGridlinePosition;
    private transient Stroke domainGridlineStroke;
    private transient Paint domainGridlinePaint;
    private boolean rangeZeroBaselineVisible;
    private transient Stroke rangeZeroBaselineStroke;
    private transient Paint rangeZeroBaselinePaint;
    private boolean rangeGridlinesVisible;
    private transient Stroke rangeGridlineStroke;
    private transient Paint rangeGridlinePaint;
    private boolean rangeMinorGridlinesVisible;
    private transient Stroke rangeMinorGridlineStroke;
    private transient Paint rangeMinorGridlinePaint;
    private double anchorValue;
    private int crosshairDatasetIndex;
    private boolean domainCrosshairVisible;
    private Comparable domainCrosshairRowKey;
    private Comparable domainCrosshairColumnKey;
    private transient Stroke domainCrosshairStroke;
    private transient Paint domainCrosshairPaint;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private transient Stroke rangeCrosshairStroke;
    private transient Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private Map foregroundDomainMarkers;
    private Map backgroundDomainMarkers;
    private Map foregroundRangeMarkers;
    private Map backgroundRangeMarkers;
    private List annotations;
    private int weight;
    private AxisSpace fixedDomainAxisSpace;
    private AxisSpace fixedRangeAxisSpace;
    private LegendItemCollection fixedLegendItems;
    private boolean rangePannable;
    private ShadowGenerator shadowGenerator;

    public CategoryPlot() {
        this(null, null, null, null);
    }

    public CategoryPlot(CategoryDataset categoryDataset, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryItemRenderer categoryItemRenderer) {
        this.orientation = PlotOrientation.VERTICAL;
        this.domainAxes = new HashMap<Integer, CategoryAxis>();
        this.domainAxisLocations = new HashMap<Integer, AxisLocation>();
        this.rangeAxes = new HashMap<Integer, ValueAxis>();
        this.rangeAxisLocations = new HashMap<Integer, AxisLocation>();
        this.datasetToDomainAxesMap = new TreeMap();
        this.datasetToRangeAxesMap = new TreeMap();
        this.renderers = new HashMap<Integer, CategoryItemRenderer>();
        this.datasets = new HashMap<Integer, CategoryDataset>();
        this.datasets.put(0, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.axisOffset = RectangleInsets.ZERO_INSETS;
        this.domainAxisLocations.put(0, AxisLocation.BOTTOM_OR_LEFT);
        this.rangeAxisLocations.put(0, AxisLocation.TOP_OR_LEFT);
        this.renderers.put(0, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.domainAxes.put(0, categoryAxis);
        this.mapDatasetToDomainAxis(0, 0);
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
            categoryAxis.addChangeListener(this);
        }
        this.drawSharedDomainAxis = false;
        this.rangeAxes.put(0, valueAxis);
        this.mapDatasetToRangeAxis(0, 0);
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        this.domainGridlinesVisible = false;
        this.domainGridlinePosition = CategoryAnchor.MIDDLE;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeZeroBaselineVisible = false;
        this.rangeZeroBaselinePaint = Color.black;
        this.rangeZeroBaselineStroke = new BasicStroke(0.5f);
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeMinorGridlinesVisible = false;
        this.rangeMinorGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeMinorGridlinePaint = Color.white;
        this.foregroundDomainMarkers = new HashMap();
        this.backgroundDomainMarkers = new HashMap();
        this.foregroundRangeMarkers = new HashMap();
        this.backgroundRangeMarkers = new HashMap();
        this.anchorValue = 0.0;
        this.domainCrosshairVisible = false;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.annotations = new ArrayList();
        this.rangePannable = false;
        this.shadowGenerator = null;
    }

    @Override
    public String getPlotType() {
        return localizationResources.getString("Category_Plot");
    }

    @Override
    public PlotOrientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        ParamChecks.nullNotPermitted(plotOrientation, "orientation");
        this.orientation = plotOrientation;
        this.fireChangeEvent();
    }

    public RectangleInsets getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(RectangleInsets rectangleInsets) {
        ParamChecks.nullNotPermitted(rectangleInsets, "offset");
        this.axisOffset = rectangleInsets;
        this.fireChangeEvent();
    }

    public CategoryAxis getDomainAxis() {
        return this.getDomainAxis(0);
    }

    public CategoryAxis getDomainAxis(int n2) {
        Plot plot;
        CategoryAxis categoryAxis = this.domainAxes.get(n2);
        if (categoryAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            categoryAxis = categoryPlot.getDomainAxis(n2);
        }
        return categoryAxis;
    }

    public void setDomainAxis(CategoryAxis categoryAxis) {
        this.setDomainAxis(0, categoryAxis);
    }

    public void setDomainAxis(int n2, CategoryAxis categoryAxis) {
        this.setDomainAxis(n2, categoryAxis, true);
    }

    public void setDomainAxis(int n2, CategoryAxis categoryAxis, boolean bl2) {
        CategoryAxis categoryAxis2 = this.domainAxes.get(n2);
        if (categoryAxis2 != null) {
            categoryAxis2.removeChangeListener(this);
        }
        if (categoryAxis != null) {
            categoryAxis.setPlot(this);
        }
        this.domainAxes.put(n2, categoryAxis);
        if (categoryAxis != null) {
            categoryAxis.configure();
            categoryAxis.addChangeListener(this);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setDomainAxes(CategoryAxis[] categoryAxisArray) {
        for (int i2 = 0; i2 < categoryAxisArray.length; ++i2) {
            this.setDomainAxis(i2, categoryAxisArray[i2], false);
        }
        this.fireChangeEvent();
    }

    public int getDomainAxisIndex(CategoryAxis categoryAxis) {
        ParamChecks.nullNotPermitted(categoryAxis, "axis");
        for (Map.Entry<Integer, CategoryAxis> entry : this.domainAxes.entrySet()) {
            if (entry.getValue() != categoryAxis) continue;
            return entry.getKey();
        }
        return -1;
    }

    public AxisLocation getDomainAxisLocation() {
        return this.getDomainAxisLocation(0);
    }

    public AxisLocation getDomainAxisLocation(int n2) {
        AxisLocation axisLocation = this.domainAxisLocations.get(n2);
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getDomainAxisLocation(0));
        }
        return axisLocation;
    }

    public void setDomainAxisLocation(AxisLocation axisLocation) {
        this.setDomainAxisLocation(0, axisLocation, true);
    }

    public void setDomainAxisLocation(AxisLocation axisLocation, boolean bl2) {
        this.setDomainAxisLocation(0, axisLocation, bl2);
    }

    public void setDomainAxisLocation(int n2, AxisLocation axisLocation) {
        this.setDomainAxisLocation(n2, axisLocation, true);
    }

    public void setDomainAxisLocation(int n2, AxisLocation axisLocation, boolean bl2) {
        if (n2 == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.domainAxisLocations.put(n2, axisLocation);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getDomainAxisEdge() {
        return this.getDomainAxisEdge(0);
    }

    public RectangleEdge getDomainAxisEdge(int n2) {
        AxisLocation axisLocation = this.getDomainAxisLocation(n2);
        RectangleEdge rectangleEdge = axisLocation != null ? Plot.resolveDomainAxisLocation(axisLocation, this.orientation) : RectangleEdge.opposite(this.getDomainAxisEdge(0));
        return rectangleEdge;
    }

    public int getDomainAxisCount() {
        return this.domainAxes.size();
    }

    public void clearDomainAxes() {
        for (CategoryAxis categoryAxis : this.domainAxes.values()) {
            if (categoryAxis == null) continue;
            categoryAxis.removeChangeListener(this);
        }
        this.domainAxes.clear();
        this.fireChangeEvent();
    }

    public void configureDomainAxes() {
        for (CategoryAxis categoryAxis : this.domainAxes.values()) {
            if (categoryAxis == null) continue;
            categoryAxis.configure();
        }
    }

    public ValueAxis getRangeAxis() {
        return this.getRangeAxis(0);
    }

    public ValueAxis getRangeAxis(int n2) {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxes.get(n2);
        if (valueAxis == null && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            valueAxis = categoryPlot.getRangeAxis(n2);
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) {
        this.setRangeAxis(0, valueAxis);
    }

    public void setRangeAxis(int n2, ValueAxis valueAxis) {
        this.setRangeAxis(n2, valueAxis, true);
    }

    public void setRangeAxis(int n2, ValueAxis valueAxis, boolean bl2) {
        ValueAxis valueAxis2 = this.rangeAxes.get(n2);
        if (valueAxis2 != null) {
            valueAxis2.removeChangeListener(this);
        }
        if (valueAxis != null) {
            valueAxis.setPlot(this);
        }
        this.rangeAxes.put(n2, valueAxis);
        if (valueAxis != null) {
            valueAxis.configure();
            valueAxis.addChangeListener(this);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setRangeAxes(ValueAxis[] valueAxisArray) {
        for (int i2 = 0; i2 < valueAxisArray.length; ++i2) {
            this.setRangeAxis(i2, valueAxisArray[i2], false);
        }
        this.fireChangeEvent();
    }

    public int getRangeAxisIndex(ValueAxis valueAxis) {
        Plot plot;
        ParamChecks.nullNotPermitted(valueAxis, "axis");
        int n2 = this.findRangeAxisIndex(valueAxis);
        if (n2 < 0 && (plot = this.getParent()) instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            n2 = categoryPlot.getRangeAxisIndex(valueAxis);
        }
        return n2;
    }

    private int findRangeAxisIndex(ValueAxis valueAxis) {
        for (Map.Entry<Integer, ValueAxis> entry : this.rangeAxes.entrySet()) {
            if (entry.getValue() != valueAxis) continue;
            return entry.getKey();
        }
        return -1;
    }

    public AxisLocation getRangeAxisLocation() {
        return this.getRangeAxisLocation(0);
    }

    public AxisLocation getRangeAxisLocation(int n2) {
        AxisLocation axisLocation = this.rangeAxisLocations.get(n2);
        if (axisLocation == null) {
            axisLocation = AxisLocation.getOpposite(this.getRangeAxisLocation(0));
        }
        return axisLocation;
    }

    public void setRangeAxisLocation(AxisLocation axisLocation) {
        this.setRangeAxisLocation(axisLocation, true);
    }

    public void setRangeAxisLocation(AxisLocation axisLocation, boolean bl2) {
        this.setRangeAxisLocation(0, axisLocation, bl2);
    }

    public void setRangeAxisLocation(int n2, AxisLocation axisLocation) {
        this.setRangeAxisLocation(n2, axisLocation, true);
    }

    public void setRangeAxisLocation(int n2, AxisLocation axisLocation, boolean bl2) {
        if (n2 == 0 && axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' for index 0 not permitted.");
        }
        this.rangeAxisLocations.put(n2, axisLocation);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public RectangleEdge getRangeAxisEdge() {
        return this.getRangeAxisEdge(0);
    }

    public RectangleEdge getRangeAxisEdge(int n2) {
        AxisLocation axisLocation = this.getRangeAxisLocation(n2);
        return Plot.resolveRangeAxisLocation(axisLocation, this.orientation);
    }

    public int getRangeAxisCount() {
        return this.rangeAxes.size();
    }

    public void clearRangeAxes() {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.removeChangeListener(this);
        }
        this.rangeAxes.clear();
        this.fireChangeEvent();
    }

    public void configureRangeAxes() {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
    }

    public CategoryDataset getDataset() {
        return this.getDataset(0);
    }

    public CategoryDataset getDataset(int n2) {
        return this.datasets.get(n2);
    }

    public void setDataset(CategoryDataset categoryDataset) {
        this.setDataset(0, categoryDataset);
    }

    public void setDataset(int n2, CategoryDataset categoryDataset) {
        CategoryDataset categoryDataset2 = this.datasets.get(n2);
        if (categoryDataset2 != null) {
            categoryDataset2.removeChangeListener(this);
        }
        this.datasets.put(n2, categoryDataset);
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, categoryDataset);
        this.datasetChanged(datasetChangeEvent);
    }

    public int getDatasetCount() {
        return this.datasets.size();
    }

    public int indexOf(CategoryDataset categoryDataset) {
        for (Map.Entry<Integer, CategoryDataset> entry : this.datasets.entrySet()) {
            if (entry.getValue() != categoryDataset) continue;
            return entry.getKey();
        }
        return -1;
    }

    public void mapDatasetToDomainAxis(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(n3);
        this.mapDatasetToDomainAxes(n2, arrayList);
    }

    public void mapDatasetToDomainAxes(int n2, List list) {
        ParamChecks.requireNonNegative(n2, "index");
        this.checkAxisIndices(list);
        this.datasetToDomainAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n2)));
    }

    private void checkAxisIndices(List list) {
        if (list == null) {
            return;
        }
        int n2 = list.size();
        if (n2 == 0) {
            throw new IllegalArgumentException("Empty list not permitted.");
        }
        HashSet hashSet = new HashSet();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = list.get(i2);
            if (!(e2 instanceof Integer)) {
                throw new IllegalArgumentException("Indices must be Integer instances.");
            }
            if (hashSet.contains(e2)) {
                throw new IllegalArgumentException("Indices must be unique.");
            }
            hashSet.add(e2);
        }
    }

    public CategoryAxis getDomainAxisForDataset(int n2) {
        CategoryAxis categoryAxis;
        ParamChecks.requireNonNegative(n2, "index");
        List list = (List)this.datasetToDomainAxesMap.get(new Integer(n2));
        if (list != null) {
            Integer n3 = (Integer)list.get(0);
            categoryAxis = this.getDomainAxis(n3);
        } else {
            categoryAxis = this.getDomainAxis(0);
        }
        return categoryAxis;
    }

    public void mapDatasetToRangeAxis(int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(1);
        arrayList.add(new Integer(n3));
        this.mapDatasetToRangeAxes(n2, arrayList);
    }

    public void mapDatasetToRangeAxes(int n2, List list) {
        ParamChecks.requireNonNegative(n2, "index");
        this.checkAxisIndices(list);
        this.datasetToRangeAxesMap.put(n2, new ArrayList(list));
        this.datasetChanged(new DatasetChangeEvent(this, this.getDataset(n2)));
    }

    public ValueAxis getRangeAxisForDataset(int n2) {
        ValueAxis valueAxis;
        ParamChecks.requireNonNegative(n2, "index");
        List list = (List)this.datasetToRangeAxesMap.get(new Integer(n2));
        if (list != null) {
            Integer n3 = (Integer)list.get(0);
            valueAxis = this.getRangeAxis(n3);
        } else {
            valueAxis = this.getRangeAxis(0);
        }
        return valueAxis;
    }

    public int getRendererCount() {
        return this.renderers.size();
    }

    public CategoryItemRenderer getRenderer() {
        return this.getRenderer(0);
    }

    public CategoryItemRenderer getRenderer(int n2) {
        CategoryItemRenderer categoryItemRenderer = this.renderers.get(n2);
        if (categoryItemRenderer == null) {
            return this.renderers.get(0);
        }
        return categoryItemRenderer;
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(0, categoryItemRenderer, true);
    }

    public void setRenderer(CategoryItemRenderer categoryItemRenderer, boolean bl2) {
        this.setRenderer(0, categoryItemRenderer, bl2);
    }

    public void setRenderer(int n2, CategoryItemRenderer categoryItemRenderer) {
        this.setRenderer(n2, categoryItemRenderer, true);
    }

    public void setRenderer(int n2, CategoryItemRenderer categoryItemRenderer, boolean bl2) {
        CategoryItemRenderer categoryItemRenderer2 = this.renderers.get(n2);
        if (categoryItemRenderer2 != null) {
            categoryItemRenderer2.removeChangeListener(this);
        }
        this.renderers.put(n2, categoryItemRenderer);
        if (categoryItemRenderer != null) {
            categoryItemRenderer.setPlot(this);
            categoryItemRenderer.addChangeListener(this);
        }
        this.configureDomainAxes();
        this.configureRangeAxes();
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void setRenderers(CategoryItemRenderer[] categoryItemRendererArray) {
        for (int i2 = 0; i2 < categoryItemRendererArray.length; ++i2) {
            this.setRenderer(i2, categoryItemRendererArray[i2], false);
        }
        this.fireChangeEvent();
    }

    public CategoryItemRenderer getRendererForDataset(CategoryDataset categoryDataset) {
        int n2 = this.indexOf(categoryDataset);
        if (n2 < 0) {
            return null;
        }
        CategoryItemRenderer categoryItemRenderer = this.renderers.get(n2);
        if (categoryItemRenderer == null) {
            return this.getRenderer();
        }
        return categoryItemRenderer;
    }

    public int getIndexOf(CategoryItemRenderer categoryItemRenderer) {
        for (Map.Entry<Integer, CategoryItemRenderer> entry : this.renderers.entrySet()) {
            if (entry.getValue() != categoryItemRenderer) continue;
            return entry.getKey();
        }
        return -1;
    }

    public DatasetRenderingOrder getDatasetRenderingOrder() {
        return this.renderingOrder;
    }

    public void setDatasetRenderingOrder(DatasetRenderingOrder datasetRenderingOrder) {
        ParamChecks.nullNotPermitted(datasetRenderingOrder, "order");
        this.renderingOrder = datasetRenderingOrder;
        this.fireChangeEvent();
    }

    public SortOrder getColumnRenderingOrder() {
        return this.columnRenderingOrder;
    }

    public void setColumnRenderingOrder(SortOrder sortOrder) {
        ParamChecks.nullNotPermitted(sortOrder, "order");
        this.columnRenderingOrder = sortOrder;
        this.fireChangeEvent();
    }

    public SortOrder getRowRenderingOrder() {
        return this.rowRenderingOrder;
    }

    public void setRowRenderingOrder(SortOrder sortOrder) {
        ParamChecks.nullNotPermitted(sortOrder, "order");
        this.rowRenderingOrder = sortOrder;
        this.fireChangeEvent();
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl2) {
        if (this.domainGridlinesVisible != bl2) {
            this.domainGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public CategoryAnchor getDomainGridlinePosition() {
        return this.domainGridlinePosition;
    }

    public void setDomainGridlinePosition(CategoryAnchor categoryAnchor) {
        ParamChecks.nullNotPermitted(categoryAnchor, "position");
        this.domainGridlinePosition = categoryAnchor;
        this.fireChangeEvent();
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeZeroBaselineVisible() {
        return this.rangeZeroBaselineVisible;
    }

    public void setRangeZeroBaselineVisible(boolean bl2) {
        this.rangeZeroBaselineVisible = bl2;
        this.fireChangeEvent();
    }

    public Stroke getRangeZeroBaselineStroke() {
        return this.rangeZeroBaselineStroke;
    }

    public void setRangeZeroBaselineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeZeroBaselineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeZeroBaselinePaint() {
        return this.rangeZeroBaselinePaint;
    }

    public void setRangeZeroBaselinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeZeroBaselinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl2) {
        if (this.rangeGridlinesVisible != bl2) {
            this.rangeGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public boolean isRangeMinorGridlinesVisible() {
        return this.rangeMinorGridlinesVisible;
    }

    public void setRangeMinorGridlinesVisible(boolean bl2) {
        if (this.rangeMinorGridlinesVisible != bl2) {
            this.rangeMinorGridlinesVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeMinorGridlineStroke() {
        return this.rangeMinorGridlineStroke;
    }

    public void setRangeMinorGridlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeMinorGridlineStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeMinorGridlinePaint() {
        return this.rangeMinorGridlinePaint;
    }

    public void setRangeMinorGridlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeMinorGridlinePaint = paint;
        this.fireChangeEvent();
    }

    public LegendItemCollection getFixedLegendItems() {
        return this.fixedLegendItems;
    }

    public void setFixedLegendItems(LegendItemCollection legendItemCollection) {
        this.fixedLegendItems = legendItemCollection;
        this.fireChangeEvent();
    }

    @Override
    public LegendItemCollection getLegendItems() {
        if (this.fixedLegendItems != null) {
            return this.fixedLegendItems;
        }
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        for (CategoryDataset categoryDataset : this.datasets.values()) {
            int n2;
            CategoryItemRenderer categoryItemRenderer;
            if (categoryDataset == null || (categoryItemRenderer = this.getRenderer(n2 = this.indexOf(categoryDataset))) == null) continue;
            legendItemCollection.addAll(categoryItemRenderer.getLegendItems());
        }
        return legendItemCollection;
    }

    @Override
    public void handleClick(int n2, int n3, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D rectangle2D = plotRenderingInfo.getDataArea();
        if (rectangle2D.contains(n2, n3)) {
            double d2 = 0.0;
            if (this.orientation == PlotOrientation.HORIZONTAL) {
                d2 = n2;
            } else if (this.orientation == PlotOrientation.VERTICAL) {
                d2 = n3;
            }
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), this.orientation);
            double d3 = this.getRangeAxis().java2DToValue(d2, plotRenderingInfo.getDataArea(), rectangleEdge);
            this.setAnchorValue(d3);
            this.setRangeCrosshairValue(d3);
        }
    }

    @Override
    public void zoom(double d2) {
        if (d2 > 0.0) {
            double d3 = this.getRangeAxis().getRange().getLength();
            double d4 = d3 * d2;
            this.getRangeAxis().setRange(this.anchorValue - d4 / 2.0, this.anchorValue + d4 / 2.0);
        } else {
            this.getRangeAxis().setAutoRange(true);
        }
    }

    @Override
    public void annotationChanged(AnnotationChangeEvent annotationChangeEvent) {
        if (this.getParent() != null) {
            this.getParent().annotationChanged(annotationChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            plotChangeEvent.setType(ChartChangeEventType.DATASET_UPDATED);
            this.notifyListeners(plotChangeEvent);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        Plot plot = this.getParent();
        if (plot != null) {
            if (!(plot instanceof RendererChangeListener)) throw new RuntimeException("The renderer has changed and I don't know what to do!");
            RendererChangeListener rendererChangeListener = (RendererChangeListener)((Object)plot);
            rendererChangeListener.rendererChanged(rendererChangeEvent);
            return;
        } else {
            this.configureRangeAxes();
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public void addDomainMarker(CategoryMarker categoryMarker) {
        this.addDomainMarker(categoryMarker, Layer.FOREGROUND);
    }

    public void addDomainMarker(CategoryMarker categoryMarker, Layer layer) {
        this.addDomainMarker(0, categoryMarker, layer);
    }

    public void addDomainMarker(int n2, CategoryMarker categoryMarker, Layer layer) {
        this.addDomainMarker(n2, categoryMarker, layer, true);
    }

    public void addDomainMarker(int n2, CategoryMarker categoryMarker, Layer layer, boolean bl2) {
        ParamChecks.nullNotPermitted(categoryMarker, "marker");
        ParamChecks.nullNotPermitted(layer, "layer");
        if (layer == Layer.FOREGROUND) {
            ArrayList<CategoryMarker> arrayList = (ArrayList<CategoryMarker>)this.foregroundDomainMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<CategoryMarker>();
                this.foregroundDomainMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(categoryMarker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<CategoryMarker> arrayList = (ArrayList<CategoryMarker>)this.backgroundDomainMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<CategoryMarker>();
                this.backgroundDomainMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(categoryMarker);
        }
        categoryMarker.addChangeListener(this);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void clearDomainMarkers() {
        Set set;
        if (this.backgroundDomainMarkers != null) {
            set = this.backgroundDomainMarkers.keySet();
            for (Integer n2 : set) {
                this.clearDomainMarkers(n2);
            }
            this.backgroundDomainMarkers.clear();
        }
        if (this.foregroundDomainMarkers != null) {
            set = this.foregroundDomainMarkers.keySet();
            for (Integer n2 : set) {
                this.clearDomainMarkers(n2);
            }
            this.foregroundDomainMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public Collection getDomainMarkers(Layer layer) {
        return this.getDomainMarkers(0, layer);
    }

    public Collection getDomainMarkers(int n2, Layer layer) {
        Collection collection = null;
        Integer n3 = new Integer(n2);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundDomainMarkers.get(n3);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundDomainMarkers.get(n3);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearDomainMarkers(int n2) {
        Collection collection;
        Integer n3 = new Integer(n2);
        if (this.backgroundDomainMarkers != null && (collection = (Collection)this.backgroundDomainMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundDomainMarkers != null && (collection = (Collection)this.foregroundDomainMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeDomainMarker(Marker marker) {
        return this.removeDomainMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeDomainMarker(Marker marker, Layer layer) {
        return this.removeDomainMarker(0, marker, layer);
    }

    public boolean removeDomainMarker(int n2, Marker marker, Layer layer) {
        return this.removeDomainMarker(n2, marker, layer, true);
    }

    public boolean removeDomainMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundDomainMarkers.get(new Integer(n2)) : (ArrayList)this.backgroundDomainMarkers.get(new Integer(n2));
        if (arrayList == null) {
            return false;
        }
        boolean bl3 = arrayList.remove(marker);
        if (bl3 && bl2) {
            this.fireChangeEvent();
        }
        return bl3;
    }

    public void addRangeMarker(Marker marker) {
        this.addRangeMarker(marker, Layer.FOREGROUND);
    }

    public void addRangeMarker(Marker marker, Layer layer) {
        this.addRangeMarker(0, marker, layer);
    }

    public void addRangeMarker(int n2, Marker marker, Layer layer) {
        this.addRangeMarker(n2, marker, layer, true);
    }

    public void addRangeMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        if (layer == Layer.FOREGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.foregroundRangeMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.foregroundRangeMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(marker);
        } else if (layer == Layer.BACKGROUND) {
            ArrayList<Marker> arrayList = (ArrayList<Marker>)this.backgroundRangeMarkers.get(new Integer(n2));
            if (arrayList == null) {
                arrayList = new ArrayList<Marker>();
                this.backgroundRangeMarkers.put(new Integer(n2), arrayList);
            }
            arrayList.add(marker);
        }
        marker.addChangeListener(this);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public void clearRangeMarkers() {
        Set set;
        if (this.backgroundRangeMarkers != null) {
            set = this.backgroundRangeMarkers.keySet();
            for (Integer n2 : set) {
                this.clearRangeMarkers(n2);
            }
            this.backgroundRangeMarkers.clear();
        }
        if (this.foregroundRangeMarkers != null) {
            set = this.foregroundRangeMarkers.keySet();
            for (Integer n2 : set) {
                this.clearRangeMarkers(n2);
            }
            this.foregroundRangeMarkers.clear();
        }
        this.fireChangeEvent();
    }

    public Collection getRangeMarkers(Layer layer) {
        return this.getRangeMarkers(0, layer);
    }

    public Collection getRangeMarkers(int n2, Layer layer) {
        Collection collection = null;
        Integer n3 = new Integer(n2);
        if (layer == Layer.FOREGROUND) {
            collection = (Collection)this.foregroundRangeMarkers.get(n3);
        } else if (layer == Layer.BACKGROUND) {
            collection = (Collection)this.backgroundRangeMarkers.get(n3);
        }
        if (collection != null) {
            collection = Collections.unmodifiableCollection(collection);
        }
        return collection;
    }

    public void clearRangeMarkers(int n2) {
        Collection collection;
        Integer n3 = new Integer(n2);
        if (this.backgroundRangeMarkers != null && (collection = (Collection)this.backgroundRangeMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        if (this.foregroundRangeMarkers != null && (collection = (Collection)this.foregroundRangeMarkers.get(n3)) != null) {
            for (Marker marker : collection) {
                marker.removeChangeListener(this);
            }
            collection.clear();
        }
        this.fireChangeEvent();
    }

    public boolean removeRangeMarker(Marker marker) {
        return this.removeRangeMarker(marker, Layer.FOREGROUND);
    }

    public boolean removeRangeMarker(Marker marker, Layer layer) {
        return this.removeRangeMarker(0, marker, layer);
    }

    public boolean removeRangeMarker(int n2, Marker marker, Layer layer) {
        return this.removeRangeMarker(n2, marker, layer, true);
    }

    public boolean removeRangeMarker(int n2, Marker marker, Layer layer, boolean bl2) {
        ParamChecks.nullNotPermitted(marker, "marker");
        ArrayList arrayList = layer == Layer.FOREGROUND ? (ArrayList)this.foregroundRangeMarkers.get(new Integer(n2)) : (ArrayList)this.backgroundRangeMarkers.get(new Integer(n2));
        if (arrayList == null) {
            return false;
        }
        boolean bl3 = arrayList.remove(marker);
        if (bl3 && bl2) {
            this.fireChangeEvent();
        }
        return bl3;
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl2) {
        if (this.domainCrosshairVisible != bl2) {
            this.domainCrosshairVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public Comparable getDomainCrosshairRowKey() {
        return this.domainCrosshairRowKey;
    }

    public void setDomainCrosshairRowKey(Comparable comparable) {
        this.setDomainCrosshairRowKey(comparable, true);
    }

    public void setDomainCrosshairRowKey(Comparable comparable, boolean bl2) {
        this.domainCrosshairRowKey = comparable;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Comparable getDomainCrosshairColumnKey() {
        return this.domainCrosshairColumnKey;
    }

    public void setDomainCrosshairColumnKey(Comparable comparable) {
        this.setDomainCrosshairColumnKey(comparable, true);
    }

    public void setDomainCrosshairColumnKey(Comparable comparable, boolean bl2) {
        this.domainCrosshairColumnKey = comparable;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public int getCrosshairDatasetIndex() {
        return this.crosshairDatasetIndex;
    }

    public void setCrosshairDatasetIndex(int n2) {
        this.setCrosshairDatasetIndex(n2, true);
    }

    public void setCrosshairDatasetIndex(int n2, boolean bl2) {
        this.crosshairDatasetIndex = n2;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.domainCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.domainCrosshairStroke = stroke;
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl2) {
        if (this.rangeCrosshairVisible != bl2) {
            this.rangeCrosshairVisible = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl2) {
        if (this.rangeCrosshairLockedOnData != bl2) {
            this.rangeCrosshairLockedOnData = bl2;
            this.fireChangeEvent();
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d2) {
        this.setRangeCrosshairValue(d2, true);
    }

    public void setRangeCrosshairValue(double d2, boolean bl2) {
        this.rangeCrosshairValue = d2;
        if (this.isRangeCrosshairVisible() && bl2) {
            this.fireChangeEvent();
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.rangeCrosshairStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.rangeCrosshairPaint = paint;
        this.fireChangeEvent();
    }

    public List getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation) {
        this.addAnnotation(categoryAnnotation, true);
    }

    public void addAnnotation(CategoryAnnotation categoryAnnotation, boolean bl2) {
        ParamChecks.nullNotPermitted(categoryAnnotation, "annotation");
        this.annotations.add(categoryAnnotation);
        categoryAnnotation.addChangeListener(this);
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public boolean removeAnnotation(CategoryAnnotation categoryAnnotation) {
        return this.removeAnnotation(categoryAnnotation, true);
    }

    public boolean removeAnnotation(CategoryAnnotation categoryAnnotation, boolean bl2) {
        ParamChecks.nullNotPermitted(categoryAnnotation, "annotation");
        boolean bl3 = this.annotations.remove(categoryAnnotation);
        categoryAnnotation.removeChangeListener(this);
        if (bl3 && bl2) {
            this.fireChangeEvent();
        }
        return bl3;
    }

    public void clearAnnotations() {
        for (int i2 = 0; i2 < this.annotations.size(); ++i2) {
            CategoryAnnotation categoryAnnotation = (CategoryAnnotation)this.annotations.get(i2);
            categoryAnnotation.removeChangeListener(this);
        }
        this.annotations.clear();
        this.fireChangeEvent();
    }

    public ShadowGenerator getShadowGenerator() {
        return this.shadowGenerator;
    }

    public void setShadowGenerator(ShadowGenerator shadowGenerator) {
        this.shadowGenerator = shadowGenerator;
        this.fireChangeEvent();
    }

    protected AxisSpace calculateDomainAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block5: {
            block3: {
                block4: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedDomainAxisSpace == null) break block3;
                    if (!this.orientation.isHorizontal()) break block4;
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getLeft(), RectangleEdge.LEFT);
                    axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getRight(), RectangleEdge.RIGHT);
                    break block5;
                }
                if (!this.orientation.isVertical()) break block5;
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getTop(), RectangleEdge.TOP);
                axisSpace.ensureAtLeast(this.fixedDomainAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                break block5;
            }
            RectangleEdge rectangleEdge = Plot.resolveDomainAxisLocation(this.getDomainAxisLocation(), this.orientation);
            if (this.drawSharedDomainAxis) {
                axisSpace = this.getDomainAxis().reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
            for (CategoryAxis categoryAxis : this.domainAxes.values()) {
                if (categoryAxis == null) continue;
                int n2 = this.getDomainAxisIndex(categoryAxis);
                RectangleEdge rectangleEdge2 = this.getDomainAxisEdge(n2);
                axisSpace = categoryAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge2, axisSpace);
            }
        }
        return axisSpace;
    }

    protected AxisSpace calculateRangeAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D, AxisSpace axisSpace) {
        block4: {
            block2: {
                block3: {
                    if (axisSpace == null) {
                        axisSpace = new AxisSpace();
                    }
                    if (this.fixedRangeAxisSpace == null) break block2;
                    if (!this.orientation.isHorizontal()) break block3;
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getTop(), RectangleEdge.TOP);
                    axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getBottom(), RectangleEdge.BOTTOM);
                    break block4;
                }
                if (this.orientation != PlotOrientation.VERTICAL) break block4;
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getLeft(), RectangleEdge.LEFT);
                axisSpace.ensureAtLeast(this.fixedRangeAxisSpace.getRight(), RectangleEdge.RIGHT);
                break block4;
            }
            for (ValueAxis valueAxis : this.rangeAxes.values()) {
                if (valueAxis == null) continue;
                int n2 = this.findRangeAxisIndex(valueAxis);
                RectangleEdge rectangleEdge = this.getRangeAxisEdge(n2);
                axisSpace = valueAxis.reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        return axisSpace;
    }

    private Rectangle integerise(Rectangle2D rectangle2D) {
        int n2 = (int)Math.ceil(rectangle2D.getMinX());
        int n3 = (int)Math.ceil(rectangle2D.getMinY());
        int n4 = (int)Math.floor(rectangle2D.getMaxX());
        int n5 = (int)Math.floor(rectangle2D.getMaxY());
        return new Rectangle(n2, n3, n4 - n2, n5 - n3);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        AxisSpace axisSpace = new AxisSpace();
        axisSpace = this.calculateRangeAxisSpace(graphics2D, rectangle2D, axisSpace);
        axisSpace = this.calculateDomainAxisSpace(graphics2D, rectangle2D, axisSpace);
        return axisSpace;
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        double d2;
        Object object;
        Object object2;
        int n2;
        int n3;
        Object object4;
        boolean bl2;
        boolean bl3 = rectangle2D.getWidth() <= 10.0;
        boolean bl4 = bl2 = rectangle2D.getHeight() <= 10.0;
        if (bl3 || bl2) {
            return;
        }
        if (plotRenderingInfo == null) {
            plotRenderingInfo = new PlotRenderingInfo(null);
        }
        plotRenderingInfo.setPlotArea(rectangle2D);
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.axisOffset.trim(rectangle2D2);
        rectangle2D2 = this.integerise(rectangle2D2);
        if (rectangle2D2.isEmpty()) {
            return;
        }
        plotRenderingInfo.setDataArea(rectangle2D2);
        this.createAndAddEntity((Rectangle2D)rectangle2D2.clone(), plotRenderingInfo, null, null);
        if (this.getRenderer() != null) {
            this.getRenderer().drawBackground(graphics2D, this, rectangle2D2);
        } else {
            this.drawBackground(graphics2D, rectangle2D2);
        }
        Map map = this.drawAxes(graphics2D, rectangle2D, rectangle2D2, plotRenderingInfo);
        if (point2D != null && !rectangle2D2.contains(point2D)) {
            point2D = ShapeUtilities.getPointInRectangle(point2D.getX(), point2D.getY(), rectangle2D2);
        }
        CategoryCrosshairState categoryCrosshairState = new CategoryCrosshairState();
        categoryCrosshairState.setCrosshairDistance(Double.POSITIVE_INFINITY);
        categoryCrosshairState.setAnchor(point2D);
        categoryCrosshairState.setAnchorX(Double.NaN);
        categoryCrosshairState.setAnchorY(Double.NaN);
        if (point2D != null && (object4 = this.getRangeAxis()) != null) {
            double d3 = this.getOrientation() == PlotOrientation.VERTICAL ? ((ValueAxis)object4).java2DToValue(point2D.getY(), rectangle2D2, this.getRangeAxisEdge()) : ((ValueAxis)object4).java2DToValue(point2D.getX(), rectangle2D2, this.getRangeAxisEdge());
            categoryCrosshairState.setAnchorY(d3);
        }
        categoryCrosshairState.setRowKey(this.getDomainCrosshairRowKey());
        categoryCrosshairState.setColumnKey(this.getDomainCrosshairColumnKey());
        categoryCrosshairState.setCrosshairY(this.getRangeCrosshairValue());
        object4 = graphics2D.getClip();
        graphics2D.clip(rectangle2D2);
        this.drawDomainGridlines(graphics2D, rectangle2D2);
        AxisState axisState = (AxisState)map.get(this.getRangeAxis());
        if (axisState == null && plotState != null) {
            axisState = (AxisState)plotState.getSharedAxisStates().get(this.getRangeAxis());
        }
        if (axisState != null) {
            this.drawRangeGridlines(graphics2D, rectangle2D2, axisState.getTicks());
            this.drawZeroRangeBaseline(graphics2D, rectangle2D2);
        }
        Graphics2D graphics2D2 = graphics2D;
        BufferedImage bufferedImage = null;
        boolean bl5 = Boolean.TRUE.equals(graphics2D.getRenderingHint(JFreeChart.KEY_SUPPRESS_SHADOW_GENERATION));
        if (this.shadowGenerator != null && !bl5) {
            bufferedImage = new BufferedImage((int)rectangle2D2.getWidth(), (int)rectangle2D2.getHeight(), 2);
            graphics2D = bufferedImage.createGraphics();
            graphics2D.translate(-rectangle2D2.getX(), -rectangle2D2.getY());
            graphics2D.setRenderingHints(graphics2D2.getRenderingHints());
        }
        for (CategoryItemRenderer object32 : this.renderers.values()) {
            n3 = this.getIndexOf(object32);
            this.drawDomainMarkers(graphics2D, rectangle2D2, n3, Layer.BACKGROUND);
        }
        for (CategoryItemRenderer categoryItemRenderer : this.renderers.values()) {
            n3 = this.getIndexOf(categoryItemRenderer);
            this.drawRangeMarkers(graphics2D, rectangle2D2, n3, Layer.BACKGROUND);
        }
        boolean bl6 = false;
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        DatasetRenderingOrder datasetRenderingOrder = this.getDatasetRenderingOrder();
        List<Integer> list = this.getDatasetIndices(datasetRenderingOrder);
        Object object3 = list.iterator();
        while (object3.hasNext()) {
            int n4 = object3.next();
            bl6 = this.render(graphics2D, rectangle2D2, n4, plotRenderingInfo, categoryCrosshairState) || bl6;
        }
        object3 = this.getRendererIndices(datasetRenderingOrder);
        Object object5 = object3.iterator();
        while (object5.hasNext()) {
            n2 = (Integer)object5.next();
            this.drawDomainMarkers(graphics2D, rectangle2D2, n2, Layer.FOREGROUND);
        }
        object5 = object3.iterator();
        while (object5.hasNext()) {
            n2 = (Integer)object5.next();
            this.drawRangeMarkers(graphics2D, rectangle2D2, n2, Layer.FOREGROUND);
        }
        this.drawAnnotations(graphics2D, rectangle2D2);
        if (this.shadowGenerator != null && !bl5) {
            object5 = this.shadowGenerator.createDropShadow(bufferedImage);
            graphics2D = graphics2D2;
            graphics2D.drawImage((Image)object5, (int)rectangle2D2.getX() + this.shadowGenerator.calculateOffsetX(), (int)rectangle2D2.getY() + this.shadowGenerator.calculateOffsetY(), null);
            graphics2D.drawImage((Image)bufferedImage, (int)rectangle2D2.getX(), (int)rectangle2D2.getY(), null);
        }
        graphics2D.setClip((Shape)object4);
        graphics2D.setComposite(composite);
        if (!bl6) {
            this.drawNoDataMessage(graphics2D, rectangle2D2);
        }
        int n5 = categoryCrosshairState.getDatasetIndex();
        this.setCrosshairDatasetIndex(n5, false);
        Comparable comparable = categoryCrosshairState.getRowKey();
        Comparable comparable2 = categoryCrosshairState.getColumnKey();
        this.setDomainCrosshairRowKey(comparable, false);
        this.setDomainCrosshairColumnKey(comparable2, false);
        if (this.isDomainCrosshairVisible() && comparable2 != null) {
            object2 = this.getDomainCrosshairPaint();
            object = this.getDomainCrosshairStroke();
            this.drawDomainCrosshair(graphics2D, rectangle2D2, this.orientation, n5, comparable, comparable2, (Stroke)object, (Paint)object2);
        }
        object2 = this.getRangeAxisForDataset(n5);
        object = this.getRangeAxisEdge();
        if (!this.rangeCrosshairLockedOnData && point2D != null) {
            d2 = this.getOrientation() == PlotOrientation.VERTICAL ? ((ValueAxis)object2).java2DToValue(point2D.getY(), rectangle2D2, (RectangleEdge)object) : ((ValueAxis)object2).java2DToValue(point2D.getX(), rectangle2D2, (RectangleEdge)object);
            categoryCrosshairState.setCrosshairY(d2);
        }
        this.setRangeCrosshairValue(categoryCrosshairState.getCrosshairY(), false);
        if (this.isRangeCrosshairVisible()) {
            d2 = this.getRangeCrosshairValue();
            Paint paint = this.getRangeCrosshairPaint();
            Stroke stroke = this.getRangeCrosshairStroke();
            this.drawRangeCrosshair(graphics2D, rectangle2D2, this.getOrientation(), d2, (ValueAxis)object2, stroke, paint);
        }
        if (this.isOutlineVisible()) {
            if (this.getRenderer() != null) {
                this.getRenderer().drawOutline(graphics2D, this, rectangle2D2);
            } else {
                this.drawOutline(graphics2D, rectangle2D2);
            }
        }
    }

    private List<Integer> getDatasetIndices(DatasetRenderingOrder datasetRenderingOrder) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<Integer, CategoryDataset> entry : this.datasets.entrySet()) {
            if (entry.getValue() == null) continue;
            arrayList.add(entry.getKey());
        }
        Collections.sort(arrayList);
        if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    private List<Integer> getRendererIndices(DatasetRenderingOrder datasetRenderingOrder) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Map.Entry<Integer, CategoryItemRenderer> entry : this.renderers.entrySet()) {
            if (entry.getValue() == null) continue;
            arrayList.add(entry.getKey());
        }
        Collections.sort(arrayList);
        if (datasetRenderingOrder == DatasetRenderingOrder.REVERSE) {
            Collections.reverse(arrayList);
        }
        return arrayList;
    }

    @Override
    public void drawBackground(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.fillBackground(graphics2D, rectangle2D, this.orientation);
        this.drawBackgroundImage(graphics2D, rectangle2D);
    }

    protected Map drawAxes(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState;
        int n2;
        AxisCollection axisCollection = new AxisCollection();
        for (CategoryAxis axis : this.domainAxes.values()) {
            if (axis == null) continue;
            n2 = this.getDomainAxisIndex(axis);
            axisCollection.add(axis, this.getDomainAxisEdge(n2));
        }
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            n2 = this.findRangeAxisIndex(valueAxis);
            axisCollection.add(valueAxis, this.getRangeAxisEdge(n2));
        }
        HashMap hashMap = new HashMap();
        double d2 = rectangle2D2.getMinY() - this.axisOffset.calculateTopOutset(rectangle2D2.getHeight());
        for (Axis axis : axisCollection.getAxesAtTop()) {
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.TOP, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d2 = rectangle2D2.getMaxY() + this.axisOffset.calculateBottomOutset(rectangle2D2.getHeight());
        for (Axis axis : axisCollection.getAxesAtBottom()) {
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.BOTTOM, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d2 = rectangle2D2.getMinX() - this.axisOffset.calculateLeftOutset(rectangle2D2.getWidth());
        for (Axis axis : axisCollection.getAxesAtLeft()) {
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.LEFT, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        d2 = rectangle2D2.getMaxX() + this.axisOffset.calculateRightOutset(rectangle2D2.getWidth());
        for (Axis axis : axisCollection.getAxesAtRight()) {
            if (axis == null) continue;
            axisState = axis.draw(graphics2D, d2, rectangle2D, rectangle2D2, RectangleEdge.RIGHT, plotRenderingInfo);
            d2 = axisState.getCursor();
            hashMap.put(axis, axisState);
        }
        return hashMap;
    }

    public boolean render(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, PlotRenderingInfo plotRenderingInfo, CategoryCrosshairState categoryCrosshairState) {
        boolean bl2;
        boolean bl3 = false;
        CategoryDataset categoryDataset = this.getDataset(n2);
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n2);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n2);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n2);
        boolean bl4 = bl2 = !DatasetUtilities.isEmptyOrNull(categoryDataset);
        if (bl2 && categoryItemRenderer != null) {
            bl3 = true;
            CategoryItemRendererState categoryItemRendererState = categoryItemRenderer.initialise(graphics2D, rectangle2D, this, n2, plotRenderingInfo);
            categoryItemRendererState.setCrosshairState(categoryCrosshairState);
            int n3 = categoryDataset.getColumnCount();
            int n4 = categoryDataset.getRowCount();
            int n5 = categoryItemRenderer.getPassCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                int n6;
                int n7;
                if (this.columnRenderingOrder == SortOrder.ASCENDING) {
                    for (n7 = 0; n7 < n3; ++n7) {
                        if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                            for (n6 = 0; n6 < n4; ++n6) {
                                categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n6, n7, i2);
                            }
                            continue;
                        }
                        for (n6 = n4 - 1; n6 >= 0; --n6) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n6, n7, i2);
                        }
                    }
                    continue;
                }
                for (n7 = n3 - 1; n7 >= 0; --n7) {
                    if (this.rowRenderingOrder == SortOrder.ASCENDING) {
                        for (n6 = 0; n6 < n4; ++n6) {
                            categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n6, n7, i2);
                        }
                        continue;
                    }
                    for (n6 = n4 - 1; n6 >= 0; --n6) {
                        categoryItemRenderer.drawItem(graphics2D, categoryItemRendererState, rectangle2D, this, categoryAxis, valueAxis, categoryDataset, n6, n7, i2);
                    }
                }
            }
        }
        return bl3;
    }

    protected void drawDomainGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isDomainGridlinesVisible()) {
            return;
        }
        CategoryAnchor categoryAnchor = this.getDomainGridlinePosition();
        RectangleEdge rectangleEdge = this.getDomainAxisEdge();
        CategoryDataset categoryDataset = this.getDataset();
        if (categoryDataset == null) {
            return;
        }
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            int n2 = categoryDataset.getColumnCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                double d2 = categoryAxis.getCategoryJava2DCoordinate(categoryAnchor, i2, n2, rectangle2D, rectangleEdge);
                CategoryItemRenderer categoryItemRenderer = this.getRenderer();
                if (categoryItemRenderer == null) continue;
                categoryItemRenderer.drawDomainGridline(graphics2D, this, rectangle2D, d2);
            }
        }
    }

    protected void drawRangeGridlines(Graphics2D graphics2D, Rectangle2D rectangle2D, List list) {
        if (!this.isRangeGridlinesVisible() && !this.isRangeMinorGridlinesVisible()) {
            return;
        }
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis == null) {
            return;
        }
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        if (categoryItemRenderer == null) {
            return;
        }
        Stroke stroke = null;
        Paint paint = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = false;
            ValueTick valueTick = (ValueTick)iterator.next();
            if (valueTick.getTickType() == TickType.MINOR && this.isRangeMinorGridlinesVisible()) {
                stroke = this.getRangeMinorGridlineStroke();
                paint = this.getRangeMinorGridlinePaint();
                bl2 = true;
            } else if (valueTick.getTickType() == TickType.MAJOR && this.isRangeGridlinesVisible()) {
                stroke = this.getRangeGridlineStroke();
                paint = this.getRangeGridlinePaint();
                bl2 = true;
            }
            if (valueTick.getValue() == 0.0 && this.isRangeZeroBaselineVisible() || !bl2) continue;
            if (categoryItemRenderer instanceof AbstractCategoryItemRenderer) {
                AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)categoryItemRenderer;
                abstractCategoryItemRenderer.drawRangeLine(graphics2D, this, valueAxis, rectangle2D, valueTick.getValue(), paint, stroke);
                continue;
            }
            categoryItemRenderer.drawRangeGridline(graphics2D, this, valueAxis, rectangle2D, valueTick.getValue());
        }
    }

    protected void drawZeroRangeBaseline(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (!this.isRangeZeroBaselineVisible()) {
            return;
        }
        CategoryItemRenderer categoryItemRenderer = this.getRenderer();
        if (categoryItemRenderer instanceof AbstractCategoryItemRenderer) {
            AbstractCategoryItemRenderer abstractCategoryItemRenderer = (AbstractCategoryItemRenderer)categoryItemRenderer;
            abstractCategoryItemRenderer.drawRangeLine(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0, this.rangeZeroBaselinePaint, this.rangeZeroBaselineStroke);
        } else {
            categoryItemRenderer.drawRangeGridline(graphics2D, this, this.getRangeAxis(), rectangle2D, 0.0);
        }
    }

    protected void drawAnnotations(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (this.getAnnotations() != null) {
            for (CategoryAnnotation categoryAnnotation : this.getAnnotations()) {
                categoryAnnotation.draw(graphics2D, this, rectangle2D, this.getDomainAxis(), this.getRangeAxis());
            }
        }
    }

    protected void drawDomainMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n2);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getDomainMarkers(n2, layer);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n2);
        if (collection != null && categoryAxis != null) {
            for (CategoryMarker categoryMarker : collection) {
                categoryItemRenderer.drawDomainMarker(graphics2D, this, categoryAxis, categoryMarker, rectangle2D);
            }
        }
    }

    protected void drawRangeMarkers(Graphics2D graphics2D, Rectangle2D rectangle2D, int n2, Layer layer) {
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n2);
        if (categoryItemRenderer == null) {
            return;
        }
        Collection collection = this.getRangeMarkers(n2, layer);
        ValueAxis valueAxis = this.getRangeAxisForDataset(n2);
        if (collection != null && valueAxis != null) {
            for (Marker marker : collection) {
                categoryItemRenderer.drawRangeMarker(graphics2D, this, valueAxis, marker, rectangle2D);
            }
        }
    }

    protected void drawRangeLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Stroke stroke, Paint paint) {
        double d3 = this.getRangeAxis().valueToJava2D(d2, rectangle2D, this.getRangeAxisEdge());
        Line2D.Double double_ = null;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else if (this.orientation == PlotOrientation.VERTICAL) {
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawDomainCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, int n2, Comparable comparable, Comparable comparable2, Stroke stroke, Paint paint) {
        Line2D.Double double_;
        CategoryDataset categoryDataset = this.getDataset(n2);
        CategoryAxis categoryAxis = this.getDomainAxisForDataset(n2);
        CategoryItemRenderer categoryItemRenderer = this.getRenderer(n2);
        if (plotOrientation == PlotOrientation.VERTICAL) {
            double d2 = categoryItemRenderer.getItemMiddle(comparable, comparable2, categoryDataset, categoryAxis, rectangle2D, RectangleEdge.BOTTOM);
            double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        } else {
            double d3 = categoryItemRenderer.getItemMiddle(comparable, comparable2, categoryDataset, categoryAxis, rectangle2D, RectangleEdge.LEFT);
            double_ = new Line2D.Double(rectangle2D.getMinX(), d3, rectangle2D.getMaxX(), d3);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawRangeCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotOrientation plotOrientation, double d2, ValueAxis valueAxis, Stroke stroke, Paint paint) {
        Line2D.Double double_;
        if (!valueAxis.getRange().contains(d2)) {
            return;
        }
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double d3 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.BOTTOM);
            double_ = new Line2D.Double(d3, rectangle2D.getMinY(), d3, rectangle2D.getMaxY());
        } else {
            double d4 = valueAxis.valueToJava2D(d2, rectangle2D, RectangleEdge.LEFT);
            double_ = new Line2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getMaxX(), d4);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    @Override
    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        ArrayList arrayList = new ArrayList();
        int n2 = this.findRangeAxisIndex(valueAxis);
        if (n2 >= 0) {
            arrayList.addAll(this.datasetsMappedToRangeAxis(n2));
        } else if (valueAxis == this.getRangeAxis()) {
            arrayList.addAll(this.datasetsMappedToRangeAxis(0));
        }
        for (CategoryDataset categoryDataset : arrayList) {
            CategoryItemRenderer categoryItemRenderer = this.getRendererForDataset(categoryDataset);
            if (categoryItemRenderer == null) continue;
            range = Range.combine(range, categoryItemRenderer.findRangeBounds(categoryDataset));
        }
        return range;
    }

    private List<CategoryDataset> datasetsMappedToDomainAxis(int n2) {
        Integer n3 = new Integer(n2);
        ArrayList<CategoryDataset> arrayList = new ArrayList<CategoryDataset>();
        for (CategoryDataset categoryDataset : this.datasets.values()) {
            if (categoryDataset == null) continue;
            int n4 = this.indexOf(categoryDataset);
            List list = (List)this.datasetToDomainAxesMap.get(new Integer(n4));
            if (list == null) {
                if (!n3.equals(ZERO)) continue;
                arrayList.add(categoryDataset);
                continue;
            }
            if (!list.contains(n3)) continue;
            arrayList.add(categoryDataset);
        }
        return arrayList;
    }

    private List datasetsMappedToRangeAxis(int n2) {
        Integer n3 = new Integer(n2);
        ArrayList<CategoryDataset> arrayList = new ArrayList<CategoryDataset>();
        for (CategoryDataset categoryDataset : this.datasets.values()) {
            int n4 = this.indexOf(categoryDataset);
            List list = (List)this.datasetToRangeAxesMap.get(new Integer(n4));
            if (list == null) {
                if (!n3.equals(ZERO)) continue;
                arrayList.add(this.datasets.get(n4));
                continue;
            }
            if (!list.contains(n3)) continue;
            arrayList.add(this.datasets.get(n4));
        }
        return arrayList;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n2) {
        this.weight = n2;
        this.fireChangeEvent();
    }

    public AxisSpace getFixedDomainAxisSpace() {
        return this.fixedDomainAxisSpace;
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace) {
        this.setFixedDomainAxisSpace(axisSpace, true);
    }

    public void setFixedDomainAxisSpace(AxisSpace axisSpace, boolean bl2) {
        this.fixedDomainAxisSpace = axisSpace;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public AxisSpace getFixedRangeAxisSpace() {
        return this.fixedRangeAxisSpace;
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace) {
        this.setFixedRangeAxisSpace(axisSpace, true);
    }

    public void setFixedRangeAxisSpace(AxisSpace axisSpace, boolean bl2) {
        this.fixedRangeAxisSpace = axisSpace;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public List getCategories() {
        List list = null;
        if (this.getDataset() != null) {
            list = Collections.unmodifiableList(this.getDataset().getColumnKeys());
        }
        return list;
    }

    public List getCategoriesForAxis(CategoryAxis categoryAxis) {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        int n2 = this.getDomainAxisIndex(categoryAxis);
        for (CategoryDataset categoryDataset : this.datasetsMappedToDomainAxis(n2)) {
            for (int i2 = 0; i2 < categoryDataset.getColumnCount(); ++i2) {
                Comparable comparable = categoryDataset.getColumnKey(i2);
                if (arrayList.contains(comparable)) continue;
                arrayList.add(comparable);
            }
        }
        return arrayList;
    }

    public boolean getDrawSharedDomainAxis() {
        return this.drawSharedDomainAxis;
    }

    public void setDrawSharedDomainAxis(boolean bl2) {
        this.drawSharedDomainAxis = bl2;
        this.fireChangeEvent();
    }

    @Override
    public boolean isDomainPannable() {
        return false;
    }

    @Override
    public boolean isRangePannable() {
        return this.rangePannable;
    }

    public void setRangePannable(boolean bl2) {
        this.rangePannable = bl2;
    }

    @Override
    public void panDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void panRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        if (!this.isRangePannable()) {
            return;
        }
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            double d3 = valueAxis.getRange().getLength();
            double d4 = d2 * d3;
            if (valueAxis.isInverted()) {
                d4 = -d4;
            }
            valueAxis.setRange(valueAxis.getLowerBound() + d4, valueAxis.getUpperBound() + d4);
        }
    }

    @Override
    public boolean isDomainZoomable() {
        return false;
    }

    @Override
    public boolean isRangeZoomable() {
        return true;
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void zoomDomainAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
    }

    @Override
    public void zoomDomainAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        this.zoomRangeAxes(d2, plotRenderingInfo, point2D, false);
    }

    @Override
    public void zoomRangeAxes(double d2, PlotRenderingInfo plotRenderingInfo, Point2D point2D, boolean bl2) {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            if (bl2) {
                double d3 = point2D.getY();
                if (this.orientation.isHorizontal()) {
                    d3 = point2D.getX();
                }
                double d4 = valueAxis.java2DToValue(d3, plotRenderingInfo.getDataArea(), this.getRangeAxisEdge());
                valueAxis.resizeRange2(d2, d4);
                continue;
            }
            valueAxis.resizeRange(d2);
        }
    }

    @Override
    public void zoomRangeAxes(double d2, double d3, PlotRenderingInfo plotRenderingInfo, Point2D point2D) {
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.zoomRange(d2, d3);
        }
    }

    public double getAnchorValue() {
        return this.anchorValue;
    }

    public void setAnchorValue(double d2) {
        this.setAnchorValue(d2, true);
    }

    public void setAnchorValue(double d2, boolean bl2) {
        this.anchorValue = d2;
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryPlot)) {
            return false;
        }
        CategoryPlot categoryPlot = (CategoryPlot)object;
        if (this.orientation != categoryPlot.orientation) {
            return false;
        }
        if (!ObjectUtilities.equal(this.axisOffset, categoryPlot.axisOffset)) {
            return false;
        }
        if (!this.domainAxes.equals(categoryPlot.domainAxes)) {
            return false;
        }
        if (!this.domainAxisLocations.equals(categoryPlot.domainAxisLocations)) {
            return false;
        }
        if (this.drawSharedDomainAxis != categoryPlot.drawSharedDomainAxis) {
            return false;
        }
        if (!this.rangeAxes.equals(categoryPlot.rangeAxes)) {
            return false;
        }
        if (!this.rangeAxisLocations.equals(categoryPlot.rangeAxisLocations)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToDomainAxesMap, categoryPlot.datasetToDomainAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.datasetToRangeAxesMap, categoryPlot.datasetToRangeAxesMap)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.renderers, categoryPlot.renderers)) {
            return false;
        }
        if (this.renderingOrder != categoryPlot.renderingOrder) {
            return false;
        }
        if (this.columnRenderingOrder != categoryPlot.columnRenderingOrder) {
            return false;
        }
        if (this.rowRenderingOrder != categoryPlot.rowRenderingOrder) {
            return false;
        }
        if (this.domainGridlinesVisible != categoryPlot.domainGridlinesVisible) {
            return false;
        }
        if (this.domainGridlinePosition != categoryPlot.domainGridlinePosition) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainGridlineStroke, categoryPlot.domainGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainGridlinePaint, categoryPlot.domainGridlinePaint)) {
            return false;
        }
        if (this.rangeGridlinesVisible != categoryPlot.rangeGridlinesVisible) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeGridlineStroke, categoryPlot.rangeGridlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeGridlinePaint, categoryPlot.rangeGridlinePaint)) {
            return false;
        }
        if (this.anchorValue != categoryPlot.anchorValue) {
            return false;
        }
        if (this.rangeCrosshairVisible != categoryPlot.rangeCrosshairVisible) {
            return false;
        }
        if (this.rangeCrosshairValue != categoryPlot.rangeCrosshairValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeCrosshairStroke, categoryPlot.rangeCrosshairStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeCrosshairPaint, categoryPlot.rangeCrosshairPaint)) {
            return false;
        }
        if (this.rangeCrosshairLockedOnData != categoryPlot.rangeCrosshairLockedOnData) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundDomainMarkers, categoryPlot.foregroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundDomainMarkers, categoryPlot.backgroundDomainMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.foregroundRangeMarkers, categoryPlot.foregroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.backgroundRangeMarkers, categoryPlot.backgroundRangeMarkers)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.annotations, categoryPlot.annotations)) {
            return false;
        }
        if (this.weight != categoryPlot.weight) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedDomainAxisSpace, categoryPlot.fixedDomainAxisSpace)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedRangeAxisSpace, categoryPlot.fixedRangeAxisSpace)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.fixedLegendItems, categoryPlot.fixedLegendItems)) {
            return false;
        }
        if (this.domainCrosshairVisible != categoryPlot.domainCrosshairVisible) {
            return false;
        }
        if (this.crosshairDatasetIndex != categoryPlot.crosshairDatasetIndex) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairColumnKey, categoryPlot.domainCrosshairColumnKey)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairRowKey, categoryPlot.domainCrosshairRowKey)) {
            return false;
        }
        if (!PaintUtilities.equal(this.domainCrosshairPaint, categoryPlot.domainCrosshairPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.domainCrosshairStroke, categoryPlot.domainCrosshairStroke)) {
            return false;
        }
        if (this.rangeMinorGridlinesVisible != categoryPlot.rangeMinorGridlinesVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeMinorGridlinePaint, categoryPlot.rangeMinorGridlinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeMinorGridlineStroke, categoryPlot.rangeMinorGridlineStroke)) {
            return false;
        }
        if (this.rangeZeroBaselineVisible != categoryPlot.rangeZeroBaselineVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.rangeZeroBaselinePaint, categoryPlot.rangeZeroBaselinePaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.rangeZeroBaselineStroke, categoryPlot.rangeZeroBaselineStroke)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.shadowGenerator, categoryPlot.shadowGenerator)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        CategoryPlot categoryPlot = (CategoryPlot)super.clone();
        categoryPlot.domainAxes = CloneUtils.cloneMapValues(this.domainAxes);
        for (CategoryAxis object : categoryPlot.domainAxes.values()) {
            if (object == null) continue;
            object.setPlot(categoryPlot);
            object.addChangeListener(categoryPlot);
        }
        categoryPlot.rangeAxes = CloneUtils.cloneMapValues(this.rangeAxes);
        for (ValueAxis valueAxis : categoryPlot.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.setPlot(categoryPlot);
            valueAxis.addChangeListener(categoryPlot);
        }
        categoryPlot.domainAxisLocations = new HashMap<Integer, AxisLocation>(this.domainAxisLocations);
        categoryPlot.rangeAxisLocations = new HashMap<Integer, AxisLocation>(this.rangeAxisLocations);
        categoryPlot.datasets = new HashMap<Integer, CategoryDataset>(this.datasets);
        for (CategoryDataset categoryDataset : categoryPlot.datasets.values()) {
            if (categoryDataset == null) continue;
            categoryDataset.addChangeListener(categoryPlot);
        }
        categoryPlot.datasetToDomainAxesMap = new TreeMap();
        categoryPlot.datasetToDomainAxesMap.putAll(this.datasetToDomainAxesMap);
        categoryPlot.datasetToRangeAxesMap = new TreeMap();
        categoryPlot.datasetToRangeAxesMap.putAll(this.datasetToRangeAxesMap);
        categoryPlot.renderers = CloneUtils.cloneMapValues(this.renderers);
        for (CategoryItemRenderer categoryItemRenderer : categoryPlot.renderers.values()) {
            if (categoryItemRenderer == null) continue;
            categoryItemRenderer.setPlot(categoryPlot);
            categoryItemRenderer.addChangeListener(categoryPlot);
        }
        if (this.fixedDomainAxisSpace != null) {
            categoryPlot.fixedDomainAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedDomainAxisSpace);
        }
        if (this.fixedRangeAxisSpace != null) {
            categoryPlot.fixedRangeAxisSpace = (AxisSpace)ObjectUtilities.clone(this.fixedRangeAxisSpace);
        }
        categoryPlot.annotations = (List)ObjectUtilities.deepClone(this.annotations);
        categoryPlot.foregroundDomainMarkers = this.cloneMarkerMap(this.foregroundDomainMarkers);
        categoryPlot.backgroundDomainMarkers = this.cloneMarkerMap(this.backgroundDomainMarkers);
        categoryPlot.foregroundRangeMarkers = this.cloneMarkerMap(this.foregroundRangeMarkers);
        categoryPlot.backgroundRangeMarkers = this.cloneMarkerMap(this.backgroundRangeMarkers);
        if (this.fixedLegendItems != null) {
            categoryPlot.fixedLegendItems = (LegendItemCollection)this.fixedLegendItems.clone();
        }
        return categoryPlot;
    }

    private Map cloneMarkerMap(Map map) {
        HashMap hashMap = new HashMap();
        Set set = map.keySet();
        for (Object k2 : set) {
            List list = (List)map.get(k2);
            Collection collection = ObjectUtilities.deepClone(list);
            hashMap.put(k2, collection);
        }
        return hashMap;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.domainGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.domainCrosshairStroke, objectOutputStream);
        SerialUtilities.writePaint(this.domainCrosshairPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeMinorGridlineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeMinorGridlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.rangeZeroBaselineStroke, objectOutputStream);
        SerialUtilities.writePaint(this.rangeZeroBaselinePaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.domainGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.domainCrosshairStroke = SerialUtilities.readStroke(objectInputStream);
        this.domainCrosshairPaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeMinorGridlineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeMinorGridlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.rangeZeroBaselineStroke = SerialUtilities.readStroke(objectInputStream);
        this.rangeZeroBaselinePaint = SerialUtilities.readPaint(objectInputStream);
        for (CategoryAxis object : this.domainAxes.values()) {
            if (object == null) continue;
            object.setPlot(this);
            object.addChangeListener(this);
        }
        for (ValueAxis valueAxis : this.rangeAxes.values()) {
            if (valueAxis == null) continue;
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        for (CategoryDataset categoryDataset : this.datasets.values()) {
            if (categoryDataset == null) continue;
            categoryDataset.addChangeListener(this);
        }
        for (CategoryItemRenderer categoryItemRenderer : this.renderers.values()) {
            if (categoryItemRenderer == null) continue;
            categoryItemRenderer.addChangeListener(this);
        }
    }
}

