/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.geom.Point2D;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;

public class CategoryCrosshairState
extends CrosshairState {
    private Comparable rowKey = null;
    private Comparable columnKey = null;

    public Comparable getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(Comparable comparable) {
        this.rowKey = comparable;
    }

    public Comparable getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(Comparable comparable) {
        this.columnKey = comparable;
    }

    public void updateCrosshairPoint(Comparable comparable, Comparable comparable2, double d2, int n2, double d3, double d4, PlotOrientation plotOrientation) {
        Point2D point2D = this.getAnchor();
        if (point2D != null) {
            double d5;
            double d6 = point2D.getX();
            double d7 = point2D.getY();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d5 = d7;
                d7 = d6;
                d6 = d5;
            }
            if ((d5 = (d3 - d6) * (d3 - d6) + (d4 - d7) * (d4 - d7)) < this.getCrosshairDistance()) {
                this.rowKey = comparable;
                this.columnKey = comparable2;
                this.setCrosshairY(d2);
                this.setDatasetIndex(n2);
                this.setCrosshairDistance(d5);
            }
        }
    }

    public void updateCrosshairX(Comparable comparable, Comparable comparable2, int n2, double d2, PlotOrientation plotOrientation) {
        Point2D point2D = this.getAnchor();
        if (point2D != null) {
            double d3;
            double d4 = point2D.getX();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d4 = point2D.getY();
            }
            if ((d3 = Math.abs(d2 - d4)) < this.getCrosshairDistance()) {
                this.rowKey = comparable;
                this.columnKey = comparable2;
                this.setDatasetIndex(n2);
                this.setCrosshairDistance(d3);
            }
        }
    }
}

