/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.panel;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.panel.AbstractOverlay;
import org.jfree.chart.panel.Overlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class CrosshairOverlay
extends AbstractOverlay
implements PropertyChangeListener,
Serializable,
Cloneable,
Overlay,
PublicCloneable {
    private List xCrosshairs = new ArrayList();
    private List yCrosshairs = new ArrayList();

    public void addDomainCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        this.xCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeDomainCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        if (this.xCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearDomainCrosshairs() {
        if (this.xCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getDomainCrosshairs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Crosshair crosshair = (Crosshair)list.get(i2);
            this.xCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List getDomainCrosshairs() {
        return new ArrayList(this.xCrosshairs);
    }

    public void addRangeCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        this.yCrosshairs.add(crosshair);
        crosshair.addPropertyChangeListener(this);
        this.fireOverlayChanged();
    }

    public void removeRangeCrosshair(Crosshair crosshair) {
        ParamChecks.nullNotPermitted(crosshair, "crosshair");
        if (this.yCrosshairs.remove(crosshair)) {
            crosshair.removePropertyChangeListener(this);
            this.fireOverlayChanged();
        }
    }

    public void clearRangeCrosshairs() {
        if (this.yCrosshairs.isEmpty()) {
            return;
        }
        List list = this.getRangeCrosshairs();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Crosshair crosshair = (Crosshair)list.get(i2);
            this.yCrosshairs.remove(crosshair);
            crosshair.removePropertyChangeListener(this);
        }
        this.fireOverlayChanged();
    }

    public List getRangeCrosshairs() {
        return new ArrayList(this.yCrosshairs);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.fireOverlayChanged();
    }

    @Override
    public void paintOverlay(Graphics2D graphics2D, ChartPanel chartPanel) {
        double d2;
        Serializable serializable2;
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D = chartPanel.getScreenDataArea();
        graphics2D.clip(rectangle2D);
        JFreeChart jFreeChart = chartPanel.getChart();
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        for (Serializable serializable2 : this.xCrosshairs) {
            if (!((Crosshair)serializable2).isVisible()) continue;
            double d3 = ((Crosshair)serializable2).getValue();
            d2 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawVerticalCrosshair(graphics2D, rectangle2D, d2, (Crosshair)serializable2);
                continue;
            }
            this.drawHorizontalCrosshair(graphics2D, rectangle2D, d2, (Crosshair)serializable2);
        }
        serializable2 = xYPlot.getRangeAxis();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        for (Crosshair crosshair : this.yCrosshairs) {
            if (!crosshair.isVisible()) continue;
            d2 = crosshair.getValue();
            double d4 = ((ValueAxis)serializable2).valueToJava2D(d2, rectangle2D, rectangleEdge2);
            if (xYPlot.getOrientation() == PlotOrientation.VERTICAL) {
                this.drawHorizontalCrosshair(graphics2D, rectangle2D, d4, crosshair);
                continue;
            }
            this.drawVerticalCrosshair(graphics2D, rectangle2D, d4, crosshair);
        }
        graphics2D.setClip(shape);
    }

    protected void drawHorizontalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Crosshair crosshair) {
        if (d2 >= rectangle2D.getMinY() && d2 <= rectangle2D.getMaxY()) {
            Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(crosshair.getPaint());
            graphics2D.setStroke(crosshair.getStroke());
            graphics2D.draw(double_);
            if (crosshair.isLabelVisible()) {
                TextAnchor textAnchor;
                float f2;
                RectangleAnchor rectangleAnchor;
                Point2D point2D;
                float f3;
                String string = crosshair.getLabelGenerator().generateLabel(crosshair);
                Shape shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f3 = (float)(point2D = this.calculateLabelPoint(double_, rectangleAnchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX(), f2 = (float)point2D.getY(), textAnchor = this.textAlignPtForLabelAnchorH(rectangleAnchor), 0.0, TextAnchor.CENTER);
                if (!rectangle2D.contains(shape.getBounds2D())) {
                    rectangleAnchor = this.flipAnchorV(rectangleAnchor);
                    point2D = this.calculateLabelPoint(double_, rectangleAnchor, 5.0, 5.0);
                    f3 = (float)point2D.getX();
                    f2 = (float)point2D.getY();
                    textAnchor = this.textAlignPtForLabelAnchorH(rectangleAnchor);
                    shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f3, f2, textAnchor, 0.0, TextAnchor.CENTER);
                }
                graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
                graphics2D.fill(shape);
                graphics2D.setPaint(crosshair.getLabelOutlinePaint());
                graphics2D.draw(shape);
                TextUtilities.drawAlignedString(string, graphics2D, f3, f2, textAnchor);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    protected void drawVerticalCrosshair(Graphics2D graphics2D, Rectangle2D rectangle2D, double d2, Crosshair crosshair) {
        if (d2 >= rectangle2D.getMinX() && d2 <= rectangle2D.getMaxX()) {
            Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
            Paint paint = graphics2D.getPaint();
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(crosshair.getPaint());
            graphics2D.setStroke(crosshair.getStroke());
            graphics2D.draw(double_);
            if (crosshair.isLabelVisible()) {
                TextAnchor textAnchor;
                float f2;
                RectangleAnchor rectangleAnchor;
                Point2D point2D;
                float f3;
                String string = crosshair.getLabelGenerator().generateLabel(crosshair);
                Shape shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f3 = (float)(point2D = this.calculateLabelPoint(double_, rectangleAnchor = crosshair.getLabelAnchor(), 5.0, 5.0)).getX(), f2 = (float)point2D.getY(), textAnchor = this.textAlignPtForLabelAnchorV(rectangleAnchor), 0.0, TextAnchor.CENTER);
                if (!rectangle2D.contains(shape.getBounds2D())) {
                    rectangleAnchor = this.flipAnchorH(rectangleAnchor);
                    point2D = this.calculateLabelPoint(double_, rectangleAnchor, 5.0, 5.0);
                    f3 = (float)point2D.getX();
                    f2 = (float)point2D.getY();
                    textAnchor = this.textAlignPtForLabelAnchorV(rectangleAnchor);
                    shape = TextUtilities.calculateRotatedStringBounds(string, graphics2D, f3, f2, textAnchor, 0.0, TextAnchor.CENTER);
                }
                graphics2D.setPaint(crosshair.getLabelBackgroundPaint());
                graphics2D.fill(shape);
                graphics2D.setPaint(crosshair.getLabelOutlinePaint());
                graphics2D.draw(shape);
                TextUtilities.drawAlignedString(string, graphics2D, f3, f2, textAnchor);
            }
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
        }
    }

    private Point2D calculateLabelPoint(Line2D line2D, RectangleAnchor rectangleAnchor, double d2, double d3) {
        double d4;
        double d5;
        boolean bl2 = rectangleAnchor == RectangleAnchor.BOTTOM_LEFT || rectangleAnchor == RectangleAnchor.LEFT || rectangleAnchor == RectangleAnchor.TOP_LEFT;
        boolean bl3 = rectangleAnchor == RectangleAnchor.BOTTOM_RIGHT || rectangleAnchor == RectangleAnchor.RIGHT || rectangleAnchor == RectangleAnchor.TOP_RIGHT;
        boolean bl4 = rectangleAnchor == RectangleAnchor.TOP_LEFT || rectangleAnchor == RectangleAnchor.TOP || rectangleAnchor == RectangleAnchor.TOP_RIGHT;
        boolean bl5 = rectangleAnchor == RectangleAnchor.BOTTOM_LEFT || rectangleAnchor == RectangleAnchor.BOTTOM || rectangleAnchor == RectangleAnchor.BOTTOM_RIGHT;
        Rectangle rectangle = line2D.getBounds();
        if (line2D.getX1() == line2D.getX2()) {
            d5 = line2D.getX1();
            d4 = (line2D.getY1() + line2D.getY2()) / 2.0;
            if (bl2) {
                d5 -= d2;
            }
            if (bl3) {
                d5 += d2;
            }
            if (bl4) {
                d4 = Math.min(line2D.getY1(), line2D.getY2()) + d3;
            }
            if (bl5) {
                d4 = Math.max(line2D.getY1(), line2D.getY2()) - d3;
            }
        } else {
            d5 = (line2D.getX1() + line2D.getX2()) / 2.0;
            d4 = line2D.getY1();
            if (bl2) {
                d5 = Math.min(line2D.getX1(), line2D.getX2()) + d2;
            }
            if (bl3) {
                d5 = Math.max(line2D.getX1(), line2D.getX2()) - d2;
            }
            if (bl4) {
                d4 -= d3;
            }
            if (bl5) {
                d4 += d3;
            }
        }
        return new Point2D.Double(d5, d4);
    }

    private TextAnchor textAlignPtForLabelAnchorV(RectangleAnchor rectangleAnchor) {
        TextAnchor textAnchor = TextAnchor.CENTER;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            textAnchor = TextAnchor.TOP_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP)) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.LEFT)) {
            textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.RIGHT)) {
            textAnchor = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM)) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        }
        return textAnchor;
    }

    private TextAnchor textAlignPtForLabelAnchorH(RectangleAnchor rectangleAnchor) {
        TextAnchor textAnchor = TextAnchor.CENTER;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            textAnchor = TextAnchor.BOTTOM_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP)) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            textAnchor = TextAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.LEFT)) {
            textAnchor = TextAnchor.HALF_ASCENT_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.RIGHT)) {
            textAnchor = TextAnchor.HALF_ASCENT_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            textAnchor = TextAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM)) {
            textAnchor = TextAnchor.TOP_CENTER;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            textAnchor = TextAnchor.TOP_RIGHT;
        }
        return textAnchor;
    }

    private RectangleAnchor flipAnchorH(RectangleAnchor rectangleAnchor) {
        RectangleAnchor rectangleAnchor2 = rectangleAnchor;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.LEFT)) {
            rectangleAnchor2 = RectangleAnchor.RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_LEFT;
        }
        return rectangleAnchor2;
    }

    private RectangleAnchor flipAnchorV(RectangleAnchor rectangleAnchor) {
        RectangleAnchor rectangleAnchor2 = rectangleAnchor;
        if (rectangleAnchor.equals(RectangleAnchor.TOP_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM_RIGHT;
        } else if (rectangleAnchor.equals(RectangleAnchor.TOP)) {
            rectangleAnchor2 = RectangleAnchor.BOTTOM;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM)) {
            rectangleAnchor2 = RectangleAnchor.TOP;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_LEFT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_LEFT;
        } else if (rectangleAnchor.equals(RectangleAnchor.BOTTOM_RIGHT)) {
            rectangleAnchor2 = RectangleAnchor.TOP_RIGHT;
        }
        return rectangleAnchor2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CrosshairOverlay)) {
            return false;
        }
        CrosshairOverlay crosshairOverlay = (CrosshairOverlay)object;
        if (!this.xCrosshairs.equals(crosshairOverlay.xCrosshairs)) {
            return false;
        }
        return this.yCrosshairs.equals(crosshairOverlay.yCrosshairs);
    }

    @Override
    public Object clone() {
        CrosshairOverlay crosshairOverlay = (CrosshairOverlay)super.clone();
        crosshairOverlay.xCrosshairs = (List)ObjectUtilities.deepClone(this.xCrosshairs);
        crosshairOverlay.yCrosshairs = (List)ObjectUtilities.deepClone(this.yCrosshairs);
        return crosshairOverlay;
    }
}

