/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.panel;

import javax.swing.event.EventListenerList;
import org.jfree.chart.event.OverlayChangeEvent;
import org.jfree.chart.event.OverlayChangeListener;
import org.jfree.chart.util.ParamChecks;

public class AbstractOverlay {
    private transient EventListenerList changeListeners = new EventListenerList();

    public void addChangeListener(OverlayChangeListener overlayChangeListener) {
        ParamChecks.nullNotPermitted(overlayChangeListener, "listener");
        this.changeListeners.add(OverlayChangeListener.class, overlayChangeListener);
    }

    public void removeChangeListener(OverlayChangeListener overlayChangeListener) {
        ParamChecks.nullNotPermitted(overlayChangeListener, "listener");
        this.changeListeners.remove(OverlayChangeListener.class, overlayChangeListener);
    }

    public void fireOverlayChanged() {
        OverlayChangeEvent overlayChangeEvent = new OverlayChangeEvent(this);
        this.notifyListeners(overlayChangeEvent);
    }

    protected void notifyListeners(OverlayChangeEvent overlayChangeEvent) {
        Object[] objectArray = this.changeListeners.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != OverlayChangeListener.class) continue;
            ((OverlayChangeListener)objectArray[i2 + 1]).overlayChanged(overlayChangeEvent);
        }
    }
}

