/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.needle;

import java.awt.Graphics2D;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.needle.MeterNeedle;

public class PlumNeedle
extends MeterNeedle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -3082660488660600718L;

    @Override
    protected void drawNeedle(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d2) {
        Arc2D.Double double_ = new Arc2D.Double(2);
        double d3 = rectangle2D.getHeight();
        double d4 = rectangle2D.getWidth() / 2.0;
        double d5 = 2.0 * d3;
        double_.setFrame(rectangle2D.getMinX() + d4 - d3, rectangle2D.getMinY() - d3, d5, d5);
        d3 = Math.toDegrees(Math.asin(d4 / d3));
        ((Arc2D)double_).setAngleStart(270.0 - d3);
        ((Arc2D)double_).setAngleExtent(2.0 * d3);
        Area area = new Area(double_);
        if (point2D != null && d2 != 0.0) {
            this.getTransform().setToRotation(d2, point2D.getX(), point2D.getY());
            area.transform(this.getTransform());
        }
        this.defaultDisplay(graphics2D, area);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PlumNeedle)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        return super.clone();
    }
}

