/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.needle;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.needle.MeterNeedle;

public class ArrowNeedle
extends MeterNeedle
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5334056511213782357L;
    private boolean isArrowAtTop = true;

    public ArrowNeedle(boolean bl2) {
        this.isArrowAtTop = bl2;
    }

    @Override
    protected void drawNeedle(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, double d2) {
        Shape shape;
        Line2D.Float float_ = new Line2D.Float();
        float f2 = (float)(rectangle2D.getMinX() + rectangle2D.getWidth() / 2.0);
        float f3 = (float)rectangle2D.getMinY();
        float f4 = (float)rectangle2D.getMaxY();
        ((Line2D)float_).setLine(f2, f3, f2, f4);
        GeneralPath generalPath = new GeneralPath();
        if (this.isArrowAtTop) {
            generalPath.moveTo(f2, f3);
            f3 += (float)(4 * this.getSize());
        } else {
            generalPath.moveTo(f2, f4);
            f3 = f4 - (float)(4 * this.getSize());
        }
        generalPath.lineTo(f2 + (float)this.getSize(), f3);
        generalPath.lineTo(f2 - (float)this.getSize(), f3);
        generalPath.closePath();
        if (point2D != null && d2 != 0.0) {
            this.getTransform().setToRotation(d2, point2D.getX(), point2D.getY());
            shape = this.getTransform().createTransformedShape(float_);
        } else {
            shape = float_;
        }
        this.defaultDisplay(graphics2D, shape);
        shape = point2D != null && d2 != 0.0 ? this.getTransform().createTransformedShape(generalPath) : generalPath;
        this.defaultDisplay(graphics2D, shape);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ArrowNeedle)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ArrowNeedle arrowNeedle = (ArrowNeedle)object;
        return this.isArrowAtTop == arrowNeedle.isArrowAtTop;
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = HashUtilities.hashCode(n2, this.isArrowAtTop);
        return n2;
    }

    public Object clone() {
        return super.clone();
    }
}

