/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class StandardXYSeriesLabelGenerator
implements Serializable,
Cloneable,
XYSeriesLabelGenerator,
PublicCloneable {
    private static final long serialVersionUID = 1916017081848400024L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardXYSeriesLabelGenerator(String string) {
        ParamChecks.nullNotPermitted(string, "format");
        this.formatPattern = string;
    }

    @Override
    public String generateLabel(XYDataset xYDataset, int n2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        String string = MessageFormat.format(this.formatPattern, this.createItemArray(xYDataset, n2));
        return string;
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n2) {
        Object[] objectArray = new Object[]{xYDataset.getSeriesKey(n2).toString()};
        return objectArray;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYSeriesLabelGenerator)) {
            return false;
        }
        StandardXYSeriesLabelGenerator standardXYSeriesLabelGenerator = (StandardXYSeriesLabelGenerator)object;
        return this.formatPattern.equals(standardXYSeriesLabelGenerator.formatPattern);
    }

    public int hashCode() {
        int n2 = 127;
        n2 = HashUtilities.hashCode(n2, this.formatPattern);
        return n2;
    }
}

