/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.CategorySeriesLabelGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.PublicCloneable;

public class StandardCategorySeriesLabelGenerator
implements Serializable,
Cloneable,
CategorySeriesLabelGenerator,
PublicCloneable {
    private static final long serialVersionUID = 4630760091523940820L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;

    public StandardCategorySeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public StandardCategorySeriesLabelGenerator(String string) {
        ParamChecks.nullNotPermitted(string, "format");
        this.formatPattern = string;
    }

    @Override
    public String generateLabel(CategoryDataset categoryDataset, int n2) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        String string = MessageFormat.format(this.formatPattern, this.createItemArray(categoryDataset, n2));
        return string;
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n2) {
        Object[] objectArray = new Object[]{categoryDataset.getRowKey(n2).toString()};
        return objectArray;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardCategorySeriesLabelGenerator)) {
            return false;
        }
        StandardCategorySeriesLabelGenerator standardCategorySeriesLabelGenerator = (StandardCategorySeriesLabelGenerator)object;
        return this.formatPattern.equals(standardCategorySeriesLabelGenerator.formatPattern);
    }

    public int hashCode() {
        int n2 = 127;
        n2 = HashUtilities.hashCode(n2, this.formatPattern);
        return n2;
    }
}

