/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class MultipleXYSeriesLabelGenerator
implements Serializable,
Cloneable,
XYSeriesLabelGenerator,
PublicCloneable {
    private static final long serialVersionUID = 138976236941898560L;
    public static final String DEFAULT_LABEL_FORMAT = "{0}";
    private String formatPattern;
    private String additionalFormatPattern;
    private Map seriesLabelLists;

    public MultipleXYSeriesLabelGenerator() {
        this(DEFAULT_LABEL_FORMAT);
    }

    public MultipleXYSeriesLabelGenerator(String string) {
        ParamChecks.nullNotPermitted(string, "format");
        this.formatPattern = string;
        this.additionalFormatPattern = "\n{0}";
        this.seriesLabelLists = new HashMap();
    }

    public void addSeriesLabel(int n2, String string) {
        Integer n3 = new Integer(n2);
        ArrayList<String> arrayList = (ArrayList<String>)this.seriesLabelLists.get(n3);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.seriesLabelLists.put(n3, arrayList);
        }
        arrayList.add(string);
    }

    public void clearSeriesLabels(int n2) {
        Integer n3 = new Integer(n2);
        this.seriesLabelLists.put(n3, null);
    }

    @Override
    public String generateLabel(XYDataset xYDataset, int n2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format(this.formatPattern, this.createItemArray(xYDataset, n2)));
        Integer n3 = new Integer(n2);
        List list = (List)this.seriesLabelLists.get(n3);
        if (list != null) {
            Object[] objectArray = new Object[1];
            for (int i2 = 0; i2 < list.size(); ++i2) {
                objectArray[0] = list.get(i2);
                String string = MessageFormat.format(this.additionalFormatPattern, objectArray);
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n2) {
        Object[] objectArray = new Object[]{xYDataset.getSeriesKey(n2).toString()};
        return objectArray;
    }

    @Override
    public Object clone() {
        MultipleXYSeriesLabelGenerator multipleXYSeriesLabelGenerator = (MultipleXYSeriesLabelGenerator)super.clone();
        multipleXYSeriesLabelGenerator.seriesLabelLists = new HashMap();
        Set set = this.seriesLabelLists.keySet();
        for (Object k2 : set) {
            Object v2;
            Object object = v2 = this.seriesLabelLists.get(k2);
            if (v2 instanceof PublicCloneable) {
                PublicCloneable publicCloneable = (PublicCloneable)v2;
                object = publicCloneable.clone();
            }
            multipleXYSeriesLabelGenerator.seriesLabelLists.put(k2, object);
        }
        return multipleXYSeriesLabelGenerator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MultipleXYSeriesLabelGenerator)) {
            return false;
        }
        MultipleXYSeriesLabelGenerator multipleXYSeriesLabelGenerator = (MultipleXYSeriesLabelGenerator)object;
        if (!this.formatPattern.equals(multipleXYSeriesLabelGenerator.formatPattern)) {
            return false;
        }
        if (!this.additionalFormatPattern.equals(multipleXYSeriesLabelGenerator.additionalFormatPattern)) {
            return false;
        }
        return this.seriesLabelLists.equals(multipleXYSeriesLabelGenerator.seriesLabelLists);
    }

    public int hashCode() {
        int n2 = 127;
        n2 = HashUtilities.hashCode(n2, this.formatPattern);
        n2 = HashUtilities.hashCode(n2, this.additionalFormatPattern);
        n2 = HashUtilities.hashCode(n2, this.seriesLabelLists);
        return n2;
    }
}

