/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class IntervalXYItemLabelGenerator
extends AbstractXYItemLabelGenerator
implements Serializable,
Cloneable,
XYItemLabelGenerator,
PublicCloneable {
    public static final String DEFAULT_ITEM_LABEL_FORMAT = "{5} - {6}";

    public IntervalXYItemLabelGenerator() {
        this(DEFAULT_ITEM_LABEL_FORMAT, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public IntervalXYItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        super(string, numberFormat, numberFormat2);
    }

    public IntervalXYItemLabelGenerator(String string, DateFormat dateFormat, NumberFormat numberFormat) {
        super(string, dateFormat, numberFormat);
    }

    public IntervalXYItemLabelGenerator(String string, NumberFormat numberFormat, DateFormat dateFormat) {
        super(string, numberFormat, dateFormat);
    }

    public IntervalXYItemLabelGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        super(string, dateFormat, dateFormat2);
    }

    @Override
    protected Object[] createItemArray(XYDataset xYDataset, int n2, int n3) {
        NumberFormat numberFormat;
        DateFormat dateFormat;
        double d2;
        double d3;
        IntervalXYDataset intervalXYDataset = null;
        if (xYDataset instanceof IntervalXYDataset) {
            intervalXYDataset = (IntervalXYDataset)xYDataset;
        }
        Object[] objectArray = new Object[7];
        objectArray[0] = xYDataset.getSeriesKey(n2).toString();
        double d4 = d3 = xYDataset.getXValue(n2, n3);
        double d5 = d3;
        double d6 = d2 = xYDataset.getYValue(n2, n3);
        double d7 = d2;
        if (intervalXYDataset != null) {
            d4 = intervalXYDataset.getStartXValue(n2, n3);
            d5 = intervalXYDataset.getEndXValue(n2, n3);
            d6 = intervalXYDataset.getStartYValue(n2, n3);
            d7 = intervalXYDataset.getEndYValue(n2, n3);
        }
        if ((dateFormat = this.getXDateFormat()) != null) {
            objectArray[1] = dateFormat.format(new Date((long)d3));
            objectArray[2] = dateFormat.format(new Date((long)d4));
            objectArray[3] = dateFormat.format(new Date((long)d5));
        } else {
            numberFormat = this.getXFormat();
            objectArray[1] = numberFormat.format(d3);
            objectArray[2] = numberFormat.format(d4);
            objectArray[3] = numberFormat.format(d5);
        }
        numberFormat = this.getYFormat();
        DateFormat dateFormat2 = this.getYDateFormat();
        objectArray[4] = Double.isNaN(d2) && xYDataset.getY(n2, n3) == null ? this.getNullYString() : (dateFormat2 != null ? dateFormat2.format(new Date((long)d2)) : numberFormat.format(d2));
        objectArray[5] = Double.isNaN(d6) && intervalXYDataset != null && intervalXYDataset.getStartY(n2, n3) == null ? this.getNullYString() : (dateFormat2 != null ? dateFormat2.format(new Date((long)d6)) : numberFormat.format(d6));
        objectArray[6] = Double.isNaN(d7) && intervalXYDataset != null && intervalXYDataset.getEndY(n2, n3) == null ? this.getNullYString() : (dateFormat2 != null ? dateFormat2.format(new Date((long)d7)) : numberFormat.format(d7));
        return objectArray;
    }

    @Override
    public String generateLabel(XYDataset xYDataset, int n2, int n3) {
        return this.generateLabelString(xYDataset, n2, n3);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof IntervalXYItemLabelGenerator)) {
            return false;
        }
        return super.equals(object);
    }
}

