/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.util.PublicCloneable;

public class IntervalCategoryItemLabelGenerator
extends StandardCategoryItemLabelGenerator
implements Serializable,
Cloneable,
CategoryItemLabelGenerator,
PublicCloneable {
    private static final long serialVersionUID = 5056909225610630529L;
    public static final String DEFAULT_LABEL_FORMAT_STRING = "({0}, {1}) = {3} - {4}";

    public IntervalCategoryItemLabelGenerator() {
        super(DEFAULT_LABEL_FORMAT_STRING, NumberFormat.getInstance());
    }

    public IntervalCategoryItemLabelGenerator(String string, NumberFormat numberFormat) {
        super(string, numberFormat);
    }

    public IntervalCategoryItemLabelGenerator(String string, DateFormat dateFormat) {
        super(string, dateFormat);
    }

    @Override
    protected Object[] createItemArray(CategoryDataset categoryDataset, int n2, int n3) {
        Object[] objectArray = new Object[5];
        objectArray[0] = categoryDataset.getRowKey(n2).toString();
        objectArray[1] = categoryDataset.getColumnKey(n3).toString();
        Number number = categoryDataset.getValue(n2, n3);
        if (this.getNumberFormat() != null) {
            objectArray[2] = this.getNumberFormat().format(number);
        } else if (this.getDateFormat() != null) {
            objectArray[2] = this.getDateFormat().format(number);
        }
        if (categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            Number number2 = intervalCategoryDataset.getStartValue(n2, n3);
            Number number3 = intervalCategoryDataset.getEndValue(n2, n3);
            if (this.getNumberFormat() != null) {
                objectArray[3] = this.getNumberFormat().format(number2);
                objectArray[4] = this.getNumberFormat().format(number3);
            } else if (this.getDateFormat() != null) {
                objectArray[3] = this.getDateFormat().format(number2);
                objectArray[4] = this.getDateFormat().format(number3);
            }
        }
        return objectArray;
    }
}

