/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class HighLowItemLabelGenerator
implements Serializable,
Cloneable,
XYItemLabelGenerator,
XYToolTipGenerator,
PublicCloneable {
    private static final long serialVersionUID = 5617111754832211830L;
    private DateFormat dateFormatter;
    private NumberFormat numberFormatter;

    public HighLowItemLabelGenerator() {
        this(DateFormat.getInstance(), NumberFormat.getInstance());
    }

    public HighLowItemLabelGenerator(DateFormat dateFormat, NumberFormat numberFormat) {
        if (dateFormat == null) {
            throw new IllegalArgumentException("Null 'dateFormatter' argument.");
        }
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'numberFormatter' argument.");
        }
        this.dateFormatter = dateFormat;
        this.numberFormatter = numberFormat;
    }

    @Override
    public String generateToolTip(XYDataset xYDataset, int n2, int n3) {
        if (!(xYDataset instanceof OHLCDataset)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
        Number number = oHLCDataset.getHigh(n2, n3);
        Number number2 = oHLCDataset.getLow(n2, n3);
        Number number3 = oHLCDataset.getOpen(n2, n3);
        Number number4 = oHLCDataset.getClose(n2, n3);
        Number number5 = oHLCDataset.getX(n2, n3);
        stringBuilder.append(oHLCDataset.getSeriesKey(n2).toString());
        if (number5 != null) {
            Date date = new Date(number5.longValue());
            stringBuilder.append("--> Date=").append(this.dateFormatter.format(date));
            if (number != null) {
                stringBuilder.append(" High=");
                stringBuilder.append(this.numberFormatter.format(number.doubleValue()));
            }
            if (number2 != null) {
                stringBuilder.append(" Low=");
                stringBuilder.append(this.numberFormatter.format(number2.doubleValue()));
            }
            if (number3 != null) {
                stringBuilder.append(" Open=");
                stringBuilder.append(this.numberFormatter.format(number3.doubleValue()));
            }
            if (number4 != null) {
                stringBuilder.append(" Close=");
                stringBuilder.append(this.numberFormatter.format(number4.doubleValue()));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String generateLabel(XYDataset xYDataset, int n2, int n3) {
        return null;
    }

    @Override
    public Object clone() {
        HighLowItemLabelGenerator highLowItemLabelGenerator = (HighLowItemLabelGenerator)super.clone();
        if (this.dateFormatter != null) {
            highLowItemLabelGenerator.dateFormatter = (DateFormat)this.dateFormatter.clone();
        }
        if (this.numberFormatter != null) {
            highLowItemLabelGenerator.numberFormatter = (NumberFormat)this.numberFormatter.clone();
        }
        return highLowItemLabelGenerator;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof HighLowItemLabelGenerator)) {
            return false;
        }
        HighLowItemLabelGenerator highLowItemLabelGenerator = (HighLowItemLabelGenerator)object;
        if (!this.dateFormatter.equals(highLowItemLabelGenerator.dateFormatter)) {
            return false;
        }
        return this.numberFormatter.equals(highLowItemLabelGenerator.numberFormatter);
    }

    public int hashCode() {
        int n2 = 127;
        n2 = HashUtilities.hashCode(n2, this.dateFormatter);
        n2 = HashUtilities.hashCode(n2, this.numberFormatter);
        return n2;
    }
}

