/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class BubbleXYItemLabelGenerator
extends AbstractXYItemLabelGenerator
implements Serializable,
XYItemLabelGenerator,
PublicCloneable {
    static final long serialVersionUID = -8458568928021240922L;
    public static final String DEFAULT_FORMAT_STRING = "{3}";
    private NumberFormat zFormat;
    private DateFormat zDateFormat;

    public BubbleXYItemLabelGenerator() {
        this(DEFAULT_FORMAT_STRING, NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    public BubbleXYItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2, NumberFormat numberFormat3) {
        super(string, numberFormat, numberFormat2);
        ParamChecks.nullNotPermitted(numberFormat3, "zFormat");
        this.zFormat = numberFormat3;
    }

    public BubbleXYItemLabelGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2, DateFormat dateFormat3) {
        super(string, dateFormat, dateFormat2);
        ParamChecks.nullNotPermitted(dateFormat3, "zFormat");
        this.zDateFormat = dateFormat3;
    }

    public NumberFormat getZFormat() {
        return this.zFormat;
    }

    public DateFormat getZDateFormat() {
        return this.zDateFormat;
    }

    @Override
    public String generateLabel(XYDataset xYDataset, int n2, int n3) {
        return this.generateLabelString(xYDataset, n2, n3);
    }

    @Override
    public String generateLabelString(XYDataset xYDataset, int n2, int n3) {
        Object[] objectArray = xYDataset instanceof XYZDataset ? this.createItemArray((XYZDataset)xYDataset, n2, n3) : this.createItemArray(xYDataset, n2, n3);
        String string = MessageFormat.format(this.getFormatString(), objectArray);
        return string;
    }

    protected Object[] createItemArray(XYZDataset xYZDataset, int n2, int n3) {
        Object[] objectArray = new Object[4];
        objectArray[0] = xYZDataset.getSeriesKey(n2).toString();
        Number number = xYZDataset.getX(n2, n3);
        DateFormat dateFormat = this.getXDateFormat();
        objectArray[1] = dateFormat != null ? dateFormat.format(number) : this.getXFormat().format(number);
        Number number2 = xYZDataset.getY(n2, n3);
        DateFormat dateFormat2 = this.getYDateFormat();
        objectArray[2] = dateFormat2 != null ? dateFormat2.format(number2) : this.getYFormat().format(number2);
        Number number3 = xYZDataset.getZ(n2, n3);
        objectArray[3] = this.zDateFormat != null ? this.zDateFormat.format(number3) : this.zFormat.format(number3);
        return objectArray;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BubbleXYItemLabelGenerator)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        BubbleXYItemLabelGenerator bubbleXYItemLabelGenerator = (BubbleXYItemLabelGenerator)object;
        if (!ObjectUtilities.equal(this.zFormat, bubbleXYItemLabelGenerator.zFormat)) {
            return false;
        }
        return ObjectUtilities.equal(this.zDateFormat, bubbleXYItemLabelGenerator.zDateFormat);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = HashUtilities.hashCode(n2, this.zFormat);
        n2 = HashUtilities.hashCode(n2, this.zDateFormat);
        return n2;
    }
}

