/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Date;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtilities;

public class AbstractXYItemLabelGenerator
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 5869744396278660636L;
    private String formatString;
    private NumberFormat xFormat;
    private DateFormat xDateFormat;
    private NumberFormat yFormat;
    private DateFormat yDateFormat;
    private String nullYString = "null";

    protected AbstractXYItemLabelGenerator() {
        this("{2}", NumberFormat.getNumberInstance(), NumberFormat.getNumberInstance());
    }

    protected AbstractXYItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        ParamChecks.nullNotPermitted(string, "formatString");
        ParamChecks.nullNotPermitted(numberFormat, "xFormat");
        ParamChecks.nullNotPermitted(numberFormat2, "yFormat");
        this.formatString = string;
        this.xFormat = numberFormat;
        this.yFormat = numberFormat2;
    }

    protected AbstractXYItemLabelGenerator(String string, DateFormat dateFormat, NumberFormat numberFormat) {
        this(string, NumberFormat.getInstance(), numberFormat);
        this.xDateFormat = dateFormat;
    }

    protected AbstractXYItemLabelGenerator(String string, NumberFormat numberFormat, DateFormat dateFormat) {
        this(string, numberFormat, NumberFormat.getInstance());
        this.yDateFormat = dateFormat;
    }

    protected AbstractXYItemLabelGenerator(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        this(string, NumberFormat.getInstance(), NumberFormat.getInstance());
        this.xDateFormat = dateFormat;
        this.yDateFormat = dateFormat2;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public NumberFormat getXFormat() {
        return this.xFormat;
    }

    public DateFormat getXDateFormat() {
        return this.xDateFormat;
    }

    public NumberFormat getYFormat() {
        return this.yFormat;
    }

    public DateFormat getYDateFormat() {
        return this.yDateFormat;
    }

    public String generateLabelString(XYDataset xYDataset, int n2, int n3) {
        Object[] objectArray = this.createItemArray(xYDataset, n2, n3);
        String string = MessageFormat.format(this.formatString, objectArray);
        return string;
    }

    public String getNullYString() {
        return this.nullYString;
    }

    protected Object[] createItemArray(XYDataset xYDataset, int n2, int n3) {
        Object[] objectArray = new Object[3];
        objectArray[0] = xYDataset.getSeriesKey(n2).toString();
        double d2 = xYDataset.getXValue(n2, n3);
        objectArray[1] = this.xDateFormat != null ? this.xDateFormat.format(new Date((long)d2)) : this.xFormat.format(d2);
        double d3 = xYDataset.getYValue(n2, n3);
        objectArray[2] = Double.isNaN(d3) && xYDataset.getY(n2, n3) == null ? this.nullYString : (this.yDateFormat != null ? this.yDateFormat.format(new Date((long)d3)) : this.yFormat.format(d3));
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractXYItemLabelGenerator)) {
            return false;
        }
        AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = (AbstractXYItemLabelGenerator)object;
        if (!this.formatString.equals(abstractXYItemLabelGenerator.formatString)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.xFormat, abstractXYItemLabelGenerator.xFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.xDateFormat, abstractXYItemLabelGenerator.xDateFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.yFormat, abstractXYItemLabelGenerator.yFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.yDateFormat, abstractXYItemLabelGenerator.yDateFormat)) {
            return false;
        }
        return this.nullYString.equals(abstractXYItemLabelGenerator.nullYString);
    }

    public int hashCode() {
        int n2 = 127;
        n2 = HashUtilities.hashCode(n2, this.formatString);
        n2 = HashUtilities.hashCode(n2, this.xFormat);
        n2 = HashUtilities.hashCode(n2, this.xDateFormat);
        n2 = HashUtilities.hashCode(n2, this.yFormat);
        n2 = HashUtilities.hashCode(n2, this.yDateFormat);
        return n2;
    }

    public Object clone() {
        AbstractXYItemLabelGenerator abstractXYItemLabelGenerator = (AbstractXYItemLabelGenerator)super.clone();
        if (this.xFormat != null) {
            abstractXYItemLabelGenerator.xFormat = (NumberFormat)this.xFormat.clone();
        }
        if (this.yFormat != null) {
            abstractXYItemLabelGenerator.yFormat = (NumberFormat)this.yFormat.clone();
        }
        if (this.xDateFormat != null) {
            abstractXYItemLabelGenerator.xDateFormat = (DateFormat)this.xDateFormat.clone();
        }
        if (this.yDateFormat != null) {
            abstractXYItemLabelGenerator.yDateFormat = (DateFormat)this.yDateFormat.clone();
        }
        return abstractXYItemLabelGenerator;
    }
}

