/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DataUtilities;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class AbstractCategoryItemLabelGenerator
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -7108591260223293197L;
    private String labelFormat;
    private String nullValueString;
    private NumberFormat numberFormat;
    private DateFormat dateFormat;
    private NumberFormat percentFormat;

    protected AbstractCategoryItemLabelGenerator(String string, NumberFormat numberFormat) {
        this(string, numberFormat, NumberFormat.getPercentInstance());
    }

    protected AbstractCategoryItemLabelGenerator(String string, NumberFormat numberFormat, NumberFormat numberFormat2) {
        ParamChecks.nullNotPermitted(string, "labelFormat");
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        ParamChecks.nullNotPermitted(numberFormat2, "percentFormatter");
        this.labelFormat = string;
        this.numberFormat = numberFormat;
        this.percentFormat = numberFormat2;
        this.dateFormat = null;
        this.nullValueString = "-";
    }

    protected AbstractCategoryItemLabelGenerator(String string, DateFormat dateFormat) {
        ParamChecks.nullNotPermitted(string, "labelFormat");
        ParamChecks.nullNotPermitted(dateFormat, "formatter");
        this.labelFormat = string;
        this.numberFormat = null;
        this.percentFormat = NumberFormat.getPercentInstance();
        this.dateFormat = dateFormat;
        this.nullValueString = "-";
    }

    public String generateRowLabel(CategoryDataset categoryDataset, int n2) {
        return categoryDataset.getRowKey(n2).toString();
    }

    public String generateColumnLabel(CategoryDataset categoryDataset, int n2) {
        return categoryDataset.getColumnKey(n2).toString();
    }

    public String getLabelFormat() {
        return this.labelFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    protected String generateLabelString(CategoryDataset categoryDataset, int n2, int n3) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        Object[] objectArray = this.createItemArray(categoryDataset, n2, n3);
        String string = MessageFormat.format(this.labelFormat, objectArray);
        return string;
    }

    protected Object[] createItemArray(CategoryDataset categoryDataset, int n2, int n3) {
        Object[] objectArray = new Object[4];
        objectArray[0] = categoryDataset.getRowKey(n2).toString();
        objectArray[1] = categoryDataset.getColumnKey(n3).toString();
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            if (this.numberFormat != null) {
                objectArray[2] = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                objectArray[2] = this.dateFormat.format(number);
            }
        } else {
            objectArray[2] = this.nullValueString;
        }
        if (number != null) {
            double d2 = DataUtilities.calculateColumnTotal(categoryDataset, n3);
            double d3 = number.doubleValue() / d2;
            objectArray[3] = this.percentFormat.format(d3);
        }
        return objectArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractCategoryItemLabelGenerator)) {
            return false;
        }
        AbstractCategoryItemLabelGenerator abstractCategoryItemLabelGenerator = (AbstractCategoryItemLabelGenerator)object;
        if (!this.labelFormat.equals(abstractCategoryItemLabelGenerator.labelFormat)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dateFormat, abstractCategoryItemLabelGenerator.dateFormat)) {
            return false;
        }
        return ObjectUtilities.equal(this.numberFormat, abstractCategoryItemLabelGenerator.numberFormat);
    }

    public int hashCode() {
        int n2 = 127;
        n2 = HashUtilities.hashCode(n2, this.labelFormat);
        n2 = HashUtilities.hashCode(n2, this.nullValueString);
        n2 = HashUtilities.hashCode(n2, this.dateFormat);
        n2 = HashUtilities.hashCode(n2, this.numberFormat);
        n2 = HashUtilities.hashCode(n2, this.percentFormat);
        return n2;
    }

    @Override
    public Object clone() {
        AbstractCategoryItemLabelGenerator abstractCategoryItemLabelGenerator = (AbstractCategoryItemLabelGenerator)super.clone();
        if (this.numberFormat != null) {
            abstractCategoryItemLabelGenerator.numberFormat = (NumberFormat)this.numberFormat.clone();
        }
        if (this.dateFormat != null) {
            abstractCategoryItemLabelGenerator.dateFormat = (DateFormat)this.dateFormat.clone();
        }
        return abstractCategoryItemLabelGenerator;
    }
}

