/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.imagemap;

import java.io.PrintWriter;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.imagemap.OverLIBToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.util.StringUtils;

public class ImageMapUtilities {
    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo) {
        ImageMapUtilities.writeImageMap(printWriter, string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, boolean bl2) {
        ToolTipTagFragmentGenerator toolTipTagFragmentGenerator = bl2 ? new OverLIBToolTipTagFragmentGenerator() : new StandardToolTipTagFragmentGenerator();
        ImageMapUtilities.writeImageMap(printWriter, string, chartRenderingInfo, toolTipTagFragmentGenerator, new StandardURLTagFragmentGenerator());
    }

    public static void writeImageMap(PrintWriter printWriter, String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        printWriter.println(ImageMapUtilities.getImageMap(string, chartRenderingInfo, toolTipTagFragmentGenerator, uRLTagFragmentGenerator));
    }

    public static String getImageMap(String string, ChartRenderingInfo chartRenderingInfo) {
        return ImageMapUtilities.getImageMap(string, chartRenderingInfo, new StandardToolTipTagFragmentGenerator(), new StandardURLTagFragmentGenerator());
    }

    public static String getImageMap(String string, ChartRenderingInfo chartRenderingInfo, ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<map id=\"").append(ImageMapUtilities.htmlEscape(string));
        stringBuilder.append("\" name=\"").append(ImageMapUtilities.htmlEscape(string)).append("\">");
        stringBuilder.append(StringUtils.getLineSeparator());
        EntityCollection entityCollection = chartRenderingInfo.getEntityCollection();
        if (entityCollection != null) {
            int n2 = entityCollection.getEntityCount();
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                String string2;
                ChartEntity chartEntity = entityCollection.getEntity(i2);
                if (chartEntity.getToolTipText() == null && chartEntity.getURLText() == null || (string2 = chartEntity.getImageMapAreaTag(toolTipTagFragmentGenerator, uRLTagFragmentGenerator)).length() <= 0) continue;
                stringBuilder.append(string2);
                stringBuilder.append(StringUtils.getLineSeparator());
            }
        }
        stringBuilder.append("</map>");
        return stringBuilder.toString();
    }

    public static String htmlEscape(String string) {
        ParamChecks.nullNotPermitted(string, "input");
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '&') {
                stringBuilder.append("&amp;");
                continue;
            }
            if (c2 == '\"') {
                stringBuilder.append("&quot;");
                continue;
            }
            if (c2 == '<') {
                stringBuilder.append("&lt;");
                continue;
            }
            if (c2 == '>') {
                stringBuilder.append("&gt;");
                continue;
            }
            if (c2 == '\'') {
                stringBuilder.append("&#39;");
                continue;
            }
            if (c2 == '\\') {
                stringBuilder.append("&#092;");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String javascriptEscape(String string) {
        ParamChecks.nullNotPermitted(string, "input");
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c2 == '\'') {
                stringBuilder.append("\\'");
                continue;
            }
            if (c2 == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }
}

