/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class TitleEntity
extends ChartEntity {
    private static final long serialVersionUID = -4445994133561919083L;
    private Title title;

    public TitleEntity(Shape shape, Title title) {
        this(shape, title, null);
    }

    public TitleEntity(Shape shape, Title title, String string) {
        this(shape, title, string, null);
    }

    public TitleEntity(Shape shape, Title title, String string, String string2) {
        super(shape, string, string2);
        ParamChecks.nullNotPermitted(title, "title");
        this.title = title;
    }

    public Title getTitle() {
        return this.title;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TitleEntity: ");
        stringBuilder.append("tooltip = ");
        stringBuilder.append(this.getToolTipText());
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TitleEntity)) {
            return false;
        }
        TitleEntity titleEntity = (TitleEntity)object;
        if (!this.getArea().equals(titleEntity.getArea())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getToolTipText(), titleEntity.getToolTipText())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getURLText(), titleEntity.getURLText())) {
            return false;
        }
        return this.title.equals(titleEntity.title);
    }

    @Override
    public int hashCode() {
        int n2 = 41;
        n2 = HashUtilities.hashCode(n2, this.getToolTipText());
        n2 = HashUtilities.hashCode(n2, this.getURLText());
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.getArea(), objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.setArea(SerialUtilities.readShape(objectInputStream));
    }
}

