/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.util.ParamChecks;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class StandardEntityCollection
implements Serializable,
Cloneable,
EntityCollection,
PublicCloneable {
    private static final long serialVersionUID = 5384773031184897047L;
    private List entities = new ArrayList();

    @Override
    public int getEntityCount() {
        return this.entities.size();
    }

    @Override
    public ChartEntity getEntity(int n2) {
        return (ChartEntity)this.entities.get(n2);
    }

    @Override
    public void clear() {
        this.entities.clear();
    }

    @Override
    public void add(ChartEntity chartEntity) {
        ParamChecks.nullNotPermitted(chartEntity, "entity");
        this.entities.add(chartEntity);
    }

    @Override
    public void addAll(EntityCollection entityCollection) {
        this.entities.addAll(entityCollection.getEntities());
    }

    @Override
    public ChartEntity getEntity(double d2, double d3) {
        int n2 = this.entities.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            ChartEntity chartEntity = (ChartEntity)this.entities.get(i2);
            if (!chartEntity.getArea().contains(d2, d3)) continue;
            return chartEntity;
        }
        return null;
    }

    @Override
    public Collection getEntities() {
        return Collections.unmodifiableCollection(this.entities);
    }

    @Override
    public Iterator iterator() {
        return this.entities.iterator();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof StandardEntityCollection) {
            StandardEntityCollection standardEntityCollection = (StandardEntityCollection)object;
            return ObjectUtilities.equal(this.entities, standardEntityCollection.entities);
        }
        return false;
    }

    @Override
    public Object clone() {
        StandardEntityCollection standardEntityCollection = (StandardEntityCollection)super.clone();
        standardEntityCollection.entities = new ArrayList(this.entities.size());
        for (int i2 = 0; i2 < this.entities.size(); ++i2) {
            ChartEntity chartEntity = (ChartEntity)this.entities.get(i2);
            standardEntityCollection.entities.add(chartEntity.clone());
        }
        return standardEntityCollection;
    }
}

