/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.data.general.PieDataset;
import org.jfree.util.ObjectUtilities;

public class PieSectionEntity
extends ChartEntity
implements Serializable {
    private static final long serialVersionUID = 9199892576531984162L;
    private PieDataset dataset;
    private int pieIndex;
    private int sectionIndex;
    private Comparable sectionKey;

    public PieSectionEntity(Shape shape, PieDataset pieDataset, int n2, int n3, Comparable comparable, String string, String string2) {
        super(shape, string, string2);
        this.dataset = pieDataset;
        this.pieIndex = n2;
        this.sectionIndex = n3;
        this.sectionKey = comparable;
    }

    public PieDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(PieDataset pieDataset) {
        this.dataset = pieDataset;
    }

    public int getPieIndex() {
        return this.pieIndex;
    }

    public void setPieIndex(int n2) {
        this.pieIndex = n2;
    }

    public int getSectionIndex() {
        return this.sectionIndex;
    }

    public void setSectionIndex(int n2) {
        this.sectionIndex = n2;
    }

    public Comparable getSectionKey() {
        return this.sectionKey;
    }

    public void setSectionKey(Comparable comparable) {
        this.sectionKey = comparable;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieSectionEntity)) {
            return false;
        }
        PieSectionEntity pieSectionEntity = (PieSectionEntity)object;
        if (!ObjectUtilities.equal(this.dataset, pieSectionEntity.dataset)) {
            return false;
        }
        if (this.pieIndex != pieSectionEntity.pieIndex) {
            return false;
        }
        if (this.sectionIndex != pieSectionEntity.sectionIndex) {
            return false;
        }
        if (!ObjectUtilities.equal(this.sectionKey, pieSectionEntity.sectionKey)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = HashUtilities.hashCode(n2, this.pieIndex);
        n2 = HashUtilities.hashCode(n2, this.sectionIndex);
        return n2;
    }

    @Override
    public String toString() {
        return "PieSection: " + this.pieIndex + ", " + this.sectionIndex + "(" + this.sectionKey.toString() + ")";
    }
}

