/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class JFreeChartEntity
extends ChartEntity {
    private static final long serialVersionUID = -4445994133561919083L;
    private JFreeChart chart;

    public JFreeChartEntity(Shape shape, JFreeChart jFreeChart) {
        this(shape, jFreeChart, null);
    }

    public JFreeChartEntity(Shape shape, JFreeChart jFreeChart, String string) {
        this(shape, jFreeChart, string, null);
    }

    public JFreeChartEntity(Shape shape, JFreeChart jFreeChart, String string, String string2) {
        super(shape, string, string2);
        ParamChecks.nullNotPermitted(jFreeChart, "chart");
        this.chart = jFreeChart;
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("JFreeChartEntity: ");
        stringBuilder.append("tooltip = ");
        stringBuilder.append(this.getToolTipText());
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof JFreeChartEntity)) {
            return false;
        }
        JFreeChartEntity jFreeChartEntity = (JFreeChartEntity)object;
        if (!this.getArea().equals(jFreeChartEntity.getArea())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getToolTipText(), jFreeChartEntity.getToolTipText())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getURLText(), jFreeChartEntity.getURLText())) {
            return false;
        }
        return this.chart.equals(jFreeChartEntity.chart);
    }

    @Override
    public int hashCode() {
        int n2 = 39;
        n2 = HashUtilities.hashCode(n2, this.getToolTipText());
        n2 = HashUtilities.hashCode(n2, this.getURLText());
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.getArea(), objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.setArea(SerialUtilities.readShape(objectInputStream));
    }
}

