/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class ChartEntity
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = -4445994133561919083L;
    private transient Shape area;
    private String toolTipText;
    private String urlText;

    public ChartEntity(Shape shape) {
        this(shape, null);
    }

    public ChartEntity(Shape shape, String string) {
        this(shape, string, null);
    }

    public ChartEntity(Shape shape, String string, String string2) {
        ParamChecks.nullNotPermitted(shape, "area");
        this.area = shape;
        this.toolTipText = string;
        this.urlText = string2;
    }

    public Shape getArea() {
        return this.area;
    }

    public void setArea(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "area");
        this.area = shape;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
    }

    public String getShapeType() {
        if (this.area instanceof Rectangle2D) {
            return "rect";
        }
        return "poly";
    }

    public String getShapeCoords() {
        if (this.area instanceof Rectangle2D) {
            return this.getRectCoords((Rectangle2D)this.area);
        }
        return this.getPolyCoords(this.area);
    }

    private String getRectCoords(Rectangle2D rectangle2D) {
        ParamChecks.nullNotPermitted(rectangle2D, "rectangle");
        int n2 = (int)rectangle2D.getX();
        int n3 = (int)rectangle2D.getY();
        int n4 = n2 + (int)rectangle2D.getWidth();
        int n5 = n3 + (int)rectangle2D.getHeight();
        if (n4 == n2) {
            ++n4;
        }
        if (n5 == n3) {
            ++n5;
        }
        return n2 + "," + n3 + "," + n4 + "," + n5;
    }

    private String getPolyCoords(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "shape");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        float[] fArray = new float[6];
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray);
            if (bl2) {
                bl2 = false;
                stringBuilder.append((int)fArray[0]);
                stringBuilder.append(",").append((int)fArray[1]);
            } else {
                stringBuilder.append(",");
                stringBuilder.append((int)fArray[0]);
                stringBuilder.append(",");
                stringBuilder.append((int)fArray[1]);
            }
            pathIterator.next();
        }
        return stringBuilder.toString();
    }

    public String getImageMapAreaTag(ToolTipTagFragmentGenerator toolTipTagFragmentGenerator, URLTagFragmentGenerator uRLTagFragmentGenerator) {
        boolean bl2;
        boolean bl3;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl4 = this.urlText == null ? false : (bl3 = !this.urlText.equals(""));
        boolean bl5 = this.toolTipText == null ? false : (bl2 = !this.toolTipText.equals(""));
        if (bl3 || bl2) {
            stringBuilder.append("<area shape=\"").append(this.getShapeType()).append("\"").append(" coords=\"").append(this.getShapeCoords()).append("\"");
            if (bl2) {
                stringBuilder.append(toolTipTagFragmentGenerator.generateToolTipFragment(this.toolTipText));
            }
            if (bl3) {
                stringBuilder.append(uRLTagFragmentGenerator.generateURLFragment(this.urlText));
            } else {
                stringBuilder.append(" nohref=\"nohref\"");
            }
            if (!bl2) {
                stringBuilder.append(" alt=\"\"");
            }
            stringBuilder.append("/>");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ChartEntity: ");
        stringBuilder.append("tooltip = ");
        stringBuilder.append(this.toolTipText);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ChartEntity)) {
            return false;
        }
        ChartEntity chartEntity = (ChartEntity)object;
        if (!this.area.equals(chartEntity.area)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipText, chartEntity.toolTipText)) {
            return false;
        }
        return ObjectUtilities.equal(this.urlText, chartEntity.urlText);
    }

    public int hashCode() {
        int n2 = 37;
        n2 = HashUtilities.hashCode(n2, this.toolTipText);
        n2 = HashUtilities.hashCode(n2, this.urlText);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.area, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.area = SerialUtilities.readShape(objectInputStream);
    }
}

