/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.Serializable;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;

public class CategoryItemEntity
extends ChartEntity
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -8657249457902337349L;
    private CategoryDataset dataset;
    private int series;
    private Object category;
    private int categoryIndex;
    private Comparable rowKey;
    private Comparable columnKey;

    public CategoryItemEntity(Shape shape, String string, String string2, CategoryDataset categoryDataset, int n2, Object object, int n3) {
        super(shape, string, string2);
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        this.dataset = categoryDataset;
        this.series = n2;
        this.category = object;
        this.categoryIndex = n3;
        this.rowKey = categoryDataset.getRowKey(n2);
        this.columnKey = categoryDataset.getColumnKey(n3);
    }

    public CategoryItemEntity(Shape shape, String string, String string2, CategoryDataset categoryDataset, Comparable comparable, Comparable comparable2) {
        super(shape, string, string2);
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        this.dataset = categoryDataset;
        this.rowKey = comparable;
        this.columnKey = comparable2;
        this.series = categoryDataset.getRowIndex(comparable);
        this.category = comparable2;
        this.categoryIndex = categoryDataset.getColumnIndex(comparable2);
    }

    public CategoryDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(CategoryDataset categoryDataset) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        this.dataset = categoryDataset;
    }

    public Comparable getRowKey() {
        return this.rowKey;
    }

    public void setRowKey(Comparable comparable) {
        this.rowKey = comparable;
        this.series = this.dataset.getRowIndex(comparable);
    }

    public Comparable getColumnKey() {
        return this.columnKey;
    }

    public void setColumnKey(Comparable comparable) {
        this.columnKey = comparable;
        this.category = comparable;
        this.categoryIndex = this.dataset.getColumnIndex(comparable);
    }

    public int getSeries() {
        return this.series;
    }

    public void setSeries(int n2) {
        this.series = n2;
    }

    public Object getCategory() {
        return this.category;
    }

    public void setCategory(Object object) {
        this.category = object;
    }

    public int getCategoryIndex() {
        return this.categoryIndex;
    }

    public void setCategoryIndex(int n2) {
        this.categoryIndex = n2;
    }

    @Override
    public String toString() {
        return "CategoryItemEntity: rowKey=" + this.rowKey + ", columnKey=" + this.columnKey + ", dataset=" + this.dataset;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CategoryItemEntity)) {
            return false;
        }
        CategoryItemEntity categoryItemEntity = (CategoryItemEntity)object;
        if (!this.rowKey.equals(categoryItemEntity.rowKey)) {
            return false;
        }
        if (!this.columnKey.equals(categoryItemEntity.columnKey)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dataset, categoryItemEntity.dataset)) {
            return false;
        }
        if (this.categoryIndex != categoryItemEntity.categoryIndex) {
            return false;
        }
        if (this.series != categoryItemEntity.series) {
            return false;
        }
        if (!ObjectUtilities.equal(this.category, categoryItemEntity.category)) {
            return false;
        }
        return super.equals(object);
    }
}

