/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity;

import java.awt.Shape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.util.ObjectUtilities;

public class AxisEntity
extends ChartEntity {
    private static final long serialVersionUID = -4445994133561919083L;
    private Axis axis;

    public AxisEntity(Shape shape, Axis axis) {
        this(shape, axis, null);
    }

    public AxisEntity(Shape shape, Axis axis, String string) {
        this(shape, axis, string, null);
    }

    public AxisEntity(Shape shape, Axis axis, String string, String string2) {
        super(shape, string, string2);
        ParamChecks.nullNotPermitted(axis, "axis");
        this.axis = axis;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("AxisEntity: ");
        stringBuilder.append("tooltip = ");
        stringBuilder.append(this.getToolTipText());
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AxisEntity)) {
            return false;
        }
        AxisEntity axisEntity = (AxisEntity)object;
        if (!this.getArea().equals(axisEntity.getArea())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getToolTipText(), axisEntity.getToolTipText())) {
            return false;
        }
        if (!ObjectUtilities.equal(this.getURLText(), axisEntity.getURLText())) {
            return false;
        }
        return this.axis.equals(axisEntity.axis);
    }

    @Override
    public int hashCode() {
        int n2 = 39;
        n2 = HashUtilities.hashCode(n2, this.getToolTipText());
        n2 = HashUtilities.hashCode(n2, this.getURLText());
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.getArea(), objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.setArea(SerialUtilities.readShape(objectInputStream));
    }
}

