/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.encoders;

import com.keypoint.PngEncoder;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import org.jfree.chart.encoders.ImageEncoder;
import org.jfree.chart.util.ParamChecks;

public class KeypointPNGEncoderAdapter
implements ImageEncoder {
    private int quality = 9;
    private boolean encodingAlpha = false;

    @Override
    public float getQuality() {
        return this.quality;
    }

    @Override
    public void setQuality(float f2) {
        this.quality = (int)f2;
    }

    @Override
    public boolean isEncodingAlpha() {
        return this.encodingAlpha;
    }

    @Override
    public void setEncodingAlpha(boolean bl2) {
        this.encodingAlpha = bl2;
    }

    @Override
    public byte[] encode(BufferedImage bufferedImage) {
        ParamChecks.nullNotPermitted(bufferedImage, "bufferedImage");
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, this.encodingAlpha, 0, this.quality);
        return pngEncoder.pngEncode();
    }

    @Override
    public void encode(BufferedImage bufferedImage, OutputStream outputStream) {
        ParamChecks.nullNotPermitted(bufferedImage, "bufferedImage");
        ParamChecks.nullNotPermitted(outputStream, "outputStream");
        PngEncoder pngEncoder = new PngEncoder(bufferedImage, this.encodingAlpha, 0, this.quality);
        outputStream.write(pngEncoder.pngEncode());
    }
}

