/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.encoders;

import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.encoders.ImageEncoder;

public class ImageEncoderFactory {
    private static Map encoders = null;

    private static void init() {
        encoders = new HashMap();
        encoders.put("jpeg", "org.jfree.chart.encoders.SunJPEGEncoderAdapter");
        encoders.put("png", "org.jfree.chart.encoders.SunPNGEncoderAdapter");
    }

    public static void setImageEncoder(String string, String string2) {
        encoders.put(string, string2);
    }

    public static ImageEncoder newInstance(String string) {
        ImageEncoder imageEncoder = null;
        String string2 = (String)encoders.get(string);
        if (string2 == null) {
            throw new IllegalArgumentException("Unsupported image format - " + string);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            imageEncoder = (ImageEncoder)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.toString());
        }
        return imageEncoder;
    }

    public static ImageEncoder newInstance(String string, float f2) {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(string);
        imageEncoder.setQuality(f2);
        return imageEncoder;
    }

    public static ImageEncoder newInstance(String string, boolean bl2) {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(string);
        imageEncoder.setEncodingAlpha(bl2);
        return imageEncoder;
    }

    public static ImageEncoder newInstance(String string, float f2, boolean bl2) {
        ImageEncoder imageEncoder = ImageEncoderFactory.newInstance(string);
        imageEncoder.setQuality(f2);
        imageEncoder.setEncodingAlpha(bl2);
        return imageEncoder;
    }

    static {
        ImageEncoderFactory.init();
    }
}

