/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.editor.DefaultPlotEditor;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.layout.LCBLayout;

public class DefaultPolarPlotEditor
extends DefaultPlotEditor
implements FocusListener {
    private JTextField manualTickUnit;
    private JTextField angleOffset;
    private double manualTickUnitValue;
    private double angleOffsetValue;

    public DefaultPolarPlotEditor(PolarPlot polarPlot) {
        super(polarPlot);
        this.angleOffsetValue = polarPlot.getAngleOffset();
        this.angleOffset.setText(Double.toString(this.angleOffsetValue));
        this.manualTickUnitValue = polarPlot.getAngleTickUnit().getSize();
        this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
    }

    @Override
    protected JTabbedPane createPlotTabs(Plot plot) {
        JTabbedPane jTabbedPane = super.createPlotTabs(plot);
        jTabbedPane.insertTab(localizationResources.getString("General1"), null, this.createPlotPanel(), null, 0);
        jTabbedPane.setSelectedIndex(0);
        return jTabbedPane;
    }

    private JPanel createPlotPanel() {
        JPanel jPanel = new JPanel(new LCBLayout(3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JLabel(localizationResources.getString("AngleOffset")));
        this.angleOffset = new JTextField(Double.toString(this.angleOffsetValue));
        this.angleOffset.setActionCommand("AngleOffsetValue");
        this.angleOffset.addActionListener(this);
        this.angleOffset.addFocusListener(this);
        jPanel.add(this.angleOffset);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel(localizationResources.getString("Manual_TickUnit_value")));
        this.manualTickUnit = new JTextField(Double.toString(this.manualTickUnitValue));
        this.manualTickUnit.setActionCommand("TickUnitValue");
        this.manualTickUnit.addActionListener(this);
        this.manualTickUnit.addFocusListener(this);
        jPanel.add(this.manualTickUnit);
        jPanel.add(new JPanel());
        return jPanel;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.angleOffset) {
            this.validateAngleOffset();
        } else if (focusEvent.getSource() == this.manualTickUnit) {
            this.validateTickUnit();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("AngleOffsetValue")) {
            this.validateAngleOffset();
        } else if (string.equals("TickUnitValue")) {
            this.validateTickUnit();
        }
    }

    public void validateAngleOffset() {
        double d2;
        try {
            d2 = Double.parseDouble(this.angleOffset.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d2 = this.angleOffsetValue;
        }
        this.angleOffsetValue = d2;
        this.angleOffset.setText(Double.toString(this.angleOffsetValue));
    }

    public void validateTickUnit() {
        double d2;
        try {
            d2 = Double.parseDouble(this.manualTickUnit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d2 = this.manualTickUnitValue;
        }
        if (d2 > 0.0 && d2 < 360.0) {
            this.manualTickUnitValue = d2;
        }
        this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
    }

    @Override
    public void updatePlotProperties(Plot plot) {
        super.updatePlotProperties(plot);
        PolarPlot polarPlot = (PolarPlot)plot;
        polarPlot.setAngleTickUnit(new NumberTickUnit(this.manualTickUnitValue));
        polarPlot.setAngleOffset(this.angleOffsetValue);
    }
}

