/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.editor.DefaultValueAxisEditor;
import org.jfree.layout.LCBLayout;

class DefaultNumberAxisEditor
extends DefaultValueAxisEditor
implements FocusListener {
    private double manualTickUnitValue;
    private JTextField manualTickUnit;

    public DefaultNumberAxisEditor(NumberAxis numberAxis) {
        super(numberAxis);
        this.manualTickUnitValue = numberAxis.getTickUnit().getSize();
        this.validateTickUnit();
    }

    @Override
    protected JPanel createTickUnitPanel() {
        JPanel jPanel = new JPanel(new LCBLayout(3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JPanel());
        JCheckBox jCheckBox = new JCheckBox(localizationResources.getString("Auto-TickUnit_Selection"), this.isAutoTickUnitSelection());
        jCheckBox.setActionCommand("AutoTickOnOff");
        jCheckBox.addActionListener(this);
        this.setAutoTickUnitSelectionCheckBox(jCheckBox);
        jPanel.add(this.getAutoTickUnitSelectionCheckBox());
        jPanel.add(new JPanel());
        jPanel.add(new JLabel(localizationResources.getString("Manual_TickUnit_value")));
        this.manualTickUnit = new JTextField(Double.toString(this.manualTickUnitValue));
        this.manualTickUnit.setEnabled(!this.isAutoTickUnitSelection());
        this.manualTickUnit.setActionCommand("TickUnitValue");
        this.manualTickUnit.addActionListener(this);
        this.manualTickUnit.addFocusListener(this);
        jPanel.add(this.manualTickUnit);
        jPanel.add(new JPanel());
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("TickUnitValue")) {
            this.validateTickUnit();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (focusEvent.getSource() == this.manualTickUnit) {
            this.validateTickUnit();
        }
    }

    @Override
    public void toggleAutoTick() {
        super.toggleAutoTick();
        if (this.isAutoTickUnitSelection()) {
            this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
            this.manualTickUnit.setEnabled(false);
        } else {
            this.manualTickUnit.setEnabled(true);
        }
    }

    public void validateTickUnit() {
        double d2;
        try {
            d2 = Double.parseDouble(this.manualTickUnit.getText());
        }
        catch (NumberFormatException numberFormatException) {
            d2 = this.manualTickUnitValue;
        }
        if (d2 > 0.0) {
            this.manualTickUnitValue = d2;
        }
        this.manualTickUnit.setText(Double.toString(this.manualTickUnitValue));
    }

    @Override
    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        NumberAxis numberAxis = (NumberAxis)axis;
        if (!this.isAutoTickUnitSelection()) {
            numberAxis.setTickUnit(new NumberTickUnit(this.manualTickUnitValue));
        }
    }
}

