/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.Size2D;

public class GridArrangement
implements Serializable,
Arrangement {
    private static final long serialVersionUID = -2563758090144655938L;
    private int rows;
    private int columns;

    public GridArrangement(int n2, int n3) {
        this.rows = n2;
        this.columns = n3;
    }

    @Override
    public void add(Block block, Object object) {
    }

    @Override
    public Size2D arrange(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        LengthConstraintType lengthConstraintType = rectangleConstraint.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeNN(blockContainer, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeNF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeNR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeFN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeFR(blockContainer, graphics2D, rectangleConstraint);
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeRN(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeRF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeRR(blockContainer, graphics2D, rectangleConstraint);
            }
        }
        throw new RuntimeException("Should never get to here!");
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        double d2 = 0.0;
        double d3 = 0.0;
        List list = blockContainer.getBlocks();
        for (Block block : list) {
            if (block == null) continue;
            Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
            d2 = Math.max(d2, size2D.width);
            d3 = Math.max(d3, size2D.height);
        }
        double d4 = (double)this.columns * d2;
        double d5 = (double)this.rows * d3;
        RectangleConstraint rectangleConstraint = new RectangleConstraint(d4, d5);
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d2 = rectangleConstraint.getWidth() / (double)this.columns;
        double d3 = rectangleConstraint.getHeight() / (double)this.rows;
        List list = blockContainer.getBlocks();
        for (int i2 = 0; i2 < this.columns; ++i2) {
            int n2;
            for (int i3 = 0; i3 < this.rows && (n2 = i3 * this.columns + i2) < list.size(); ++i3) {
                Block block = (Block)list.get(n2);
                if (block == null) continue;
                block.setBounds(new Rectangle2D.Double((double)i2 * d2, (double)i3 * d3, d2, d3));
            }
        }
        return new Size2D((double)this.columns * d2, (double)this.rows * d3);
    }

    protected Size2D arrangeFR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedHeight();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            return size2D;
        }
        double d2 = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d2);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeRF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedWidth();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getWidthRange().contains(size2D.getWidth())) {
            return size2D;
        }
        double d2 = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedWidth(d2);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeRN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedWidth();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getWidthRange().contains(size2D.getWidth())) {
            return size2D;
        }
        double d2 = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedWidth(d2);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeNR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toUnconstrainedHeight();
        Size2D size2D = this.arrange(blockContainer, graphics2D, rectangleConstraint2);
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            return size2D;
        }
        double d2 = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d2);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeRR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrange(blockContainer, graphics2D, RectangleConstraint.NONE);
        if (rectangleConstraint.getWidthRange().contains(size2D.getWidth())) {
            if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
                return size2D;
            }
            double d2 = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
            RectangleConstraint rectangleConstraint2 = new RectangleConstraint(size2D.getWidth(), d2);
            return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint2);
        }
        if (rectangleConstraint.getHeightRange().contains(size2D.getHeight())) {
            double d3 = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
            RectangleConstraint rectangleConstraint3 = new RectangleConstraint(d3, size2D.getHeight());
            return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint3);
        }
        double d4 = rectangleConstraint.getWidthRange().constrain(size2D.getWidth());
        double d5 = rectangleConstraint.getHeightRange().constrain(size2D.getHeight());
        RectangleConstraint rectangleConstraint4 = new RectangleConstraint(d4, d5);
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint4);
    }

    protected Size2D arrangeFN(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d2 = rectangleConstraint.getWidth() / (double)this.columns;
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(d2);
        List list = blockContainer.getBlocks();
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int n2;
            for (int i3 = 0; i3 < this.columns && (n2 = i2 * this.columns + i3) < list.size(); ++i3) {
                Block block = (Block)list.get(n2);
                if (block == null) continue;
                Size2D size2D = block.arrange(graphics2D, rectangleConstraint2);
                d3 = Math.max(d3, size2D.getHeight());
            }
        }
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedHeight(d3 * (double)this.rows);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    protected Size2D arrangeNF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        double d2 = rectangleConstraint.getHeight() / (double)this.rows;
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedHeight(d2);
        List list = blockContainer.getBlocks();
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int n2;
            for (int i3 = 0; i3 < this.columns && (n2 = i2 * this.columns + i3) < list.size(); ++i3) {
                Block block = (Block)list.get(n2);
                if (block == null) continue;
                Size2D size2D = block.arrange(graphics2D, rectangleConstraint2);
                d3 = Math.max(d3, size2D.getWidth());
            }
        }
        RectangleConstraint rectangleConstraint3 = rectangleConstraint.toFixedWidth(d3 * (double)this.columns);
        return this.arrange(blockContainer, graphics2D, rectangleConstraint3);
    }

    @Override
    public void clear() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GridArrangement)) {
            return false;
        }
        GridArrangement gridArrangement = (GridArrangement)object;
        if (this.columns != gridArrangement.columns) {
            return false;
        }
        return this.rows == gridArrangement.rows;
    }
}

