/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.block.Arrangement;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.BlockContainer;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.Size2D;
import org.jfree.ui.VerticalAlignment;

public class ColumnArrangement
implements Serializable,
Arrangement {
    private static final long serialVersionUID = -5315388482898581555L;
    private HorizontalAlignment horizontalAlignment;
    private VerticalAlignment verticalAlignment;
    private double horizontalGap;
    private double verticalGap;

    public ColumnArrangement() {
    }

    public ColumnArrangement(HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, double d2, double d3) {
        this.horizontalAlignment = horizontalAlignment;
        this.verticalAlignment = verticalAlignment;
        this.horizontalGap = d2;
        this.verticalGap = d3;
    }

    @Override
    public void add(Block block, Object object) {
    }

    @Override
    public Size2D arrange(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        LengthConstraintType lengthConstraintType = rectangleConstraint.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint.getHeightConstraintType();
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                return this.arrangeNN(blockContainer, graphics2D);
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                return this.arrangeRF(blockContainer, graphics2D, rectangleConstraint);
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                return this.arrangeRR(blockContainer, graphics2D, rectangleConstraint);
            }
        }
        return new Size2D();
    }

    protected Size2D arrangeFF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        return this.arrangeNF(blockContainer, graphics2D, rectangleConstraint);
    }

    protected Size2D arrangeNF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        List list = blockContainer.getBlocks();
        double d2 = rectangleConstraint.getHeight();
        if (d2 <= 0.0) {
            d2 = Double.POSITIVE_INFINITY;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        ArrayList<Block> arrayList = new ArrayList<Block>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Block block = (Block)list.get(i2);
            Size2D size2D = block.arrange(graphics2D, RectangleConstraint.NONE);
            if (d4 + size2D.height <= d2) {
                arrayList.add(block);
                block.setBounds(new Rectangle2D.Double(d3, d4, size2D.width, size2D.height));
                d4 = d4 + size2D.height + this.verticalGap;
                d5 = Math.max(d5, size2D.width);
                continue;
            }
            if (arrayList.isEmpty()) {
                block.setBounds(new Rectangle2D.Double(d3, d4, size2D.width, Math.min(size2D.height, d2 - d4)));
                d4 = 0.0;
                d3 = d3 + size2D.width + this.horizontalGap;
                continue;
            }
            arrayList.clear();
            d3 = d3 + d5 + this.horizontalGap;
            d4 = 0.0;
            d5 = size2D.width;
            block.setBounds(new Rectangle2D.Double(d3, d4, size2D.width, Math.min(size2D.height, d2)));
            d4 = size2D.height + this.verticalGap;
            arrayList.add(block);
        }
        return new Size2D(d3 + d5, rectangleConstraint.getHeight());
    }

    protected Size2D arrangeRR(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeNN(blockContainer, graphics2D);
        if (rectangleConstraint.getHeightRange().contains(size2D.height)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedHeight(rectangleConstraint.getHeightRange().getUpperBound());
        return this.arrangeRF(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeRF(BlockContainer blockContainer, Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = this.arrangeNF(blockContainer, graphics2D, rectangleConstraint);
        if (rectangleConstraint.getWidthRange().contains(size2D.width)) {
            return size2D;
        }
        RectangleConstraint rectangleConstraint2 = rectangleConstraint.toFixedWidth(rectangleConstraint.getWidthRange().constrain(size2D.getWidth()));
        return this.arrangeFF(blockContainer, graphics2D, rectangleConstraint2);
    }

    protected Size2D arrangeNN(BlockContainer blockContainer, Graphics2D graphics2D) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        List list = blockContainer.getBlocks();
        int n2 = list.size();
        if (n2 > 0) {
            int n3;
            Size2D[] size2DArray = new Size2D[list.size()];
            for (n3 = 0; n3 < list.size(); ++n3) {
                Block block = (Block)list.get(n3);
                size2DArray[n3] = block.arrange(graphics2D, RectangleConstraint.NONE);
                d3 += size2DArray[n3].getHeight();
                d4 = Math.max(size2DArray[n3].width, d4);
                block.setBounds(new Rectangle2D.Double(0.0, d2, size2DArray[n3].width, size2DArray[n3].height));
                d2 = d2 + size2DArray[n3].height + this.verticalGap;
            }
            if (n2 > 1) {
                d3 += this.verticalGap * (double)(n2 - 1);
            }
            if (this.horizontalAlignment != HorizontalAlignment.LEFT) {
                for (n3 = 0; n3 < list.size(); ++n3) {
                    if (this.horizontalAlignment != HorizontalAlignment.CENTER && this.horizontalAlignment != HorizontalAlignment.RIGHT) continue;
                }
            }
        }
        return new Size2D(d4, d3);
    }

    @Override
    public void clear() {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColumnArrangement)) {
            return false;
        }
        ColumnArrangement columnArrangement = (ColumnArrangement)object;
        if (this.horizontalAlignment != columnArrangement.horizontalAlignment) {
            return false;
        }
        if (this.verticalAlignment != columnArrangement.verticalAlignment) {
            return false;
        }
        if (this.horizontalGap != columnArrangement.horizontalGap) {
            return false;
        }
        return this.verticalGap == columnArrangement.verticalGap;
    }
}

