/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.block;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.block.AbstractBlock;
import org.jfree.chart.block.Block;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.Size2D;
import org.jfree.util.PaintUtilities;

public class ColorBlock
extends AbstractBlock
implements Block {
    static final long serialVersionUID = 3383866145634010865L;
    private transient Paint paint;

    public ColorBlock(Paint paint, double d2, double d3) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.setWidth(d2);
        this.setHeight(d3);
    }

    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        return new Size2D(this.calculateTotalWidth(this.getWidth()), this.calculateTotalHeight(this.getHeight()));
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        rectangle2D = this.trimBorder(rectangle2D);
        rectangle2D = this.trimPadding(rectangle2D);
        graphics2D.setPaint(this.paint);
        graphics2D.fill(rectangle2D);
    }

    @Override
    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        this.draw(graphics2D, rectangle2D);
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ColorBlock)) {
            return false;
        }
        ColorBlock colorBlock = (ColorBlock)object;
        if (!PaintUtilities.equal(this.paint, colorBlock.paint)) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
    }
}

