/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.LogTick;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueTick;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public abstract class ValueAxis
extends Axis
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 3698345477322391456L;
    public static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    public static final boolean DEFAULT_AUTO_RANGE = true;
    public static final boolean DEFAULT_INVERTED = false;
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE = 1.0E-8;
    public static final double DEFAULT_LOWER_MARGIN = 0.05;
    public static final double DEFAULT_UPPER_MARGIN = 0.05;
    public static final double DEFAULT_LOWER_BOUND = 0.0;
    public static final double DEFAULT_UPPER_BOUND = 1.0;
    public static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;
    public static final int MAXIMUM_TICK_COUNT = 500;
    private boolean positiveArrowVisible = false;
    private boolean negativeArrowVisible = false;
    private transient Shape upArrow;
    private transient Shape downArrow;
    private transient Shape leftArrow;
    private transient Shape rightArrow;
    private boolean inverted = false;
    private Range range = DEFAULT_RANGE;
    private boolean autoRange = true;
    private double autoRangeMinimumSize = 1.0E-8;
    private Range defaultAutoRange = DEFAULT_RANGE;
    private double upperMargin = 0.05;
    private double lowerMargin = 0.05;
    private double fixedAutoRange = 0.0;
    private boolean autoTickUnitSelection = true;
    private TickUnitSource standardTickUnits;
    private int autoTickIndex;
    private int minorTickCount;
    private boolean verticalTickLabels;

    protected ValueAxis(String string, TickUnitSource tickUnitSource) {
        super(string);
        this.standardTickUnits = tickUnitSource;
        Polygon polygon = new Polygon();
        polygon.addPoint(0, 0);
        polygon.addPoint(-2, 2);
        polygon.addPoint(2, 2);
        this.upArrow = polygon;
        Polygon polygon2 = new Polygon();
        polygon2.addPoint(0, 0);
        polygon2.addPoint(-2, -2);
        polygon2.addPoint(2, -2);
        this.downArrow = polygon2;
        Polygon polygon3 = new Polygon();
        polygon3.addPoint(0, 0);
        polygon3.addPoint(-2, -2);
        polygon3.addPoint(-2, 2);
        this.rightArrow = polygon3;
        Polygon polygon4 = new Polygon();
        polygon4.addPoint(0, 0);
        polygon4.addPoint(2, -2);
        polygon4.addPoint(2, 2);
        this.leftArrow = polygon4;
        this.verticalTickLabels = false;
        this.minorTickCount = 0;
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl2) {
        if (this.verticalTickLabels != bl2) {
            this.verticalTickLabels = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isPositiveArrowVisible() {
        return this.positiveArrowVisible;
    }

    public void setPositiveArrowVisible(boolean bl2) {
        this.positiveArrowVisible = bl2;
        this.fireChangeEvent();
    }

    public boolean isNegativeArrowVisible() {
        return this.negativeArrowVisible;
    }

    public void setNegativeArrowVisible(boolean bl2) {
        this.negativeArrowVisible = bl2;
        this.fireChangeEvent();
    }

    public Shape getUpArrow() {
        return this.upArrow;
    }

    public void setUpArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.upArrow = shape;
        this.fireChangeEvent();
    }

    public Shape getDownArrow() {
        return this.downArrow;
    }

    public void setDownArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.downArrow = shape;
        this.fireChangeEvent();
    }

    public Shape getLeftArrow() {
        return this.leftArrow;
    }

    public void setLeftArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.leftArrow = shape;
        this.fireChangeEvent();
    }

    public Shape getRightArrow() {
        return this.rightArrow;
    }

    public void setRightArrow(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "arrow");
        this.rightArrow = shape;
        this.fireChangeEvent();
    }

    @Override
    protected void drawAxisLine(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Shape shape;
        AffineTransform affineTransform;
        Shape shape2;
        double d3;
        double d4;
        Line2D.Double double_ = null;
        double d5 = d2;
        if (rectangleEdge == RectangleEdge.TOP) {
            double_ = new Line2D.Double(rectangle2D.getX(), d5, rectangle2D.getMaxX(), d5);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            double_ = new Line2D.Double(rectangle2D.getX(), d5, rectangle2D.getMaxX(), d5);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double_ = new Line2D.Double(d5, rectangle2D.getY(), d5, rectangle2D.getMaxY());
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double_ = new Line2D.Double(d5, rectangle2D.getY(), d5, rectangle2D.getMaxY());
        }
        graphics2D.setPaint(this.getAxisLinePaint());
        graphics2D.setStroke(this.getAxisLineStroke());
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.draw(double_);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.positiveArrowVisible) {
            if (this.inverted) {
                bl3 = true;
            } else {
                bl2 = true;
            }
        }
        if (this.negativeArrowVisible) {
            if (this.inverted) {
                bl2 = true;
            } else {
                bl3 = true;
            }
        }
        if (bl2) {
            d4 = 0.0;
            d3 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d4 = rectangle2D.getMaxX();
                d3 = d2;
                shape2 = this.rightArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d4 = d2;
                d3 = rectangle2D.getMinY();
                shape2 = this.upArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d4, d3);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
        if (bl3) {
            d4 = 0.0;
            d3 = 0.0;
            shape2 = null;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                d4 = rectangle2D.getMinX();
                d3 = d2;
                shape2 = this.leftArrow;
            } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d4 = d2;
                d3 = rectangle2D.getMaxY();
                shape2 = this.downArrow;
            }
            affineTransform = new AffineTransform();
            affineTransform.setToTranslation(d4, d3);
            shape = affineTransform.createTransformedShape(shape2);
            graphics2D.fill(shape);
            graphics2D.draw(shape);
        }
    }

    protected float[] calculateAnchorPoint(ValueTick valueTick, double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        float[] fArray = new float[2];
        if (rectangleEdge == RectangleEdge.TOP) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d2 - rectangleInsets.getBottom() - 2.0);
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            fArray[0] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
            fArray[1] = (float)(d2 + rectangleInsets.getTop() + 2.0);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            fArray[0] = (float)(d2 - rectangleInsets.getLeft() - 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            fArray[0] = (float)(d2 + rectangleInsets.getRight() + 2.0);
            fArray[1] = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D, rectangleEdge);
        }
        return fArray;
    }

    protected AxisState drawTickMarksAndLabels(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        AxisState axisState = new AxisState(d2);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d2, rectangle2D2, rectangleEdge);
        }
        List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        axisState.setTicks(list);
        graphics2D.setFont(this.getTickLabelFont());
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (ValueTick valueTick : list) {
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                float[] fArray = this.calculateAnchorPoint(valueTick, d2, rectangle2D2, rectangleEdge);
                if (valueTick instanceof LogTick) {
                    LogTick logTick = (LogTick)valueTick;
                    if (logTick.getAttributedLabel() == null) continue;
                    AttrStringUtils.drawRotatedString(logTick.getAttributedLabel(), graphics2D, fArray[0], fArray[1], valueTick.getTextAnchor(), valueTick.getAngle(), valueTick.getRotationAnchor());
                } else {
                    if (valueTick.getText() == null) continue;
                    TextUtilities.drawRotatedString(valueTick.getText(), graphics2D, fArray[0], fArray[1], valueTick.getTextAnchor(), valueTick.getAngle(), valueTick.getRotationAnchor());
                }
            }
            if ((!this.isTickMarksVisible() || !valueTick.getTickType().equals(TickType.MAJOR)) && (!this.isMinorTickMarksVisible() || !valueTick.getTickType().equals(TickType.MINOR))) continue;
            double d3 = valueTick.getTickType().equals(TickType.MINOR) ? (double)this.getMinorTickMarkOutsideLength() : (double)this.getTickMarkOutsideLength();
            double d4 = valueTick.getTickType().equals(TickType.MINOR) ? (double)this.getMinorTickMarkInsideLength() : (double)this.getTickMarkInsideLength();
            float f2 = (float)this.valueToJava2D(valueTick.getValue(), rectangle2D2, rectangleEdge);
            Line2D.Double double_ = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_ = new Line2D.Double(d2 - d3, f2, d2 + d4, f2);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_ = new Line2D.Double(d2 + d3, f2, d2 - d4, f2);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(f2, d2 - d3, f2, d2 + d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(f2, d2 + d3, f2, d2 - d4);
            }
            graphics2D.draw(double_);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
        double d5 = 0.0;
        if (this.isTickLabelsVisible()) {
            if (rectangleEdge == RectangleEdge.LEFT) {
                axisState.cursorLeft(d5 += this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels()));
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d5 = this.findMaximumTickLabelWidth(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorRight(d5);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d5 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorUp(d5);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d5 = this.findMaximumTickLabelHeight(list, graphics2D, rectangle2D, this.isVerticalTickLabels());
                axisState.cursorDown(d5);
            }
        }
        return axisState;
    }

    @Override
    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        Object object;
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d2 = this.getFixedDimension();
        if (d2 > 0.0) {
            axisSpace.add(d2, rectangleEdge);
            return axisSpace;
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            object = this.refreshTicks(graphics2D, new AxisState(), rectangle2D, rectangleEdge);
            if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                d3 = this.findMaximumTickLabelHeight((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
                d4 = this.findMaximumTickLabelWidth((List)object, graphics2D, rectangle2D, this.isVerticalTickLabels());
            }
        }
        object = this.getLabelEnclosure(graphics2D, rectangleEdge);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d5 = ((RectangularShape)object).getHeight();
            axisSpace.add(d5 + d3, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d6 = ((RectangularShape)object).getWidth();
            axisSpace.add(d6 + d4, rectangleEdge);
        }
        return axisSpace;
    }

    protected double findMaximumTickLabelHeight(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl2) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d2 = 0.0;
        if (bl2) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            for (Tick tick : list) {
                RectangularShape rectangularShape = null;
                if (tick instanceof LogTick) {
                    LogTick logTick = (LogTick)tick;
                    if (logTick.getAttributedLabel() != null) {
                        rectangularShape = AttrStringUtils.getTextBounds(logTick.getAttributedLabel(), graphics2D);
                    }
                } else if (tick.getText() != null) {
                    rectangularShape = TextUtilities.getTextBounds(tick.getText(), graphics2D, fontMetrics);
                }
                if (rectangularShape == null || !(rectangularShape.getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom() > d2)) continue;
                d2 = rectangularShape.getWidth() + rectangleInsets.getTop() + rectangleInsets.getBottom();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d2 = (double)lineMetrics.getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        }
        return d2;
    }

    protected double findMaximumTickLabelWidth(List list, Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl2) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        Font font = this.getTickLabelFont();
        double d2 = 0.0;
        if (!bl2) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            for (Tick tick : list) {
                RectangularShape rectangularShape = null;
                if (tick instanceof LogTick) {
                    LogTick logTick = (LogTick)tick;
                    if (logTick.getAttributedLabel() != null) {
                        rectangularShape = AttrStringUtils.getTextBounds(logTick.getAttributedLabel(), graphics2D);
                    }
                } else if (tick.getText() != null) {
                    rectangularShape = TextUtilities.getTextBounds(tick.getText(), graphics2D, fontMetrics);
                }
                if (rectangularShape == null || !(rectangularShape.getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight() > d2)) continue;
                d2 = rectangularShape.getWidth() + rectangleInsets.getLeft() + rectangleInsets.getRight();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", graphics2D.getFontRenderContext());
            d2 = (double)lineMetrics.getHeight() + rectangleInsets.getTop() + rectangleInsets.getBottom();
        }
        return d2;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean bl2) {
        if (this.inverted != bl2) {
            this.inverted = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean bl2) {
        this.setAutoRange(bl2, true);
    }

    protected void setAutoRange(boolean bl2, boolean bl3) {
        if (this.autoRange != bl2) {
            this.autoRange = bl2;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl3) {
                this.fireChangeEvent();
            }
        }
    }

    public double getAutoRangeMinimumSize() {
        return this.autoRangeMinimumSize;
    }

    public void setAutoRangeMinimumSize(double d2) {
        this.setAutoRangeMinimumSize(d2, true);
    }

    public void setAutoRangeMinimumSize(double d2, boolean bl2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("NumberAxis.setAutoRangeMinimumSize(double): must be > 0.0.");
        }
        if (this.autoRangeMinimumSize != d2) {
            this.autoRangeMinimumSize = d2;
            if (this.autoRange) {
                this.autoAdjustRange();
            }
            if (bl2) {
                this.fireChangeEvent();
            }
        }
    }

    public Range getDefaultAutoRange() {
        return this.defaultAutoRange;
    }

    public void setDefaultAutoRange(Range range) {
        ParamChecks.nullNotPermitted(range, "range");
        this.defaultAutoRange = range;
        this.fireChangeEvent();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double d2) {
        this.lowerMargin = d2;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.fireChangeEvent();
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double d2) {
        this.upperMargin = d2;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.fireChangeEvent();
    }

    public double getFixedAutoRange() {
        return this.fixedAutoRange;
    }

    public void setFixedAutoRange(double d2) {
        this.fixedAutoRange = d2;
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
        this.fireChangeEvent();
    }

    public double getLowerBound() {
        return this.range.getLowerBound();
    }

    public void setLowerBound(double d2) {
        if (this.range.getUpperBound() > d2) {
            this.setRange(new Range(d2, this.range.getUpperBound()));
        } else {
            this.setRange(new Range(d2, d2 + 1.0));
        }
    }

    public double getUpperBound() {
        return this.range.getUpperBound();
    }

    public void setUpperBound(double d2) {
        if (this.range.getLowerBound() < d2) {
            this.setRange(new Range(this.range.getLowerBound(), d2));
        } else {
            this.setRange(d2 - 1.0, d2);
        }
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    public void setRange(Range range, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(range, "range");
        if (range.getLength() <= 0.0) {
            throw new IllegalArgumentException("A positive range length is required: " + range);
        }
        if (bl2) {
            this.autoRange = false;
        }
        this.range = range;
        if (bl3) {
            this.fireChangeEvent();
        }
    }

    public void setRange(double d2, double d3) {
        this.setRange(new Range(d2, d3));
    }

    public void setRangeWithMargins(Range range) {
        this.setRangeWithMargins(range, true, true);
    }

    public void setRangeWithMargins(Range range, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(range, "range");
        this.setRange(Range.expand(range, this.getLowerMargin(), this.getUpperMargin()), bl2, bl3);
    }

    public void setRangeWithMargins(double d2, double d3) {
        this.setRangeWithMargins(new Range(d2, d3));
    }

    public void setRangeAboutValue(double d2, double d3) {
        this.setRange(new Range(d2 - d3 / 2.0, d2 + d3 / 2.0));
    }

    public boolean isAutoTickUnitSelection() {
        return this.autoTickUnitSelection;
    }

    public void setAutoTickUnitSelection(boolean bl2) {
        this.setAutoTickUnitSelection(bl2, true);
    }

    public void setAutoTickUnitSelection(boolean bl2, boolean bl3) {
        if (this.autoTickUnitSelection != bl2) {
            this.autoTickUnitSelection = bl2;
            if (bl3) {
                this.fireChangeEvent();
            }
        }
    }

    public TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public void setStandardTickUnits(TickUnitSource tickUnitSource) {
        this.standardTickUnits = tickUnitSource;
        this.fireChangeEvent();
    }

    public int getMinorTickCount() {
        return this.minorTickCount;
    }

    public void setMinorTickCount(int n2) {
        this.minorTickCount = n2;
        this.fireChangeEvent();
    }

    public abstract double valueToJava2D(double var1, Rectangle2D var3, RectangleEdge var4);

    public double lengthToJava2D(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d3 = this.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d4 = this.valueToJava2D(d2, rectangle2D, rectangleEdge);
        return Math.abs(d4 - d3);
    }

    public abstract double java2DToValue(double var1, Rectangle2D var3, RectangleEdge var4);

    protected abstract void autoAdjustRange();

    public void centerRange(double d2) {
        double d3 = this.range.getCentralValue();
        Range range = new Range(this.range.getLowerBound() + d2 - d3, this.range.getUpperBound() + d2 - d3);
        this.setRange(range);
    }

    public void resizeRange(double d2) {
        this.resizeRange(d2, this.range.getCentralValue());
    }

    public void resizeRange(double d2, double d3) {
        if (d2 > 0.0) {
            double d4 = this.range.getLength() * d2 / 2.0;
            Range range = new Range(d3 - d4, d3 + d4);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void resizeRange2(double d2, double d3) {
        if (d2 > 0.0) {
            double d4 = d3 - this.getLowerBound();
            double d5 = this.getUpperBound() - d3;
            Range range = new Range(d3 - d4 * d2, d3 + d5 * d2);
            this.setRange(range);
        } else {
            this.setAutoRange(true);
        }
    }

    public void zoomRange(double d2, double d3) {
        double d4;
        double d5;
        double d6 = this.range.getLowerBound();
        double d7 = this.range.getLength();
        if (this.isInverted()) {
            d5 = d6 + d7 * (1.0 - d3);
            d4 = d6 + d7 * (1.0 - d2);
        } else {
            d5 = d6 + d7 * d2;
            d4 = d6 + d7 * d3;
        }
        if (d4 > d5 && !Double.isInfinite(d4 - d5)) {
            this.setRange(new Range(d5, d4));
        }
    }

    public void pan(double d2) {
        Range range = this.getRange();
        double d3 = this.range.getLength();
        double d4 = d3 * d2;
        double d5 = range.getLowerBound() + d4;
        double d6 = range.getUpperBound() + d4;
        this.setRange(d5, d6);
    }

    protected int getAutoTickIndex() {
        return this.autoTickIndex;
    }

    protected void setAutoTickIndex(int n2) {
        this.autoTickIndex = n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ValueAxis)) {
            return false;
        }
        ValueAxis valueAxis = (ValueAxis)object;
        if (this.positiveArrowVisible != valueAxis.positiveArrowVisible) {
            return false;
        }
        if (this.negativeArrowVisible != valueAxis.negativeArrowVisible) {
            return false;
        }
        if (this.inverted != valueAxis.inverted) {
            return false;
        }
        if (!this.autoRange && !ObjectUtilities.equal(this.range, valueAxis.range)) {
            return false;
        }
        if (this.autoRange != valueAxis.autoRange) {
            return false;
        }
        if (this.autoRangeMinimumSize != valueAxis.autoRangeMinimumSize) {
            return false;
        }
        if (!this.defaultAutoRange.equals(valueAxis.defaultAutoRange)) {
            return false;
        }
        if (this.upperMargin != valueAxis.upperMargin) {
            return false;
        }
        if (this.lowerMargin != valueAxis.lowerMargin) {
            return false;
        }
        if (this.fixedAutoRange != valueAxis.fixedAutoRange) {
            return false;
        }
        if (this.autoTickUnitSelection != valueAxis.autoTickUnitSelection) {
            return false;
        }
        if (!ObjectUtilities.equal(this.standardTickUnits, valueAxis.standardTickUnits)) {
            return false;
        }
        if (this.verticalTickLabels != valueAxis.verticalTickLabels) {
            return false;
        }
        if (this.minorTickCount != valueAxis.minorTickCount) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        ValueAxis valueAxis = (ValueAxis)super.clone();
        return valueAxis;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.upArrow, objectOutputStream);
        SerialUtilities.writeShape(this.downArrow, objectOutputStream);
        SerialUtilities.writeShape(this.leftArrow, objectOutputStream);
        SerialUtilities.writeShape(this.rightArrow, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.upArrow = SerialUtilities.readShape(objectInputStream);
        this.downArrow = SerialUtilities.readShape(objectInputStream);
        this.leftArrow = SerialUtilities.readShape(objectInputStream);
        this.rightArrow = SerialUtilities.readShape(objectInputStream);
    }
}

