/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public abstract class Tick
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6668230383875149773L;
    private String text;
    private TextAnchor textAnchor;
    private TextAnchor rotationAnchor;
    private double angle;

    public Tick(String string, TextAnchor textAnchor, TextAnchor textAnchor2, double d2) {
        ParamChecks.nullNotPermitted(textAnchor, "textAnchor");
        ParamChecks.nullNotPermitted(textAnchor2, "rotationAnchor");
        this.text = string;
        this.textAnchor = textAnchor;
        this.rotationAnchor = textAnchor2;
        this.angle = d2;
    }

    public String getText() {
        return this.text;
    }

    public TextAnchor getTextAnchor() {
        return this.textAnchor;
    }

    public TextAnchor getRotationAnchor() {
        return this.rotationAnchor;
    }

    public double getAngle() {
        return this.angle;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Tick) {
            Tick tick = (Tick)object;
            if (!ObjectUtilities.equal(this.text, tick.text)) {
                return false;
            }
            if (!ObjectUtilities.equal(this.textAnchor, tick.textAnchor)) {
                return false;
            }
            if (!ObjectUtilities.equal(this.rotationAnchor, tick.rotationAnchor)) {
                return false;
            }
            return this.angle == tick.angle;
        }
        return false;
    }

    public Object clone() {
        Tick tick = (Tick)super.clone();
        return tick;
    }

    public String toString() {
        return this.text;
    }
}

