/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

public class SubCategoryAxis
extends CategoryAxis
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1279463299793228344L;
    private List subCategories;
    private Font subLabelFont = new Font("SansSerif", 0, 10);
    private transient Paint subLabelPaint = Color.black;

    public SubCategoryAxis(String string) {
        super(string);
        this.subCategories = new ArrayList();
    }

    public void addSubCategory(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "subCategory");
        this.subCategories.add(comparable);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Font getSubLabelFont() {
        return this.subLabelFont;
    }

    public void setSubLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.subLabelFont = font;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getSubLabelPaint() {
        return this.subLabelPaint;
    }

    public void setSubLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.subLabelPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    @Override
    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        axisSpace = super.reserveSpace(graphics2D, plot, rectangle2D, rectangleEdge, axisSpace);
        double d2 = this.getMaxDim(graphics2D, rectangleEdge);
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            axisSpace.add(d2, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            axisSpace.add(d2, rectangleEdge);
        }
        return axisSpace;
    }

    private double getMaxDim(Graphics2D graphics2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        graphics2D.setFont(this.subLabelFont);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        for (Comparable comparable : this.subCategories) {
            String string = comparable.toString();
            Rectangle2D rectangle2D = TextUtilities.getTextBounds(string, graphics2D, fontMetrics);
            double d3 = RectangleEdge.isLeftOrRight(rectangleEdge) ? rectangle2D.getWidth() : rectangle2D.getHeight();
            d2 = Math.max(d2, d3);
        }
        return d2;
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            return new AxisState(d2);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d2, rectangle2D2, rectangleEdge);
        }
        AxisState axisState = new AxisState(d2);
        axisState = this.drawSubCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.drawCategoryLabels(graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState, plotRenderingInfo);
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected AxisState drawSubCategoryLabels(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, AxisState axisState, PlotRenderingInfo plotRenderingInfo) {
        ParamChecks.nullNotPermitted(axisState, "state");
        graphics2D.setFont(this.subLabelFont);
        graphics2D.setPaint(this.subLabelPaint);
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        int n2 = 0;
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        if (categoryDataset != null) {
            n2 = categoryDataset.getColumnCount();
        }
        double d2 = this.getMaxDim(graphics2D, rectangleEdge);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            double d6 = 0.0;
            if (rectangleEdge == RectangleEdge.TOP) {
                d3 = this.getCategoryStart(i2, n2, rectangle2D2, rectangleEdge);
                d4 = this.getCategoryEnd(i2, n2, rectangle2D2, rectangleEdge);
                d6 = axisState.getCursor();
                d5 = d6 - d2;
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                d3 = this.getCategoryStart(i2, n2, rectangle2D2, rectangleEdge);
                d4 = this.getCategoryEnd(i2, n2, rectangle2D2, rectangleEdge);
                d5 = axisState.getCursor();
                d6 = d5 + d2;
            } else if (rectangleEdge == RectangleEdge.LEFT) {
                d5 = this.getCategoryStart(i2, n2, rectangle2D2, rectangleEdge);
                d6 = this.getCategoryEnd(i2, n2, rectangle2D2, rectangleEdge);
                d4 = axisState.getCursor();
                d3 = d4 - d2;
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                d5 = this.getCategoryStart(i2, n2, rectangle2D2, rectangleEdge);
                d6 = this.getCategoryEnd(i2, n2, rectangle2D2, rectangleEdge);
                d3 = axisState.getCursor();
                d4 = d3 + d2;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d3, d5, d4 - d3, d6 - d5);
            int n3 = this.subCategories.size();
            float f2 = (float)((d4 - d3) / (double)n3);
            float f3 = (float)((d6 - d5) / (double)n3);
            for (int i3 = 0; i3 < n3; ++i3) {
                float f4;
                float f5;
                if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
                    f5 = (float)(d3 + ((double)i3 + 0.5) * (double)f2);
                    f4 = (float)double_.getCenterY();
                } else {
                    f5 = (float)double_.getCenterX();
                    f4 = (float)(d5 + ((double)i3 + 0.5) * (double)f3);
                }
                String string = this.subCategories.get(i3).toString();
                TextUtilities.drawRotatedString(string, graphics2D, f5, f4, TextAnchor.CENTER, 0.0, TextAnchor.CENTER);
            }
        }
        if (rectangleEdge.equals(RectangleEdge.TOP)) {
            double d7 = d2;
            axisState.cursorUp(d7);
        } else if (rectangleEdge.equals(RectangleEdge.BOTTOM)) {
            double d8 = d2;
            axisState.cursorDown(d8);
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            double d9 = d2;
            axisState.cursorLeft(d9);
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            double d10 = d2;
            axisState.cursorRight(d10);
        }
        return axisState;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SubCategoryAxis && super.equals(object)) {
            SubCategoryAxis subCategoryAxis = (SubCategoryAxis)object;
            if (!this.subCategories.equals(subCategoryAxis.subCategories)) {
                return false;
            }
            if (!this.subLabelFont.equals(subCategoryAxis.subLabelFont)) {
                return false;
            }
            return this.subLabelPaint.equals(subCategoryAxis.subLabelPaint);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.subLabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.subLabelPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

