/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;

public class StandardTickUnitSource
implements Serializable,
TickUnitSource {
    private static final double LOG_10_VALUE = Math.log(10.0);

    @Override
    public TickUnit getLargerTickUnit(TickUnit tickUnit) {
        double d2 = tickUnit.getSize();
        double d3 = Math.log(d2) / LOG_10_VALUE;
        double d4 = Math.ceil(d3);
        return new NumberTickUnit(Math.pow(10.0, d4), new DecimalFormat("0.0E0"));
    }

    @Override
    public TickUnit getCeilingTickUnit(TickUnit tickUnit) {
        return this.getLargerTickUnit(tickUnit);
    }

    @Override
    public TickUnit getCeilingTickUnit(double d2) {
        double d3 = Math.log(d2) / LOG_10_VALUE;
        double d4 = Math.ceil(d3);
        return new NumberTickUnit(Math.pow(10.0, d4), new DecimalFormat("0.0E0"));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof StandardTickUnitSource;
    }

    public int hashCode() {
        return 0;
    }
}

