/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.jfree.chart.axis.Timeline;

public class SegmentedTimeline
implements Serializable,
Cloneable,
Timeline {
    private static final long serialVersionUID = 1093779862539903110L;
    public static final long DAY_SEGMENT_SIZE = 86400000L;
    public static final long HOUR_SEGMENT_SIZE = 3600000L;
    public static final long FIFTEEN_MINUTE_SEGMENT_SIZE = 900000L;
    public static final long MINUTE_SEGMENT_SIZE = 60000L;
    public static long FIRST_MONDAY_AFTER_1900;
    public static TimeZone NO_DST_TIME_ZONE;
    public static TimeZone DEFAULT_TIME_ZONE;
    private Calendar workingCalendarNoDST;
    private Calendar workingCalendar = Calendar.getInstance();
    private long segmentSize;
    private int segmentsIncluded;
    private int segmentsExcluded;
    private int groupSegmentCount;
    private long startTime;
    private long segmentsIncludedSize;
    private long segmentsExcludedSize;
    private long segmentsGroupSize;
    private List exceptionSegments = new ArrayList();
    private SegmentedTimeline baseTimeline;
    private boolean adjustForDaylightSaving = false;

    public SegmentedTimeline(long l2, int n2, int n3) {
        this.segmentSize = l2;
        this.segmentsIncluded = n2;
        this.segmentsExcluded = n3;
        this.groupSegmentCount = this.segmentsIncluded + this.segmentsExcluded;
        this.segmentsIncludedSize = (long)this.segmentsIncluded * this.segmentSize;
        this.segmentsExcludedSize = (long)this.segmentsExcluded * this.segmentSize;
        this.segmentsGroupSize = this.segmentsIncludedSize + this.segmentsExcludedSize;
        int n4 = TimeZone.getDefault().getRawOffset();
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n4, "UTC-" + n4);
        this.workingCalendarNoDST = new GregorianCalendar(simpleTimeZone, Locale.getDefault());
    }

    public static long firstMondayAfter1900() {
        int n2 = TimeZone.getDefault().getRawOffset();
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n2, "UTC-" + n2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(simpleTimeZone);
        gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        while (gregorianCalendar.get(7) != 2) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        return gregorianCalendar.getTime().getTime();
    }

    public static SegmentedTimeline newMondayThroughFridayTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(86400000L, 5, 2);
        segmentedTimeline.setStartTime(SegmentedTimeline.firstMondayAfter1900());
        return segmentedTimeline;
    }

    public static SegmentedTimeline newFifteenMinuteTimeline() {
        SegmentedTimeline segmentedTimeline = new SegmentedTimeline(900000L, 28, 68);
        segmentedTimeline.setStartTime(SegmentedTimeline.firstMondayAfter1900() + 36L * segmentedTimeline.getSegmentSize());
        segmentedTimeline.setBaseTimeline(SegmentedTimeline.newMondayThroughFridayTimeline());
        return segmentedTimeline;
    }

    public boolean getAdjustForDaylightSaving() {
        return this.adjustForDaylightSaving;
    }

    public void setAdjustForDaylightSaving(boolean bl2) {
        this.adjustForDaylightSaving = bl2;
    }

    public void setStartTime(long l2) {
        this.startTime = l2;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public int getSegmentsExcluded() {
        return this.segmentsExcluded;
    }

    public long getSegmentsExcludedSize() {
        return this.segmentsExcludedSize;
    }

    public int getGroupSegmentCount() {
        return this.groupSegmentCount;
    }

    public long getSegmentsGroupSize() {
        return this.segmentsGroupSize;
    }

    public int getSegmentsIncluded() {
        return this.segmentsIncluded;
    }

    public long getSegmentsIncludedSize() {
        return this.segmentsIncludedSize;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public List getExceptionSegments() {
        return Collections.unmodifiableList(this.exceptionSegments);
    }

    public void setExceptionSegments(List list) {
        this.exceptionSegments = list;
    }

    public SegmentedTimeline getBaseTimeline() {
        return this.baseTimeline;
    }

    public void setBaseTimeline(SegmentedTimeline segmentedTimeline) {
        if (segmentedTimeline != null) {
            if (segmentedTimeline.getSegmentSize() < this.segmentSize) {
                throw new IllegalArgumentException("baseTimeline.getSegmentSize() is smaller than segmentSize");
            }
            if (segmentedTimeline.getStartTime() > this.startTime) {
                throw new IllegalArgumentException("baseTimeline.getStartTime() is after startTime");
            }
            if (segmentedTimeline.getSegmentSize() % this.segmentSize != 0L) {
                throw new IllegalArgumentException("baseTimeline.getSegmentSize() is not multiple of segmentSize");
            }
            if ((this.startTime - segmentedTimeline.getStartTime()) % this.segmentSize != 0L) {
                throw new IllegalArgumentException("baseTimeline is not aligned");
            }
        }
        this.baseTimeline = segmentedTimeline;
    }

    @Override
    public long toTimelineValue(long l2) {
        long l3;
        long l4 = l2 - this.startTime;
        long l5 = l4 % this.segmentsGroupSize;
        long l6 = l4 / this.segmentsGroupSize;
        if (l5 >= this.segmentsIncludedSize) {
            l3 = this.toTimelineValue(this.startTime + this.segmentsGroupSize * (l6 + 1L));
        } else {
            Segment segment = this.getSegment(l2);
            if (segment.inExceptionSegments()) {
                int n2;
                while ((n2 = this.binarySearchExceptionSegments(segment)) >= 0) {
                    l2 = ((Segment)this.exceptionSegments.get(n2)).getSegmentEnd() + 1L;
                    segment = this.getSegment(l2);
                }
                l3 = this.toTimelineValue(l2);
            } else {
                long l7 = l2 - this.startTime;
                long l8 = l7 % this.segmentsGroupSize;
                long l9 = l7 / this.segmentsGroupSize;
                long l10 = this.getExceptionSegmentCount(this.startTime, l2 - 1L);
                l3 = l8 < this.segmentsIncludedSize ? this.segmentsIncludedSize * l9 + l8 - l10 * this.segmentSize : this.segmentsIncludedSize * (l9 + 1L) - l10 * this.segmentSize;
            }
        }
        return l3;
    }

    @Override
    public long toTimelineValue(Date date) {
        return this.toTimelineValue(this.getTime(date));
    }

    @Override
    public long toMillisecond(long l2) {
        Segment segment = new Segment(this.startTime + l2 + l2 / this.segmentsIncludedSize * this.segmentsExcludedSize);
        for (long i2 = this.startTime; i2 <= segment.segmentStart; ++i2) {
            long l3;
            while ((l3 = this.getExceptionSegmentCount(i2, segment.millisecond / this.segmentSize * this.segmentSize - 1L)) > 0L) {
                i2 = segment.segmentStart;
                int n2 = 0;
                while ((long)n2 < l3) {
                    do {
                        segment.inc();
                    } while (segment.inExcludeSegments());
                    ++n2;
                }
            }
            i2 = segment.segmentStart;
            while (segment.inExceptionSegments() || segment.inExcludeSegments()) {
                segment.inc();
                i2 += this.segmentSize;
            }
        }
        return this.getTimeFromLong(segment.millisecond);
    }

    public long getTimeFromLong(long l2) {
        long l3 = l2;
        if (this.adjustForDaylightSaving) {
            this.workingCalendarNoDST.setTime(new Date(l2));
            this.workingCalendar.set(this.workingCalendarNoDST.get(1), this.workingCalendarNoDST.get(2), this.workingCalendarNoDST.get(5), this.workingCalendarNoDST.get(11), this.workingCalendarNoDST.get(12), this.workingCalendarNoDST.get(13));
            this.workingCalendar.set(14, this.workingCalendarNoDST.get(14));
            l3 = this.workingCalendar.getTime().getTime();
        }
        return l3;
    }

    @Override
    public boolean containsDomainValue(long l2) {
        Segment segment = this.getSegment(l2);
        return segment.inIncludeSegments();
    }

    @Override
    public boolean containsDomainValue(Date date) {
        return this.containsDomainValue(this.getTime(date));
    }

    @Override
    public boolean containsDomainRange(long l2, long l3) {
        if (l3 < l2) {
            throw new IllegalArgumentException("domainValueEnd (" + l3 + ") < domainValueStart (" + l2 + ")");
        }
        Segment segment = this.getSegment(l2);
        boolean bl2 = true;
        do {
            bl2 = segment.inIncludeSegments();
            if (segment.contains(l3)) break;
            segment.inc();
        } while (bl2);
        return bl2;
    }

    @Override
    public boolean containsDomainRange(Date date, Date date2) {
        return this.containsDomainRange(this.getTime(date), this.getTime(date2));
    }

    public void addException(long l2) {
        this.addException(new Segment(l2));
    }

    public void addException(long l2, long l3) {
        this.addException(new SegmentRange(l2, l3));
    }

    public void addException(Date date) {
        this.addException(this.getTime(date));
    }

    public void addExceptions(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addException((Date)iterator.next());
        }
    }

    private void addException(Segment segment) {
        if (segment.inIncludeSegments()) {
            int n2 = this.binarySearchExceptionSegments(segment);
            this.exceptionSegments.add(-(n2 + 1), segment);
        }
    }

    public void addBaseTimelineException(long l2) {
        Segment segment = this.baseTimeline.getSegment(l2);
        if (segment.inIncludeSegments()) {
            Segment segment2 = this.getSegment(segment.getSegmentStart());
            while (segment2.getSegmentStart() <= segment.getSegmentEnd()) {
                if (segment2.inIncludeSegments()) {
                    long l3;
                    long l4 = segment2.getSegmentStart();
                    do {
                        l3 = segment2.getSegmentEnd();
                        segment2.inc();
                    } while (segment2.inIncludeSegments());
                    this.addException(l4, l3);
                    continue;
                }
                segment2.inc();
            }
        }
    }

    public void addBaseTimelineException(Date date) {
        this.addBaseTimelineException(this.getTime(date));
    }

    public void addBaseTimelineExclusions(long l2, long l3) {
        Segment segment = this.baseTimeline.getSegment(l2);
        while (segment.getSegmentStart() <= l3 && !segment.inExcludeSegments()) {
            segment.inc();
        }
        while (segment.getSegmentStart() <= l3) {
            long l4 = segment.getSegmentStart() + (long)this.baseTimeline.getSegmentsExcluded() * this.baseTimeline.getSegmentSize() - 1L;
            Segment segment2 = this.getSegment(segment.getSegmentStart());
            while (segment2.getSegmentStart() <= l4) {
                if (segment2.inIncludeSegments()) {
                    long l5;
                    long l6 = segment2.getSegmentStart();
                    do {
                        l5 = segment2.getSegmentEnd();
                        segment2.inc();
                    } while (segment2.inIncludeSegments());
                    this.addException(new BaseTimelineSegmentRange(l6, l5));
                    continue;
                }
                segment2.inc();
            }
            segment.inc(this.baseTimeline.getGroupSegmentCount());
        }
    }

    public long getExceptionSegmentCount(long l2, long l3) {
        if (l3 < l2) {
            return 0L;
        }
        int n2 = 0;
        for (Segment segment : this.exceptionSegments) {
            Segment segment2 = segment.intersect(l2, l3);
            if (segment2 == null) continue;
            n2 = (int)((long)n2 + segment2.getSegmentCount());
        }
        return n2;
    }

    public Segment getSegment(long l2) {
        return new Segment(l2);
    }

    public Segment getSegment(Date date) {
        return this.getSegment(this.getTime(date));
    }

    private boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public boolean equals(Object object) {
        if (object instanceof SegmentedTimeline) {
            SegmentedTimeline segmentedTimeline = (SegmentedTimeline)object;
            boolean bl2 = this.segmentSize == segmentedTimeline.getSegmentSize();
            boolean bl3 = this.segmentsIncluded == segmentedTimeline.getSegmentsIncluded();
            boolean bl4 = this.segmentsExcluded == segmentedTimeline.getSegmentsExcluded();
            boolean bl5 = this.startTime == segmentedTimeline.getStartTime();
            boolean bl6 = this.equals(this.exceptionSegments, segmentedTimeline.getExceptionSegments());
            return bl2 && bl3 && bl4 && bl5 && bl6;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 19;
        n2 = 37 * n2 + (int)(this.segmentSize ^ this.segmentSize >>> 32);
        n2 = 37 * n2 + (int)(this.startTime ^ this.startTime >>> 32);
        return n2;
    }

    private int binarySearchExceptionSegments(Segment segment) {
        int n2 = 0;
        int n3 = this.exceptionSegments.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Segment segment2 = (Segment)this.exceptionSegments.get(n4);
            if (segment.contains(segment2) || segment2.contains(segment)) {
                return n4;
            }
            if (segment2.before(segment)) {
                n2 = n4 + 1;
                continue;
            }
            if (segment2.after(segment)) {
                n3 = n4 - 1;
                continue;
            }
            throw new IllegalStateException("Invalid condition.");
        }
        return -(n2 + 1);
    }

    public long getTime(Date date) {
        long l2 = date.getTime();
        if (this.adjustForDaylightSaving) {
            this.workingCalendar.setTime(date);
            this.workingCalendarNoDST.set(this.workingCalendar.get(1), this.workingCalendar.get(2), this.workingCalendar.get(5), this.workingCalendar.get(11), this.workingCalendar.get(12), this.workingCalendar.get(13));
            this.workingCalendarNoDST.set(14, this.workingCalendar.get(14));
            Date date2 = this.workingCalendarNoDST.getTime();
            l2 = date2.getTime();
        }
        return l2;
    }

    public Date getDate(long l2) {
        this.workingCalendarNoDST.setTime(new Date(l2));
        return this.workingCalendarNoDST.getTime();
    }

    public Object clone() {
        SegmentedTimeline segmentedTimeline = (SegmentedTimeline)super.clone();
        return segmentedTimeline;
    }

    static {
        DEFAULT_TIME_ZONE = TimeZone.getDefault();
        int n2 = TimeZone.getDefault().getRawOffset();
        NO_DST_TIME_ZONE = new SimpleTimeZone(n2, "UTC-" + n2);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(NO_DST_TIME_ZONE);
        gregorianCalendar.set(1900, 0, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        while (gregorianCalendar.get(7) != 2) {
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        FIRST_MONDAY_AFTER_1900 = gregorianCalendar.getTime().getTime();
    }

    protected class BaseTimelineSegmentRange
    extends SegmentRange {
        public BaseTimelineSegmentRange(long l2, long l3) {
            super(l2, l3);
        }
    }

    protected class SegmentRange
    extends Segment {
        private long segmentCount;

        public SegmentRange(long l2, long l3) {
            Segment segment = SegmentedTimeline.this.getSegment(l2);
            Segment segment2 = SegmentedTimeline.this.getSegment(l3);
            this.millisecond = l2;
            this.segmentNumber = this.calculateSegmentNumber(l2);
            this.segmentStart = segment.segmentStart;
            this.segmentEnd = segment2.segmentEnd;
            this.segmentCount = segment2.getSegmentNumber() - segment.getSegmentNumber() + 1L;
        }

        @Override
        public long getSegmentCount() {
            return this.segmentCount;
        }

        @Override
        public Segment intersect(long l2, long l3) {
            long l4;
            long l5 = Math.max(l2, this.segmentStart);
            if (l5 <= (l4 = Math.min(l3, this.segmentEnd))) {
                return new SegmentRange(l5, l4);
            }
            return null;
        }

        @Override
        public boolean inIncludeSegments() {
            Segment segment = SegmentedTimeline.this.getSegment(this.segmentStart);
            while (segment.getSegmentStart() < this.segmentEnd) {
                if (!segment.inIncludeSegments()) {
                    return false;
                }
                segment.inc();
            }
            return true;
        }

        @Override
        public boolean inExcludeSegments() {
            Segment segment = SegmentedTimeline.this.getSegment(this.segmentStart);
            while (segment.getSegmentStart() < this.segmentEnd) {
                if (!segment.inExceptionSegments()) {
                    return false;
                }
                segment.inc();
            }
            return true;
        }

        @Override
        public void inc(long l2) {
            throw new IllegalArgumentException("Not implemented in SegmentRange");
        }
    }

    public class Segment
    implements Serializable,
    Cloneable,
    Comparable {
        protected long segmentNumber;
        protected long segmentStart;
        protected long segmentEnd;
        protected long millisecond;

        protected Segment() {
        }

        protected Segment(long l2) {
            this.segmentNumber = this.calculateSegmentNumber(l2);
            this.segmentStart = SegmentedTimeline.this.startTime + this.segmentNumber * SegmentedTimeline.this.segmentSize;
            this.segmentEnd = this.segmentStart + SegmentedTimeline.this.segmentSize - 1L;
            this.millisecond = l2;
        }

        public long calculateSegmentNumber(long l2) {
            if (l2 >= SegmentedTimeline.this.startTime) {
                return (l2 - SegmentedTimeline.this.startTime) / SegmentedTimeline.this.segmentSize;
            }
            return (l2 - SegmentedTimeline.this.startTime) / SegmentedTimeline.this.segmentSize - 1L;
        }

        public long getSegmentNumber() {
            return this.segmentNumber;
        }

        public long getSegmentCount() {
            return 1L;
        }

        public long getSegmentStart() {
            return this.segmentStart;
        }

        public long getSegmentEnd() {
            return this.segmentEnd;
        }

        public long getMillisecond() {
            return this.millisecond;
        }

        public Date getDate() {
            return SegmentedTimeline.this.getDate(this.millisecond);
        }

        public boolean contains(long l2) {
            return this.segmentStart <= l2 && l2 <= this.segmentEnd;
        }

        public boolean contains(long l2, long l3) {
            return this.segmentStart <= l2 && l3 <= this.segmentEnd;
        }

        public boolean contains(Segment segment) {
            return this.contains(segment.getSegmentStart(), segment.getSegmentEnd());
        }

        public boolean contained(long l2, long l3) {
            return l2 <= this.segmentStart && this.segmentEnd <= l3;
        }

        public Segment intersect(long l2, long l3) {
            if (l2 <= this.segmentStart && this.segmentEnd <= l3) {
                return this;
            }
            return null;
        }

        public boolean before(Segment segment) {
            return this.segmentEnd < segment.getSegmentStart();
        }

        public boolean after(Segment segment) {
            return this.segmentStart > segment.getSegmentEnd();
        }

        public boolean equals(Object object) {
            if (object instanceof Segment) {
                Segment segment = (Segment)object;
                return this.segmentNumber == segment.getSegmentNumber() && this.segmentStart == segment.getSegmentStart() && this.segmentEnd == segment.getSegmentEnd() && this.millisecond == segment.getMillisecond();
            }
            return false;
        }

        public Segment copy() {
            try {
                return (Segment)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public int compareTo(Object object) {
            Segment segment = (Segment)object;
            if (this.before(segment)) {
                return -1;
            }
            if (this.after(segment)) {
                return 1;
            }
            return 0;
        }

        public boolean inIncludeSegments() {
            if (this.getSegmentNumberRelativeToGroup() < (long)SegmentedTimeline.this.segmentsIncluded) {
                return !this.inExceptionSegments();
            }
            return false;
        }

        public boolean inExcludeSegments() {
            return this.getSegmentNumberRelativeToGroup() >= (long)SegmentedTimeline.this.segmentsIncluded;
        }

        private long getSegmentNumberRelativeToGroup() {
            long l2 = this.segmentNumber % (long)SegmentedTimeline.this.groupSegmentCount;
            if (l2 < 0L) {
                l2 += (long)SegmentedTimeline.this.groupSegmentCount;
            }
            return l2;
        }

        public boolean inExceptionSegments() {
            return SegmentedTimeline.this.binarySearchExceptionSegments(this) >= 0;
        }

        public void inc(long l2) {
            this.segmentNumber += l2;
            long l3 = l2 * SegmentedTimeline.this.segmentSize;
            this.segmentStart += l3;
            this.segmentEnd += l3;
            this.millisecond += l3;
        }

        public void inc() {
            this.inc(1L);
        }

        public void dec(long l2) {
            this.segmentNumber -= l2;
            long l3 = l2 * SegmentedTimeline.this.segmentSize;
            this.segmentStart -= l3;
            this.segmentEnd -= l3;
            this.millisecond -= l3;
        }

        public void dec() {
            this.dec(1L);
        }

        public void moveIndexToStart() {
            this.millisecond = this.segmentStart;
        }

        public void moveIndexToEnd() {
            this.millisecond = this.segmentEnd;
        }
    }
}

