/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;

public class QuarterDateFormat
extends DateFormat
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -6738465248529797176L;
    public static final String[] REGULAR_QUARTERS = new String[]{"1", "2", "3", "4"};
    public static final String[] ROMAN_QUARTERS = new String[]{"I", "II", "III", "IV"};
    public static final String[] GREEK_QUARTERS = new String[]{"\u0391", "\u0392", "\u0393", "\u0394"};
    private String[] quarters = REGULAR_QUARTERS;
    private boolean quarterFirst;

    public QuarterDateFormat() {
        this(TimeZone.getDefault());
    }

    public QuarterDateFormat(TimeZone timeZone) {
        this(timeZone, REGULAR_QUARTERS);
    }

    public QuarterDateFormat(TimeZone timeZone, String[] stringArray) {
        this(timeZone, stringArray, false);
    }

    public QuarterDateFormat(TimeZone timeZone, String[] stringArray, boolean bl2) {
        ParamChecks.nullNotPermitted(timeZone, "zone");
        this.calendar = new GregorianCalendar(timeZone);
        this.quarters = stringArray;
        this.quarterFirst = bl2;
        this.numberFormat = NumberFormat.getNumberInstance();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        int n2 = this.calendar.get(1);
        int n3 = this.calendar.get(2);
        int n4 = n3 / 3;
        if (this.quarterFirst) {
            stringBuffer.append(this.quarters[n4]);
            stringBuffer.append(" ");
            stringBuffer.append(n2);
        } else {
            stringBuffer.append(n2);
            stringBuffer.append(" ");
            stringBuffer.append(this.quarters[n4]);
        }
        return stringBuffer;
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QuarterDateFormat)) {
            return false;
        }
        QuarterDateFormat quarterDateFormat = (QuarterDateFormat)object;
        if (!Arrays.equals(this.quarters, quarterDateFormat.quarters)) {
            return false;
        }
        if (this.quarterFirst != quarterDateFormat.quarterFirst) {
            return false;
        }
        return super.equals(object);
    }
}

