/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.time.Day;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class PeriodAxis
extends ValueAxis
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 8353295532075872069L;
    private RegularTimePeriod first;
    private RegularTimePeriod last;
    private TimeZone timeZone;
    private Locale locale;
    private Calendar calendar;
    private Class autoRangeTimePeriodClass;
    private Class majorTickTimePeriodClass;
    private boolean minorTickMarksVisible;
    private Class minorTickTimePeriodClass;
    private float minorTickMarkInsideLength = 0.0f;
    private float minorTickMarkOutsideLength = 2.0f;
    private transient Stroke minorTickMarkStroke = new BasicStroke(0.5f);
    private transient Paint minorTickMarkPaint = Color.black;
    private PeriodAxisLabelInfo[] labelInfo;

    public PeriodAxis(String string) {
        this(string, new Day(), new Day());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        this(string, regularTimePeriod, regularTimePeriod2, TimeZone.getDefault(), Locale.getDefault());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2, TimeZone timeZone) {
        this(string, regularTimePeriod, regularTimePeriod2, timeZone, Locale.getDefault());
    }

    public PeriodAxis(String string, RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2, TimeZone timeZone, Locale locale) {
        super(string, null);
        ParamChecks.nullNotPermitted(timeZone, "timeZone");
        ParamChecks.nullNotPermitted(locale, "locale");
        this.first = regularTimePeriod;
        this.last = regularTimePeriod2;
        this.timeZone = timeZone;
        this.locale = locale;
        this.calendar = Calendar.getInstance(timeZone, locale);
        this.first.peg(this.calendar);
        this.last.peg(this.calendar);
        this.autoRangeTimePeriodClass = regularTimePeriod.getClass();
        this.majorTickTimePeriodClass = regularTimePeriod.getClass();
        this.minorTickMarksVisible = false;
        this.minorTickTimePeriodClass = RegularTimePeriod.downsize(this.majorTickTimePeriodClass);
        this.setAutoRange(true);
        this.labelInfo = new PeriodAxisLabelInfo[2];
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM", locale);
        simpleDateFormat.setTimeZone(timeZone);
        this.labelInfo[0] = new PeriodAxisLabelInfo(Month.class, simpleDateFormat);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy", locale);
        simpleDateFormat2.setTimeZone(timeZone);
        this.labelInfo[1] = new PeriodAxisLabelInfo(Year.class, simpleDateFormat2);
    }

    public RegularTimePeriod getFirst() {
        return this.first;
    }

    public void setFirst(RegularTimePeriod regularTimePeriod) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "first");
        this.first = regularTimePeriod;
        this.first.peg(this.calendar);
        this.fireChangeEvent();
    }

    public RegularTimePeriod getLast() {
        return this.last;
    }

    public void setLast(RegularTimePeriod regularTimePeriod) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "last");
        this.last = regularTimePeriod;
        this.last.peg(this.calendar);
        this.fireChangeEvent();
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        ParamChecks.nullNotPermitted(timeZone, "zone");
        this.timeZone = timeZone;
        this.calendar = Calendar.getInstance(timeZone, this.locale);
        this.first.peg(this.calendar);
        this.last.peg(this.calendar);
        this.fireChangeEvent();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Class getAutoRangeTimePeriodClass() {
        return this.autoRangeTimePeriodClass;
    }

    public void setAutoRangeTimePeriodClass(Class clazz) {
        ParamChecks.nullNotPermitted(clazz, "c");
        this.autoRangeTimePeriodClass = clazz;
        this.fireChangeEvent();
    }

    public Class getMajorTickTimePeriodClass() {
        return this.majorTickTimePeriodClass;
    }

    public void setMajorTickTimePeriodClass(Class clazz) {
        ParamChecks.nullNotPermitted(clazz, "c");
        this.majorTickTimePeriodClass = clazz;
        this.fireChangeEvent();
    }

    @Override
    public boolean isMinorTickMarksVisible() {
        return this.minorTickMarksVisible;
    }

    @Override
    public void setMinorTickMarksVisible(boolean bl2) {
        this.minorTickMarksVisible = bl2;
        this.fireChangeEvent();
    }

    public Class getMinorTickTimePeriodClass() {
        return this.minorTickTimePeriodClass;
    }

    public void setMinorTickTimePeriodClass(Class clazz) {
        ParamChecks.nullNotPermitted(clazz, "c");
        this.minorTickTimePeriodClass = clazz;
        this.fireChangeEvent();
    }

    public Stroke getMinorTickMarkStroke() {
        return this.minorTickMarkStroke;
    }

    public void setMinorTickMarkStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.minorTickMarkStroke = stroke;
        this.fireChangeEvent();
    }

    public Paint getMinorTickMarkPaint() {
        return this.minorTickMarkPaint;
    }

    public void setMinorTickMarkPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.minorTickMarkPaint = paint;
        this.fireChangeEvent();
    }

    @Override
    public float getMinorTickMarkInsideLength() {
        return this.minorTickMarkInsideLength;
    }

    @Override
    public void setMinorTickMarkInsideLength(float f2) {
        this.minorTickMarkInsideLength = f2;
        this.fireChangeEvent();
    }

    @Override
    public float getMinorTickMarkOutsideLength() {
        return this.minorTickMarkOutsideLength;
    }

    @Override
    public void setMinorTickMarkOutsideLength(float f2) {
        this.minorTickMarkOutsideLength = f2;
        this.fireChangeEvent();
    }

    public PeriodAxisLabelInfo[] getLabelInfo() {
        return this.labelInfo;
    }

    public void setLabelInfo(PeriodAxisLabelInfo[] periodAxisLabelInfoArray) {
        this.labelInfo = periodAxisLabelInfoArray;
        this.fireChangeEvent();
    }

    @Override
    public void setRange(Range range, boolean bl2, boolean bl3) {
        long l2 = Math.round(range.getUpperBound());
        long l3 = Math.round(range.getLowerBound());
        this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(l3), this.timeZone, this.locale);
        this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(l2), this.timeZone, this.locale);
        super.setRange(new Range(this.first.getFirstMillisecond(), (double)this.last.getLastMillisecond() + 1.0), bl2, bl3);
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    public AxisSpace reserveSpace(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, RectangleEdge rectangleEdge, AxisSpace axisSpace) {
        if (axisSpace == null) {
            axisSpace = new AxisSpace();
        }
        if (!this.isVisible()) {
            return axisSpace;
        }
        double d2 = this.getFixedDimension();
        if (d2 > 0.0) {
            axisSpace.ensureAtLeast(d2, rectangleEdge);
        }
        Rectangle2D rectangle2D2 = this.getLabelEnclosure(graphics2D, rectangleEdge);
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.labelInfo.length; ++i2) {
            PeriodAxisLabelInfo periodAxisLabelInfo = this.labelInfo[i2];
            FontMetrics fontMetrics = graphics2D.getFontMetrics(periodAxisLabelInfo.getLabelFont());
            d3 += periodAxisLabelInfo.getPadding().extendHeight(fontMetrics.getHeight());
        }
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d4 = rectangle2D2.getHeight();
            axisSpace.add(d4 + d3, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d5 = rectangle2D2.getWidth();
            axisSpace.add(d5 + d3, rectangleEdge);
        }
        double d6 = 0.0;
        if (this.isTickMarksVisible()) {
            d6 = this.getTickMarkOutsideLength();
        }
        if (this.minorTickMarksVisible) {
            d6 = Math.max(d6, (double)this.minorTickMarkOutsideLength);
        }
        axisSpace.add(d6, rectangleEdge);
        return axisSpace;
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        AxisState axisState = new AxisState(d2);
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(graphics2D, d2, rectangle2D2, rectangleEdge);
        }
        if (this.isTickMarksVisible()) {
            this.drawTickMarks(graphics2D, axisState, rectangle2D2, rectangleEdge);
        }
        if (this.isTickLabelsVisible()) {
            for (int i2 = 0; i2 < this.labelInfo.length; ++i2) {
                axisState = this.drawTickLabels(i2, graphics2D, axisState, rectangle2D2, rectangleEdge);
            }
        }
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        return axisState;
    }

    protected void drawTickMarks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.drawTickMarksHorizontal(graphics2D, axisState, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.drawTickMarksVertical(graphics2D, axisState, rectangle2D, rectangleEdge);
        }
    }

    protected void drawTickMarksHorizontal(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        double d2 = axisState.getCursor();
        double d3 = this.getTickMarkInsideLength();
        double d4 = this.getTickMarkOutsideLength();
        RegularTimePeriod regularTimePeriod = this.createInstance(this.majorTickTimePeriodClass, this.first.getStart(), this.getTimeZone(), this.locale);
        long l2 = regularTimePeriod.getFirstMillisecond();
        Line2D.Double double_ = null;
        Line2D.Double double_2 = null;
        long l3 = this.getFirst().getFirstMillisecond();
        long l4 = this.getLast().getLastMillisecond() + 1L;
        while (l2 <= l4) {
            arrayList.add(new NumberTick((Number)l2, "", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            double d5 = this.valueToJava2D(l2, rectangle2D, rectangleEdge);
            if (rectangleEdge == RectangleEdge.TOP) {
                double_ = new Line2D.Double(d5, d2, d5, d2 + d3);
                double_2 = new Line2D.Double(d5, d2, d5, d2 - d4);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_ = new Line2D.Double(d5, d2, d5, d2 - d3);
                double_2 = new Line2D.Double(d5, d2, d5, d2 + d4);
            }
            if (l2 >= l3) {
                graphics2D.setPaint(this.getTickMarkPaint());
                graphics2D.setStroke(this.getTickMarkStroke());
                graphics2D.draw(double_);
                graphics2D.draw(double_2);
            }
            if (this.minorTickMarksVisible) {
                RegularTimePeriod regularTimePeriod2 = this.createInstance(this.minorTickTimePeriodClass, new Date(l2), this.getTimeZone(), this.locale);
                long l5 = regularTimePeriod2.getFirstMillisecond();
                while (l5 < regularTimePeriod.getLastMillisecond() && l5 < l4) {
                    double d6 = this.valueToJava2D(l5, rectangle2D, rectangleEdge);
                    if (rectangleEdge == RectangleEdge.TOP) {
                        double_ = new Line2D.Double(d6, d2, d6, d2 + (double)this.minorTickMarkInsideLength);
                        double_2 = new Line2D.Double(d6, d2, d6, d2 - (double)this.minorTickMarkOutsideLength);
                    } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                        double_ = new Line2D.Double(d6, d2, d6, d2 - (double)this.minorTickMarkInsideLength);
                        double_2 = new Line2D.Double(d6, d2, d6, d2 + (double)this.minorTickMarkOutsideLength);
                    }
                    if (l5 >= l3) {
                        graphics2D.setPaint(this.minorTickMarkPaint);
                        graphics2D.setStroke(this.minorTickMarkStroke);
                        graphics2D.draw(double_);
                        graphics2D.draw(double_2);
                    }
                    regularTimePeriod2 = regularTimePeriod2.next();
                    regularTimePeriod2.peg(this.calendar);
                    l5 = regularTimePeriod2.getFirstMillisecond();
                }
            }
            regularTimePeriod = regularTimePeriod.next();
            regularTimePeriod.peg(this.calendar);
            l2 = regularTimePeriod.getFirstMillisecond();
        }
        if (rectangleEdge == RectangleEdge.TOP) {
            axisState.cursorUp(Math.max(d4, (double)this.minorTickMarkOutsideLength));
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            axisState.cursorDown(Math.max(d4, (double)this.minorTickMarkOutsideLength));
        }
        axisState.setTicks(arrayList);
    }

    protected void drawTickMarksVertical(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
    }

    protected AxisState drawTickLabels(int n2, Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = 0.0;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.labelInfo[n2].getLabelFont());
        if (rectangleEdge == RectangleEdge.BOTTOM) {
            d2 = this.labelInfo[n2].getPadding().calculateTopOutset(fontMetrics.getHeight());
        } else if (rectangleEdge == RectangleEdge.TOP) {
            d2 = this.labelInfo[n2].getPadding().calculateBottomOutset(fontMetrics.getHeight());
        }
        axisState.moveCursor(d2, rectangleEdge);
        long l2 = this.first.getFirstMillisecond();
        long l3 = this.last.getLastMillisecond();
        graphics2D.setFont(this.labelInfo[n2].getLabelFont());
        graphics2D.setPaint(this.labelInfo[n2].getLabelPaint());
        RegularTimePeriod regularTimePeriod = this.labelInfo[n2].createInstance(new Date(l2), this.timeZone, this.locale);
        RegularTimePeriod regularTimePeriod2 = this.labelInfo[n2].createInstance(new Date(l3), this.timeZone, this.locale);
        DateFormat dateFormat = this.labelInfo[n2].getDateFormat();
        dateFormat.setTimeZone(this.timeZone);
        String string = dateFormat.format(new Date(regularTimePeriod.getMiddleMillisecond()));
        String string2 = dateFormat.format(new Date(regularTimePeriod2.getMiddleMillisecond()));
        Rectangle2D rectangle2D2 = TextUtilities.getTextBounds(string, graphics2D, graphics2D.getFontMetrics());
        Rectangle2D rectangle2D3 = TextUtilities.getTextBounds(string2, graphics2D, graphics2D.getFontMetrics());
        double d3 = Math.max(rectangle2D2.getWidth(), rectangle2D3.getWidth());
        long l4 = Math.round(this.java2DToValue(rectangle2D.getX() + d3 + 5.0, rectangle2D, rectangleEdge));
        l4 = this.isInverted() ? l3 - l4 : (l4 -= l2);
        long l5 = regularTimePeriod.getLastMillisecond() - regularTimePeriod.getFirstMillisecond();
        int n3 = (int)(l4 / l5) + 1;
        RegularTimePeriod regularTimePeriod3 = this.labelInfo[n2].createInstance(new Date(l2), this.timeZone, this.locale);
        RectangularShape rectangularShape = null;
        long l6 = 0L;
        float f2 = (float)axisState.getCursor();
        TextAnchor textAnchor = TextAnchor.TOP_CENTER;
        float f3 = (float)rectangle2D2.getHeight();
        if (rectangleEdge == RectangleEdge.TOP) {
            textAnchor = TextAnchor.BOTTOM_CENTER;
            f3 = -f3;
        }
        while (regularTimePeriod3.getFirstMillisecond() <= l3) {
            float f4;
            Rectangle2D rectangle2D4;
            float f5 = (float)this.valueToJava2D(regularTimePeriod3.getMiddleMillisecond(), rectangle2D, rectangleEdge);
            String string3 = dateFormat.format(new Date(regularTimePeriod3.getMiddleMillisecond()));
            long l7 = regularTimePeriod3.getFirstMillisecond();
            long l8 = regularTimePeriod3.getLastMillisecond();
            if (l8 > l3 && (double)f5 + (rectangle2D4 = TextUtilities.getTextBounds(string3, graphics2D, graphics2D.getFontMetrics())).getWidth() / 2.0 > rectangle2D.getMaxX()) {
                f4 = (float)this.valueToJava2D(Math.max(l7, l2), rectangle2D, rectangleEdge);
                if (rectangle2D4.getWidth() < rectangle2D.getMaxX() - (double)f4) {
                    f5 = ((float)rectangle2D.getMaxX() + f4) / 2.0f;
                } else {
                    string3 = null;
                }
            }
            if (l7 < l2 && (double)f5 - (rectangle2D4 = TextUtilities.getTextBounds(string3, graphics2D, graphics2D.getFontMetrics())).getWidth() / 2.0 < rectangle2D.getX()) {
                f4 = (float)this.valueToJava2D(Math.min(l8, l3), rectangle2D, rectangleEdge);
                if (rectangle2D4.getWidth() < (double)f4 - rectangle2D.getX()) {
                    f5 = (f4 + (float)rectangle2D.getX()) / 2.0f;
                } else {
                    string3 = null;
                }
            }
            if (string3 != null) {
                graphics2D.setPaint(this.labelInfo[n2].getLabelPaint());
                rectangularShape = TextUtilities.drawAlignedString(string3, graphics2D, f5, f2, textAnchor);
            }
            if (l6 > 0L && this.labelInfo[n2].getDrawDividers()) {
                long l9 = regularTimePeriod3.getFirstMillisecond();
                long l10 = (l6 + l9) / 2L;
                float f6 = (float)this.valueToJava2D(l10, rectangle2D, rectangleEdge);
                graphics2D.setStroke(this.labelInfo[n2].getDividerStroke());
                graphics2D.setPaint(this.labelInfo[n2].getDividerPaint());
                graphics2D.draw(new Line2D.Float(f6, f2, f6, f2 + f3));
            }
            l6 = l8;
            for (int i2 = 0; i2 < n3; ++i2) {
                regularTimePeriod3 = regularTimePeriod3.next();
            }
            regularTimePeriod3.peg(this.calendar);
        }
        double d4 = 0.0;
        if (rectangularShape != null) {
            d4 = rectangularShape.getHeight();
            if (rectangleEdge == RectangleEdge.BOTTOM) {
                d4 += this.labelInfo[n2].getPadding().calculateBottomOutset(fontMetrics.getHeight());
            } else if (rectangleEdge == RectangleEdge.TOP) {
                d4 += this.labelInfo[n2].getPadding().calculateTopOutset(fontMetrics.getHeight());
            }
        }
        axisState.moveCursor(d4, rectangleEdge);
        return axisState;
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public double valueToJava2D(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d3 = Double.NaN;
        double d4 = this.first.getFirstMillisecond();
        double d5 = this.last.getLastMillisecond();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d6 = rectangle2D.getX();
            double d7 = rectangle2D.getMaxX();
            d3 = this.isInverted() ? d7 + (d2 - d4) / (d5 - d4) * (d6 - d7) : d6 + (d2 - d4) / (d5 - d4) * (d7 - d6);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d8 = rectangle2D.getMinY();
            double d9 = rectangle2D.getMaxY();
            d3 = this.isInverted() ? d8 + (d2 - d4) / (d5 - d4) * (d9 - d8) : d9 - (d2 - d4) / (d5 - d4) * (d9 - d8);
        }
        return d3;
    }

    @Override
    public double java2DToValue(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = this.first.getFirstMillisecond();
        double d6 = this.last.getLastMillisecond();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d3 = rectangle2D.getX();
            d4 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d3 = rectangle2D.getMaxY();
            d4 = rectangle2D.getY();
        }
        double d7 = this.isInverted() ? d6 - (d2 - d3) / (d4 - d3) * (d6 - d5) : d5 + (d2 - d3) / (d4 - d3) * (d6 - d5);
        return d7;
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            long l2 = Math.round(range.getUpperBound());
            long l3 = Math.round(range.getLowerBound());
            this.first = this.createInstance(this.autoRangeTimePeriodClass, new Date(l3), this.timeZone, this.locale);
            this.last = this.createInstance(this.autoRangeTimePeriodClass, new Date(l2), this.timeZone, this.locale);
            this.setRange(range, false, false);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PeriodAxis)) {
            return false;
        }
        PeriodAxis periodAxis = (PeriodAxis)object;
        if (!this.first.equals(periodAxis.first)) {
            return false;
        }
        if (!this.last.equals(periodAxis.last)) {
            return false;
        }
        if (!this.timeZone.equals(periodAxis.timeZone)) {
            return false;
        }
        if (!this.locale.equals(periodAxis.locale)) {
            return false;
        }
        if (!this.autoRangeTimePeriodClass.equals(periodAxis.autoRangeTimePeriodClass)) {
            return false;
        }
        if (this.isMinorTickMarksVisible() != periodAxis.isMinorTickMarksVisible()) {
            return false;
        }
        if (!this.majorTickTimePeriodClass.equals(periodAxis.majorTickTimePeriodClass)) {
            return false;
        }
        if (!this.minorTickTimePeriodClass.equals(periodAxis.minorTickTimePeriodClass)) {
            return false;
        }
        if (!this.minorTickMarkPaint.equals(periodAxis.minorTickMarkPaint)) {
            return false;
        }
        if (!this.minorTickMarkStroke.equals(periodAxis.minorTickMarkStroke)) {
            return false;
        }
        if (!Arrays.equals(this.labelInfo, periodAxis.labelInfo)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object clone() {
        PeriodAxis periodAxis = (PeriodAxis)super.clone();
        periodAxis.timeZone = (TimeZone)this.timeZone.clone();
        periodAxis.labelInfo = (PeriodAxisLabelInfo[])this.labelInfo.clone();
        return periodAxis;
    }

    private RegularTimePeriod createInstance(Class clazz, Date date, TimeZone timeZone, Locale locale) {
        RegularTimePeriod regularTimePeriod = null;
        try {
            Constructor constructor = clazz.getDeclaredConstructor(Date.class, TimeZone.class, Locale.class);
            regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date, timeZone, locale);
        }
        catch (Exception exception) {
            try {
                Constructor constructor = clazz.getDeclaredConstructor(Date.class);
                regularTimePeriod = (RegularTimePeriod)constructor.newInstance(date);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return regularTimePeriod;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.minorTickMarkStroke, objectOutputStream);
        SerialUtilities.writePaint(this.minorTickMarkPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.minorTickMarkStroke = SerialUtilities.readStroke(objectInputStream);
        this.minorTickMarkPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

