/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.util.ParamChecks;

public class NumberTickUnit
extends TickUnit
implements Serializable {
    private static final long serialVersionUID = 3849459506627654442L;
    private NumberFormat formatter;

    public NumberTickUnit(double d2) {
        this(d2, NumberFormat.getNumberInstance());
    }

    public NumberTickUnit(double d2, NumberFormat numberFormat) {
        super(d2);
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.formatter = numberFormat;
    }

    public NumberTickUnit(double d2, NumberFormat numberFormat, int n2) {
        super(d2, n2);
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.formatter = numberFormat;
    }

    @Override
    public String valueToString(double d2) {
        return this.formatter.format(d2);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberTickUnit)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NumberTickUnit numberTickUnit = (NumberTickUnit)object;
        return this.formatter.equals(numberTickUnit.formatter);
    }

    public String toString() {
        return "[size=" + this.valueToString(this.getSize()) + "]";
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 29 * n2 + (this.formatter != null ? this.formatter.hashCode() : 0);
        return n2;
    }
}

