/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.MarkerAxisBand;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.RangeType;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class NumberAxis
extends ValueAxis
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2805933088476185789L;
    public static final boolean DEFAULT_AUTO_RANGE_INCLUDES_ZERO = true;
    public static final boolean DEFAULT_AUTO_RANGE_STICKY_ZERO = true;
    public static final NumberTickUnit DEFAULT_TICK_UNIT = new NumberTickUnit(1.0, new DecimalFormat("0"));
    public static final boolean DEFAULT_VERTICAL_TICK_LABELS = false;
    private RangeType rangeType = RangeType.FULL;
    private boolean autoRangeIncludesZero = true;
    private boolean autoRangeStickyZero = true;
    private NumberTickUnit tickUnit = DEFAULT_TICK_UNIT;
    private NumberFormat numberFormatOverride = null;
    private MarkerAxisBand markerBand = null;

    public NumberAxis() {
        this(null);
    }

    public NumberAxis(String string) {
        super(string, NumberAxis.createStandardTickUnits());
    }

    public RangeType getRangeType() {
        return this.rangeType;
    }

    public void setRangeType(RangeType rangeType) {
        ParamChecks.nullNotPermitted(rangeType, "rangeType");
        this.rangeType = rangeType;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean getAutoRangeIncludesZero() {
        return this.autoRangeIncludesZero;
    }

    public void setAutoRangeIncludesZero(boolean bl2) {
        if (this.autoRangeIncludesZero != bl2) {
            this.autoRangeIncludesZero = bl2;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean getAutoRangeStickyZero() {
        return this.autoRangeStickyZero;
    }

    public void setAutoRangeStickyZero(boolean bl2) {
        if (this.autoRangeStickyZero != bl2) {
            this.autoRangeStickyZero = bl2;
            if (this.isAutoRange()) {
                this.autoAdjustRange();
            }
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(numberTickUnit, "unit");
        this.tickUnit = numberTickUnit;
        if (bl3) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl2) {
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public MarkerAxisBand getMarkerBand() {
        return this.markerBand;
    }

    public void setMarkerBand(MarkerAxisBand markerAxisBand) {
        this.markerBand = markerAxisBand;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            double d2 = range.getUpperBound();
            double d3 = range.getLowerBound();
            if (this.rangeType == RangeType.POSITIVE) {
                d3 = Math.max(0.0, d3);
                d2 = Math.max(0.0, d2);
            } else if (this.rangeType == RangeType.NEGATIVE) {
                d3 = Math.min(0.0, d3);
                d2 = Math.min(0.0, d2);
            }
            if (this.getAutoRangeIncludesZero()) {
                d3 = Math.min(d3, 0.0);
                d2 = Math.max(d2, 0.0);
            }
            double d4 = d2 - d3;
            double d5 = this.getFixedAutoRange();
            if (d5 > 0.0) {
                d3 = d2 - d5;
            } else {
                double d6 = this.getAutoRangeMinimumSize();
                if (d4 < d6) {
                    double d7 = (d6 - d4) / 2.0;
                    if ((d3 -= d7) == (d2 += d7)) {
                        double d8 = Math.abs(d3) / 10.0;
                        d3 -= d8;
                        d2 += d8;
                    }
                    if (this.rangeType == RangeType.POSITIVE) {
                        if (d3 < 0.0) {
                            d2 -= d3;
                            d3 = 0.0;
                        }
                    } else if (this.rangeType == RangeType.NEGATIVE && d2 > 0.0) {
                        d3 -= d2;
                        d2 = 0.0;
                    }
                }
                if (this.getAutoRangeStickyZero()) {
                    d2 = d2 <= 0.0 ? Math.min(0.0, d2 + this.getUpperMargin() * d4) : (d2 += this.getUpperMargin() * d4);
                    d3 = d3 >= 0.0 ? Math.max(0.0, d3 - this.getLowerMargin() * d4) : (d3 -= this.getLowerMargin() * d4);
                } else {
                    d2 += this.getUpperMargin() * d4;
                    d3 -= this.getLowerMargin() * d4;
                }
            }
            this.setRange(new Range(d3, d2), false, false);
        }
    }

    @Override
    public double valueToJava2D(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d3 = range.getLowerBound();
        double d4 = range.getUpperBound();
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d6 = rectangle2D.getMinY();
            d5 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d6 - (d2 - d3) / (d4 - d3) * (d6 - d5);
        }
        return d5 + (d2 - d3) / (d4 - d3) * (d6 - d5);
    }

    @Override
    public double java2DToValue(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d3 = range.getLowerBound();
        double d4 = range.getUpperBound();
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMaxY();
            d6 = rectangle2D.getY();
        }
        if (this.isInverted()) {
            return d4 - (d2 - d5) / (d6 - d5) * (d4 - d3);
        }
        return d3 + (d2 - d5) / (d6 - d5) * (d4 - d3);
    }

    protected double calculateLowestVisibleTickValue() {
        double d2 = this.getTickUnit().getSize();
        double d3 = Math.ceil(this.getRange().getLowerBound() / d2);
        return d3 * d2;
    }

    protected double calculateHighestVisibleTickValue() {
        double d2 = this.getTickUnit().getSize();
        double d3 = Math.floor(this.getRange().getUpperBound() / d2);
        return d3 * d2;
    }

    protected int calculateVisibleTickCount() {
        double d2 = this.getTickUnit().getSize();
        Range range = this.getRange();
        return (int)(Math.floor(range.getUpperBound() / d2) - Math.ceil(range.getLowerBound() / d2) + 1.0);
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d2);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        this.createAndAddEntity(d2, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        return axisState;
    }

    public static TickUnitSource createStandardTickUnits() {
        return new NumberTickUnitSource();
    }

    public static TickUnitSource createIntegerTickUnits() {
        return new NumberTickUnitSource(true);
    }

    public static TickUnitSource createStandardTickUnits(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        return new NumberTickUnitSource(false, numberFormat);
    }

    public static TickUnitSource createIntegerTickUnits(Locale locale) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(locale);
        return new NumberTickUnitSource(true, numberFormat);
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d2 = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d2 += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d2 = rectangleInsets.getLeft() + rectangleInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = this.getTickLabelFont().getLineMetrics("0", fontRenderContext);
            d2 += (double)lineMetrics.getHeight();
        } else {
            String string;
            String string2;
            FontMetrics fontMetrics = graphics2D.getFontMetrics(this.getTickLabelFont());
            Range range = this.getRange();
            double d3 = range.getLowerBound();
            double d4 = range.getUpperBound();
            NumberFormat numberFormat = this.getNumberFormatOverride();
            if (numberFormat != null) {
                string2 = numberFormat.format(d3);
                string = numberFormat.format(d4);
            } else {
                string2 = tickUnit.valueToString(d3);
                string = tickUnit.valueToString(d4);
            }
            double d5 = fontMetrics.stringWidth(string2);
            double d6 = fontMetrics.stringWidth(string);
            d2 += Math.max(d5, d6);
        }
        return d2;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.lengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d4 = d2 / d3 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d4);
        double d5 = this.lengthToJava2D(numberTickUnit.getSize(), rectangle2D, rectangleEdge);
        d2 = this.estimateMaximumTickLabelWidth(graphics2D, numberTickUnit);
        if (d2 > d5) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = this.estimateMaximumTickLabelHeight(graphics2D);
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.lengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d4 = tickUnit.getSize();
        if (d3 > 0.0) {
            d4 = d2 / d3 * tickUnit.getSize();
        }
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnitSource.getCeilingTickUnit(d4);
        double d5 = this.lengthToJava2D(numberTickUnit.getSize(), rectangle2D, rectangleEdge);
        d2 = this.estimateMaximumTickLabelHeight(graphics2D);
        if (d2 > d5) {
            numberTickUnit = (NumberTickUnit)tickUnitSource.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        NumberTickUnit numberTickUnit = this.getTickUnit();
        double d2 = numberTickUnit.getSize();
        int n2 = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        if (n2 <= 500) {
            double d4;
            int n3;
            int n4 = this.getMinorTickCount();
            if (n4 <= 0) {
                n4 = numberTickUnit.getMinorTickCount();
            }
            for (n3 = 1; n3 < n4; ++n3) {
                d4 = d3 - d2 * (double)n3 / (double)n4;
                if (!this.getRange().contains(d4)) continue;
                arrayList.add(new NumberTick(TickType.MINOR, d4, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            for (n3 = 0; n3 < n2; ++n3) {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                d4 = d3 + (double)n3 * d2;
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
                double d5 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    d5 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor2 = TextAnchor.TOP_CENTER;
                    textAnchor = TextAnchor.TOP_CENTER;
                }
                NumberTick numberTick = new NumberTick(new Double(d4), string, textAnchor2, textAnchor, d5);
                arrayList.add(numberTick);
                double d6 = d3 + (double)(n3 + 1) * d2;
                for (int i2 = 1; i2 < n4; ++i2) {
                    double d7 = d4 + (d6 - d4) * (double)i2 / (double)n4;
                    if (!this.getRange().contains(d7)) continue;
                    arrayList.add(new NumberTick(TickType.MINOR, d7, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
                }
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<NumberTick> arrayList = new ArrayList<NumberTick>();
        arrayList.clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        NumberTickUnit numberTickUnit = this.getTickUnit();
        double d2 = numberTickUnit.getSize();
        int n2 = this.calculateVisibleTickCount();
        double d3 = this.calculateLowestVisibleTickValue();
        if (n2 <= 500) {
            double d4;
            int n3;
            int n4 = this.getMinorTickCount();
            if (n4 <= 0) {
                n4 = numberTickUnit.getMinorTickCount();
            }
            for (n3 = 1; n3 < n4; ++n3) {
                d4 = d3 - d2 * (double)n3 / (double)n4;
                if (!this.getRange().contains(d4)) continue;
                arrayList.add(new NumberTick(TickType.MINOR, d4, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            for (n3 = 0; n3 < n2; ++n3) {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                d4 = d3 + (double)n3 * d2;
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d4) : this.getTickUnit().valueToString(d4);
                double d5 = 0.0;
                if (this.isVerticalTickLabels()) {
                    if (rectangleEdge == RectangleEdge.LEFT) {
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        d5 = -1.5707963267948966;
                    } else {
                        textAnchor2 = TextAnchor.BOTTOM_CENTER;
                        textAnchor = TextAnchor.BOTTOM_CENTER;
                        d5 = 1.5707963267948966;
                    }
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                    textAnchor = TextAnchor.CENTER_LEFT;
                }
                NumberTick numberTick = new NumberTick(new Double(d4), string, textAnchor2, textAnchor, d5);
                arrayList.add(numberTick);
                double d6 = d3 + (double)(n3 + 1) * d2;
                for (int i2 = 1; i2 < n4; ++i2) {
                    double d7 = d4 + (d6 - d4) * (double)i2 / (double)n4;
                    if (!this.getRange().contains(d7)) continue;
                    arrayList.add(new NumberTick(TickType.MINOR, d7, "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
                }
            }
        }
        return arrayList;
    }

    @Override
    public Object clone() {
        NumberAxis numberAxis = (NumberAxis)super.clone();
        if (this.numberFormatOverride != null) {
            numberAxis.numberFormatOverride = (NumberFormat)this.numberFormatOverride.clone();
        }
        return numberAxis;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberAxis)) {
            return false;
        }
        NumberAxis numberAxis = (NumberAxis)object;
        if (this.autoRangeIncludesZero != numberAxis.autoRangeIncludesZero) {
            return false;
        }
        if (this.autoRangeStickyZero != numberAxis.autoRangeStickyZero) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickUnit, numberAxis.tickUnit)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.numberFormatOverride, numberAxis.numberFormatOverride)) {
            return false;
        }
        if (!this.rangeType.equals(numberAxis.rangeType)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

