/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.util.ParamChecks;

public class MonthDateFormat
extends DateFormat {
    private String[] months;
    private boolean[] showYear;
    private DateFormat yearFormatter;

    public MonthDateFormat() {
        this(TimeZone.getDefault());
    }

    public MonthDateFormat(TimeZone timeZone) {
        this(timeZone, Locale.getDefault(), 1, true, false);
    }

    public MonthDateFormat(Locale locale) {
        this(TimeZone.getDefault(), locale, 1, true, false);
    }

    public MonthDateFormat(TimeZone timeZone, int n2) {
        this(timeZone, Locale.getDefault(), n2, true, false);
    }

    public MonthDateFormat(Locale locale, int n2) {
        this(TimeZone.getDefault(), locale, n2, true, false);
    }

    public MonthDateFormat(TimeZone timeZone, Locale locale, int n2, boolean bl2, boolean bl3) {
        this(timeZone, locale, n2, new boolean[]{bl2, false, false, false, false, false, false, false, false, false, false, false, bl3}, new SimpleDateFormat("yy"));
    }

    public MonthDateFormat(TimeZone timeZone, Locale locale, int n2, boolean[] blArray, DateFormat dateFormat) {
        ParamChecks.nullNotPermitted(locale, "locale");
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        String[] stringArray = dateFormatSymbols.getMonths();
        this.months = new String[12];
        for (int i2 = 0; i2 < 12; ++i2) {
            this.months[i2] = n2 > 0 ? stringArray[i2].substring(0, Math.min(n2, stringArray[i2].length())) : stringArray[i2];
        }
        this.calendar = new GregorianCalendar(timeZone);
        this.showYear = blArray;
        this.yearFormatter = dateFormat;
        this.numberFormat = NumberFormat.getNumberInstance();
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        int n2 = this.calendar.get(2);
        stringBuffer.append(this.months[n2]);
        if (this.showYear[n2]) {
            stringBuffer.append(this.yearFormatter.format(date));
        }
        return stringBuffer;
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MonthDateFormat)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        MonthDateFormat monthDateFormat = (MonthDateFormat)object;
        if (!Arrays.equals(this.months, monthDateFormat.months)) {
            return false;
        }
        if (!Arrays.equals(this.showYear, monthDateFormat.showYear)) {
            return false;
        }
        return this.yearFormatter.equals(monthDateFormat.yearFormatter);
    }
}

