/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.LogTick;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.NumberTickUnitSource;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.AttrStringUtils;
import org.jfree.chart.util.LogFormat;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class LogAxis
extends ValueAxis {
    private double base = 10.0;
    private double baseLog = Math.log(10.0);
    private String baseSymbol = null;
    private Format baseFormatter = new DecimalFormat("0");
    private double smallestValue = 1.0E-100;
    private NumberTickUnit tickUnit;
    private NumberFormat numberFormatOverride;

    public LogAxis() {
        this(null);
    }

    public LogAxis(String string) {
        super(string, new NumberTickUnitSource());
        this.setDefaultAutoRange(new Range(0.01, 1.0));
        this.tickUnit = new NumberTickUnit(1.0, new DecimalFormat("0.#"), 10);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d2) {
        if (d2 <= 1.0) {
            throw new IllegalArgumentException("Requires 'base' > 1.0.");
        }
        this.base = d2;
        this.baseLog = Math.log(d2);
        this.fireChangeEvent();
    }

    public String getBaseSymbol() {
        return this.baseSymbol;
    }

    public void setBaseSymbol(String string) {
        this.baseSymbol = string;
        this.fireChangeEvent();
    }

    public Format getBaseFormatter() {
        return this.baseFormatter;
    }

    public void setBaseFormatter(Format format) {
        ParamChecks.nullNotPermitted(format, "formatter");
        this.baseFormatter = format;
        this.fireChangeEvent();
    }

    public double getSmallestValue() {
        return this.smallestValue;
    }

    public void setSmallestValue(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Requires 'value' > 0.0.");
        }
        this.smallestValue = d2;
        this.fireChangeEvent();
    }

    public NumberTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(NumberTickUnit numberTickUnit) {
        this.setTickUnit(numberTickUnit, true, true);
    }

    public void setTickUnit(NumberTickUnit numberTickUnit, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(numberTickUnit, "unit");
        this.tickUnit = numberTickUnit;
        if (bl3) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public NumberFormat getNumberFormatOverride() {
        return this.numberFormatOverride;
    }

    public void setNumberFormatOverride(NumberFormat numberFormat) {
        this.numberFormatOverride = numberFormat;
        this.fireChangeEvent();
    }

    public double calculateLog(double d2) {
        return Math.log(d2) / this.baseLog;
    }

    public double calculateValue(double d2) {
        return Math.pow(this.base, d2);
    }

    private double calculateValueNoINF(double d2) {
        double d3 = this.calculateValue(d2);
        if (Double.isInfinite(d3)) {
            d3 = Double.MAX_VALUE;
        }
        if (d3 <= 0.0) {
            d3 = Double.MIN_VALUE;
        }
        return d3;
    }

    @Override
    public double java2DToValue(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d3 = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double d4 = this.calculateLog(range.getUpperBound());
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMaxY();
            d6 = rectangle2D.getY();
        }
        double d7 = this.isInverted() ? d4 - (d2 - d5) / (d6 - d5) * (d4 - d3) : d3 + (d2 - d5) / (d6 - d5) * (d4 - d3);
        return this.calculateValue(d7);
    }

    @Override
    public double valueToJava2D(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        Range range = this.getRange();
        double d3 = this.calculateLog(range.getLowerBound());
        double d4 = this.calculateLog(range.getUpperBound());
        d2 = this.calculateLog(d2);
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d6 = rectangle2D.getMinY();
            d5 = rectangle2D.getMaxY();
        }
        if (this.isInverted()) {
            return d6 - (d2 - d3) / (d4 - d3) * (d6 - d5);
        }
        return d5 + (d2 - d3) / (d4 - d3) * (d6 - d5);
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.getDefaultAutoRange();
            }
            double d2 = range.getUpperBound();
            double d3 = Math.max(range.getLowerBound(), this.smallestValue);
            double d4 = d2 - d3;
            double d5 = this.getFixedAutoRange();
            if (d5 > 0.0) {
                d3 = Math.max(d2 - d5, this.smallestValue);
            } else {
                double d6;
                double d7 = this.getAutoRangeMinimumSize();
                if (d4 < d7) {
                    d6 = (d7 - d4) / 2.0;
                    d2 += d6;
                    d3 -= d6;
                }
                d6 = this.calculateLog(d2);
                double d8 = this.calculateLog(d3);
                double d9 = d6 - d8;
                d2 = this.calculateValueNoINF(d6 += this.getUpperMargin() * d9);
                d3 = this.calculateValueNoINF(d8 -= this.getLowerMargin() * d9);
            }
            this.setRange(new Range(d3, d2), false, false);
        }
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d2);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        this.createAndAddEntity(d2, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        return axisState;
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = new ArrayList();
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        boolean bl2;
        Range range = this.getRange();
        ArrayList<LogTick> arrayList = new ArrayList<LogTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        TextAnchor textAnchor = rectangleEdge == RectangleEdge.TOP ? TextAnchor.BOTTOM_CENTER : TextAnchor.TOP_CENTER;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        int n2 = this.tickUnit.getMinorTickCount();
        double d2 = this.getTickUnit().getSize();
        double d3 = Math.ceil(this.calculateLog(this.getRange().getLowerBound()) / d2);
        double d4 = d3 * d2;
        double d5 = this.calculateLog(this.getUpperBound());
        boolean bl3 = bl2 = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(d4);
        for (double d6 = d4; bl2 && d6 <= d5; d6 += this.tickUnit.getSize()) {
            double d7 = this.calculateValueNoINF(d6);
            if (range.contains(d7)) {
                arrayList.add(new LogTick(TickType.MAJOR, d7, this.createTickLabel(d7), textAnchor));
            }
            double d8 = Math.pow(this.base, d6 + this.tickUnit.getSize());
            for (int i2 = 1; i2 < n2; ++i2) {
                double d9 = d7 + (double)i2 * ((d8 - d7) / (double)n2);
                if (!range.contains(d9)) continue;
                arrayList.add(new LogTick(TickType.MINOR, d9, null, textAnchor));
            }
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        boolean bl2;
        Range range = this.getRange();
        ArrayList<LogTick> arrayList = new ArrayList<LogTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        TextAnchor textAnchor = rectangleEdge == RectangleEdge.RIGHT ? TextAnchor.CENTER_LEFT : TextAnchor.CENTER_RIGHT;
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        int n2 = this.tickUnit.getMinorTickCount();
        double d2 = this.getTickUnit().getSize();
        double d3 = Math.ceil(this.calculateLog(this.getRange().getLowerBound()) / d2);
        double d4 = d3 * d2;
        double d5 = this.calculateLog(this.getUpperBound());
        boolean bl3 = bl2 = this.tickUnit.getSize() > 0.0 && !Double.isInfinite(d4);
        for (double d6 = d4; bl2 && d6 <= d5; d6 += this.tickUnit.getSize()) {
            double d7 = this.calculateValueNoINF(d6);
            if (range.contains(d7)) {
                arrayList.add(new LogTick(TickType.MAJOR, d7, this.createTickLabel(d7), textAnchor));
            }
            double d8 = Math.pow(this.base, d6 + this.tickUnit.getSize());
            for (int i2 = 1; i2 < n2; ++i2) {
                double d9 = d7 + (double)i2 * ((d8 - d7) / (double)n2);
                if (!range.contains(d9)) continue;
                arrayList.add(new LogTick(TickType.MINOR, d9, null, textAnchor));
            }
        }
        return arrayList;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        TickUnit tickUnit;
        Range range = this.getRange();
        double d2 = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double d3 = this.calculateLog(range.getUpperBound());
        double d4 = (d3 - d2) / 50.0;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit2 = tickUnit = tickUnitSource.getCeilingTickUnit(d4);
        boolean bl2 = false;
        while (!bl2) {
            double d5;
            this.tickUnit = (NumberTickUnit)tickUnit;
            double d6 = this.estimateMaximumTickLabelWidth(graphics2D, tickUnit);
            if (d6 < (d5 = this.exponentLengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge))) {
                bl2 = true;
                continue;
            }
            if (Double.isNaN(d5)) {
                tickUnit = tickUnit2;
                bl2 = true;
                continue;
            }
            tickUnit2 = tickUnit;
            if (!(tickUnit = tickUnitSource.getLargerTickUnit(tickUnit2)).equals(tickUnit2)) continue;
            bl2 = true;
        }
        this.setTickUnit((NumberTickUnit)tickUnit, false, false);
    }

    public double exponentLengthToJava2D(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d3 = this.valueToJava2D(this.calculateValueNoINF(1.0), rectangle2D, rectangleEdge);
        double d4 = this.valueToJava2D(this.calculateValueNoINF(d2 + 1.0), rectangle2D, rectangleEdge);
        return Math.abs(d4 - d3);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        TickUnit tickUnit;
        Range range = this.getRange();
        double d2 = this.calculateLog(Math.max(this.smallestValue, range.getLowerBound()));
        double d3 = this.calculateLog(range.getUpperBound());
        double d4 = (d3 - d2) / 50.0;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit2 = tickUnit = tickUnitSource.getCeilingTickUnit(d4);
        boolean bl2 = false;
        while (!bl2) {
            double d5;
            this.tickUnit = (NumberTickUnit)tickUnit;
            double d6 = this.estimateMaximumTickLabelHeight(graphics2D);
            if (d6 < (d5 = this.exponentLengthToJava2D(tickUnit.getSize(), rectangle2D, rectangleEdge))) {
                bl2 = true;
                continue;
            }
            if (Double.isNaN(d5)) {
                tickUnit = tickUnit2;
                bl2 = true;
                continue;
            }
            tickUnit2 = tickUnit;
            if (!(tickUnit = tickUnitSource.getLargerTickUnit(tickUnit2)).equals(tickUnit2)) continue;
            bl2 = true;
        }
        this.setTickUnit((NumberTickUnit)tickUnit, false, false);
    }

    protected AttributedString createTickLabel(double d2) {
        if (this.numberFormatOverride != null) {
            return new AttributedString(this.numberFormatOverride.format(d2));
        }
        String string = this.baseSymbol;
        if (string == null) {
            string = this.baseFormatter.format(this.base);
        }
        double d3 = this.calculateLog(d2);
        String string2 = this.getTickUnit().valueToString(d3);
        AttributedString attributedString = new AttributedString(string + string2);
        attributedString.addAttributes(this.getTickLabelFont().getAttributes(), 0, (string + string2).length());
        attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, string.length(), string.length() + string2.length());
        return attributedString;
    }

    protected double estimateMaximumTickLabelHeight(Graphics2D graphics2D) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d2 = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        return d2 += (double)font.getLineMetrics("123", fontRenderContext).getHeight();
    }

    protected double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d2 = rectangleInsets.getLeft() + rectangleInsets.getRight();
        if (this.isVerticalTickLabels()) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            LineMetrics lineMetrics = this.getTickLabelFont().getLineMetrics("0", fontRenderContext);
            d2 += (double)lineMetrics.getHeight();
        } else {
            Range range = this.getRange();
            double d3 = range.getLowerBound();
            double d4 = range.getUpperBound();
            AttributedString attributedString = this.createTickLabel(d3);
            AttributedString attributedString2 = this.createTickLabel(d4);
            double d5 = AttrStringUtils.getTextBounds(attributedString, graphics2D).getWidth();
            double d6 = AttrStringUtils.getTextBounds(attributedString2, graphics2D).getWidth();
            d2 += Math.max(d5, d6);
        }
        return d2;
    }

    @Override
    public void zoomRange(double d2, double d3) {
        Range range;
        Range range2 = this.getRange();
        double d4 = range2.getLowerBound();
        double d5 = range2.getUpperBound();
        double d6 = this.calculateLog(d4);
        double d7 = this.calculateLog(d5);
        double d8 = d7 - d6;
        if (this.isInverted()) {
            double d9 = d6 + d8 * (1.0 - d3);
            double d10 = d6 + d8 * (1.0 - d2);
            range = new Range(this.calculateValueNoINF(d9), this.calculateValueNoINF(d10));
        } else {
            double d11 = d6 + d8 * d2;
            double d12 = d6 + d8 * d3;
            range = new Range(this.calculateValueNoINF(d11), this.calculateValueNoINF(d12));
        }
        this.setRange(range);
    }

    @Override
    public void pan(double d2) {
        Range range = this.getRange();
        double d3 = range.getLowerBound();
        double d4 = range.getUpperBound();
        double d5 = this.calculateLog(d3);
        double d6 = this.calculateLog(d4);
        double d7 = d6 - d5;
        double d8 = d7 * d2;
        this.setRange(this.calculateValueNoINF(d5 += d8), this.calculateValueNoINF(d6 += d8));
    }

    @Override
    public void resizeRange(double d2) {
        Range range = this.getRange();
        double d3 = this.calculateLog(range.getLowerBound());
        double d4 = this.calculateLog(range.getUpperBound());
        double d5 = this.calculateValueNoINF((d3 + d4) / 2.0);
        this.resizeRange(d2, d5);
    }

    @Override
    public void resizeRange(double d2, double d3) {
        this.resizeRange2(d2, d3);
    }

    @Override
    public void resizeRange2(double d2, double d3) {
        if (d2 > 0.0) {
            double d4 = this.calculateLog(d3);
            Range range = this.getRange();
            double d5 = this.calculateLog(range.getLowerBound());
            double d6 = this.calculateLog(range.getUpperBound());
            double d7 = d2 * (d4 - d5);
            double d8 = d2 * (d6 - d4);
            double d9 = this.calculateValueNoINF(d4 + d8);
            Range range2 = new Range(this.calculateValueNoINF(d4 - d7), d9);
            this.setRange(range2);
        } else {
            this.setAutoRange(true);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogAxis)) {
            return false;
        }
        LogAxis logAxis = (LogAxis)object;
        if (this.base != logAxis.base) {
            return false;
        }
        if (!ObjectUtilities.equal(this.baseSymbol, logAxis.baseSymbol)) {
            return false;
        }
        if (!this.baseFormatter.equals(logAxis.baseFormatter)) {
            return false;
        }
        if (this.smallestValue != logAxis.smallestValue) {
            return false;
        }
        if (!ObjectUtilities.equal(this.numberFormatOverride, logAxis.numberFormatOverride)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        long l2 = Double.doubleToLongBits(this.base);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.smallestValue);
        n2 = 37 * n2 + (int)(l2 ^ l2 >>> 32);
        if (this.numberFormatOverride != null) {
            n2 = 37 * n2 + this.numberFormatOverride.hashCode();
        }
        n2 = 37 * n2 + this.tickUnit.hashCode();
        return n2;
    }

    public static TickUnitSource createLogTickUnits(Locale locale) {
        TickUnits tickUnits = new TickUnits();
        LogFormat logFormat = new LogFormat();
        tickUnits.add(new NumberTickUnit(0.05, logFormat, 2));
        tickUnits.add(new NumberTickUnit(0.1, logFormat, 10));
        tickUnits.add(new NumberTickUnit(0.2, logFormat, 2));
        tickUnits.add(new NumberTickUnit(0.5, logFormat, 5));
        tickUnits.add(new NumberTickUnit(1.0, logFormat, 10));
        tickUnits.add(new NumberTickUnit(2.0, logFormat, 10));
        tickUnits.add(new NumberTickUnit(3.0, logFormat, 15));
        tickUnits.add(new NumberTickUnit(4.0, logFormat, 20));
        tickUnits.add(new NumberTickUnit(5.0, logFormat, 25));
        tickUnits.add(new NumberTickUnit(6.0, logFormat));
        tickUnits.add(new NumberTickUnit(7.0, logFormat));
        tickUnits.add(new NumberTickUnit(8.0, logFormat));
        tickUnits.add(new NumberTickUnit(9.0, logFormat));
        tickUnits.add(new NumberTickUnit(10.0, logFormat));
        return tickUnits;
    }
}

