/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.util.ParamChecks;
import org.jfree.io.SerialUtilities;
import org.jfree.text.TextBlock;
import org.jfree.text.TextFragment;
import org.jfree.text.TextLine;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PaintUtilities;

public class ExtendedCategoryAxis
extends CategoryAxis {
    static final long serialVersionUID = -3004429093959826567L;
    private Map sublabels = new HashMap();
    private Font sublabelFont = new Font("SansSerif", 0, 10);
    private transient Paint sublabelPaint = Color.black;

    public ExtendedCategoryAxis(String string) {
        super(string);
    }

    public Font getSubLabelFont() {
        return this.sublabelFont;
    }

    public void setSubLabelFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        this.sublabelFont = font;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Paint getSubLabelPaint() {
        return this.sublabelPaint;
    }

    public void setSubLabelPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.sublabelPaint = paint;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addSubLabel(Comparable comparable, String string) {
        this.sublabels.put(comparable, string);
    }

    @Override
    protected TextBlock createLabel(Comparable comparable, float f2, RectangleEdge rectangleEdge, Graphics2D graphics2D) {
        TextBlock textBlock = super.createLabel(comparable, f2, rectangleEdge, graphics2D);
        String string = (String)this.sublabels.get(comparable);
        if (string != null) {
            TextLine textLine;
            if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
                TextLine textLine2 = new TextLine(string, this.sublabelFont, this.sublabelPaint);
                textBlock.addLine(textLine2);
            } else if ((rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) && (textLine = textBlock.getLastLine()) != null) {
                textLine.addFragment(new TextFragment("  " + string, this.sublabelFont, this.sublabelPaint));
            }
        }
        return textBlock;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ExtendedCategoryAxis)) {
            return false;
        }
        ExtendedCategoryAxis extendedCategoryAxis = (ExtendedCategoryAxis)object;
        if (!this.sublabelFont.equals(extendedCategoryAxis.sublabelFont)) {
            return false;
        }
        if (!PaintUtilities.equal(this.sublabelPaint, extendedCategoryAxis.sublabelPaint)) {
            return false;
        }
        if (!this.sublabels.equals(extendedCategoryAxis.sublabels)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        ExtendedCategoryAxis extendedCategoryAxis = (ExtendedCategoryAxis)super.clone();
        extendedCategoryAxis.sublabels = new HashMap(this.sublabels);
        return extendedCategoryAxis;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.sublabelPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.sublabelPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

