/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.DateTickUnit;
import org.jfree.chart.axis.DateTickUnitType;
import org.jfree.chart.axis.SegmentedTimeline;
import org.jfree.chart.axis.TickType;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.axis.Timeline;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueAxisPlot;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.time.DateRange;
import org.jfree.data.time.Month;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Year;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtilities;

public class DateAxis
extends ValueAxis
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1013460999649007604L;
    public static final DateRange DEFAULT_DATE_RANGE = new DateRange();
    public static final double DEFAULT_AUTO_RANGE_MINIMUM_SIZE_IN_MILLISECONDS = 2.0;
    public static final DateTickUnit DEFAULT_DATE_TICK_UNIT = new DateTickUnit(DateTickUnitType.DAY, 1, (DateFormat)new SimpleDateFormat());
    public static final Date DEFAULT_ANCHOR_DATE = new Date();
    private DateTickUnit tickUnit;
    private DateFormat dateFormatOverride;
    private DateTickMarkPosition tickMarkPosition = DateTickMarkPosition.START;
    private static final Timeline DEFAULT_TIMELINE = new DefaultTimeline();
    private TimeZone timeZone;
    private Locale locale;
    private Timeline timeline;

    public DateAxis() {
        this(null);
    }

    public DateAxis(String string) {
        this(string, TimeZone.getDefault());
    }

    public DateAxis(String string, TimeZone timeZone) {
        this(string, timeZone, Locale.getDefault());
    }

    public DateAxis(String string, TimeZone timeZone, Locale locale) {
        super(string, DateAxis.createStandardDateTickUnits(timeZone, locale));
        this.tickUnit = new DateTickUnit(DateTickUnitType.DAY, 1, (DateFormat)new SimpleDateFormat());
        this.setAutoRangeMinimumSize(2.0);
        this.setRange(DEFAULT_DATE_RANGE, false, false);
        this.dateFormatOverride = null;
        this.timeZone = timeZone;
        this.locale = locale;
        this.timeline = DEFAULT_TIMELINE;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        ParamChecks.nullNotPermitted(timeZone, "zone");
        this.timeZone = timeZone;
        this.setStandardTickUnits(DateAxis.createStandardDateTickUnits(timeZone, this.locale));
        this.fireChangeEvent();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        ParamChecks.nullNotPermitted(locale, "locale");
        this.locale = locale;
        this.setStandardTickUnits(DateAxis.createStandardDateTickUnits(this.timeZone, this.locale));
        this.fireChangeEvent();
    }

    public Timeline getTimeline() {
        return this.timeline;
    }

    public void setTimeline(Timeline timeline) {
        if (this.timeline != timeline) {
            this.timeline = timeline;
            this.fireChangeEvent();
        }
    }

    public DateTickUnit getTickUnit() {
        return this.tickUnit;
    }

    public void setTickUnit(DateTickUnit dateTickUnit) {
        this.setTickUnit(dateTickUnit, true, true);
    }

    public void setTickUnit(DateTickUnit dateTickUnit, boolean bl2, boolean bl3) {
        this.tickUnit = dateTickUnit;
        if (bl3) {
            this.setAutoTickUnitSelection(false, false);
        }
        if (bl2) {
            this.fireChangeEvent();
        }
    }

    public DateFormat getDateFormatOverride() {
        return this.dateFormatOverride;
    }

    public void setDateFormatOverride(DateFormat dateFormat) {
        this.dateFormatOverride = dateFormat;
        this.fireChangeEvent();
    }

    @Override
    public void setRange(Range range) {
        this.setRange(range, true, true);
    }

    @Override
    public void setRange(Range range, boolean bl2, boolean bl3) {
        ParamChecks.nullNotPermitted(range, "range");
        if (!(range instanceof DateRange)) {
            range = new DateRange(range);
        }
        super.setRange(range, bl2, bl3);
    }

    public void setRange(Date date, Date date2) {
        if (date.getTime() >= date2.getTime()) {
            throw new IllegalArgumentException("Requires 'lower' < 'upper'.");
        }
        this.setRange(new DateRange(date, date2));
    }

    @Override
    public void setRange(double d2, double d3) {
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires 'lower' < 'upper'.");
        }
        this.setRange(new DateRange(d2, d3));
    }

    public Date getMinimumDate() {
        Date date;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getLowerDate();
        } else {
            date = new Date((long)range.getLowerBound());
        }
        return date;
    }

    public void setMinimumDate(Date date) {
        ParamChecks.nullNotPermitted(date, "date");
        Date date2 = this.getMaximumDate();
        long l2 = date2.getTime();
        long l3 = date.getTime();
        if (l2 <= l3) {
            Date date3 = this.getMinimumDate();
            long l4 = l2 - date3.getTime();
            date2 = new Date(l3 + l4);
        }
        this.setRange(new DateRange(date, date2), true, false);
        this.fireChangeEvent();
    }

    public Date getMaximumDate() {
        Date date;
        Range range = this.getRange();
        if (range instanceof DateRange) {
            DateRange dateRange = (DateRange)range;
            date = dateRange.getUpperDate();
        } else {
            date = new Date((long)range.getUpperBound());
        }
        return date;
    }

    public void setMaximumDate(Date date) {
        ParamChecks.nullNotPermitted(date, "maximumDate");
        Date date2 = this.getMinimumDate();
        long l2 = date2.getTime();
        long l3 = date.getTime();
        if (l2 >= l3) {
            Date date3 = this.getMaximumDate();
            long l4 = date3.getTime() - l2;
            date2 = new Date(l3 - l4);
        }
        this.setRange(new DateRange(date2, date), true, false);
        this.fireChangeEvent();
    }

    public DateTickMarkPosition getTickMarkPosition() {
        return this.tickMarkPosition;
    }

    public void setTickMarkPosition(DateTickMarkPosition dateTickMarkPosition) {
        ParamChecks.nullNotPermitted(dateTickMarkPosition, "position");
        this.tickMarkPosition = dateTickMarkPosition;
        this.fireChangeEvent();
    }

    @Override
    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public boolean isHiddenValue(long l2) {
        return !this.timeline.containsDomainValue(new Date(l2));
    }

    @Override
    public double valueToJava2D(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        d2 = this.timeline.toTimelineValue((long)d2);
        DateRange dateRange = (DateRange)this.getRange();
        double d3 = this.timeline.toTimelineValue(dateRange.getLowerMillis());
        double d4 = this.timeline.toTimelineValue(dateRange.getUpperMillis());
        double d5 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            double d6 = rectangle2D.getX();
            double d7 = rectangle2D.getMaxX();
            d5 = this.isInverted() ? d7 + (d2 - d3) / (d4 - d3) * (d6 - d7) : d6 + (d2 - d3) / (d4 - d3) * (d7 - d6);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            double d8 = rectangle2D.getMinY();
            double d9 = rectangle2D.getMaxY();
            d5 = this.isInverted() ? d8 + (d2 - d3) / (d4 - d3) * (d9 - d8) : d9 - (d2 - d3) / (d4 - d3) * (d9 - d8);
        }
        return d5;
    }

    public double dateToJava2D(Date date, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2 = date.getTime();
        return this.valueToJava2D(d2, rectangle2D, rectangleEdge);
    }

    @Override
    public double java2DToValue(double d2, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        DateRange dateRange = (DateRange)this.getRange();
        double d3 = this.timeline.toTimelineValue(dateRange.getLowerMillis());
        double d4 = this.timeline.toTimelineValue(dateRange.getUpperMillis());
        double d5 = 0.0;
        double d6 = 0.0;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            d5 = rectangle2D.getX();
            d6 = rectangle2D.getMaxX();
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            d5 = rectangle2D.getMaxY();
            d6 = rectangle2D.getY();
        }
        double d7 = this.isInverted() ? d4 - (d2 - d5) / (d6 - d5) * (d4 - d3) : d3 + (d2 - d5) / (d6 - d5) * (d4 - d3);
        return this.timeline.toMillisecond((long)d7);
    }

    public Date calculateLowestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.nextStandardDate(this.getMinimumDate(), dateTickUnit);
    }

    public Date calculateHighestVisibleTickValue(DateTickUnit dateTickUnit) {
        return this.previousStandardDate(this.getMaximumDate(), dateTickUnit);
    }

    protected Date previousStandardDate(Date date, DateTickUnit dateTickUnit) {
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTime(date);
        int n2 = dateTickUnit.getCount();
        int n3 = calendar.get(dateTickUnit.getCalendarField());
        int n4 = n2 * (n3 / n2);
        switch (dateTickUnit.getUnit()) {
            case 6: {
                int n5 = calendar.get(1);
                int n6 = calendar.get(2);
                int n7 = calendar.get(5);
                int n8 = calendar.get(11);
                int n9 = calendar.get(12);
                int n10 = calendar.get(13);
                calendar.set(n5, n6, n7, n8, n9, n10);
                calendar.set(14, n4);
                Date date2 = calendar.getTime();
                if (date2.getTime() >= date.getTime()) {
                    calendar.set(14, n4 - 1);
                    date2 = calendar.getTime();
                }
                return date2;
            }
            case 5: {
                int n11 = calendar.get(1);
                int n12 = calendar.get(2);
                int n13 = calendar.get(5);
                int n14 = calendar.get(11);
                int n15 = calendar.get(12);
                int n16 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 500 : 999);
                calendar.set(14, n16);
                calendar.set(n11, n12, n13, n14, n15, n4);
                Date date3 = calendar.getTime();
                if (date3.getTime() >= date.getTime()) {
                    calendar.set(13, n4 - 1);
                    date3 = calendar.getTime();
                }
                return date3;
            }
            case 4: {
                int n17 = calendar.get(1);
                int n18 = calendar.get(2);
                int n19 = calendar.get(5);
                int n20 = calendar.get(11);
                int n21 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 30 : 59);
                calendar.clear(14);
                calendar.set(n17, n18, n19, n20, n4, n21);
                Date date4 = calendar.getTime();
                if (date4.getTime() >= date.getTime()) {
                    calendar.set(12, n4 - 1);
                    date4 = calendar.getTime();
                }
                return date4;
            }
            case 3: {
                int n22;
                int n23;
                int n24 = calendar.get(1);
                int n25 = calendar.get(2);
                int n26 = calendar.get(5);
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n23 = 0;
                    n22 = 0;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n23 = 30;
                    n22 = 0;
                } else {
                    n23 = 59;
                    n22 = 59;
                }
                calendar.clear(14);
                calendar.set(n24, n25, n26, n4, n23, n22);
                Date date5 = calendar.getTime();
                if (date5.getTime() >= date.getTime()) {
                    calendar.set(11, n4 - 1);
                    date5 = calendar.getTime();
                }
                return date5;
            }
            case 2: {
                int n27 = calendar.get(1);
                int n28 = calendar.get(2);
                int n29 = this.tickMarkPosition == DateTickMarkPosition.START ? 0 : (this.tickMarkPosition == DateTickMarkPosition.MIDDLE ? 12 : 23);
                calendar.clear(14);
                calendar.set(n27, n28, n4, n29, 0, 0);
                Date date6 = calendar.getTime();
                if (date6.getTime() >= date.getTime()) {
                    calendar.set(5, n4 - 1);
                    date6 = calendar.getTime();
                }
                return date6;
            }
            case 1: {
                int n30 = calendar.get(1);
                calendar.clear(14);
                calendar.set(n30, n4, 1, 0, 0, 0);
                Month month = new Month(calendar.getTime(), this.timeZone, this.locale);
                Date date7 = this.calculateDateForPosition(month, this.tickMarkPosition);
                long l2 = date7.getTime();
                if (l2 >= date.getTime()) {
                    month = (Month)month.previous();
                    month.peg(Calendar.getInstance(this.timeZone));
                    date7 = this.calculateDateForPosition(month, this.tickMarkPosition);
                }
                return date7;
            }
            case 0: {
                int n31;
                int n32;
                if (this.tickMarkPosition == DateTickMarkPosition.START) {
                    n32 = 0;
                    n31 = 1;
                } else if (this.tickMarkPosition == DateTickMarkPosition.MIDDLE) {
                    n32 = 6;
                    n31 = 1;
                } else {
                    n32 = 11;
                    n31 = 31;
                }
                calendar.clear(14);
                calendar.set(n4, n32, n31, 0, 0, 0);
                Date date8 = calendar.getTime();
                if (date8.getTime() >= date.getTime()) {
                    calendar.set(1, n4 - 1);
                    date8 = calendar.getTime();
                }
                return date8;
            }
        }
        return null;
    }

    private Date calculateDateForPosition(RegularTimePeriod regularTimePeriod, DateTickMarkPosition dateTickMarkPosition) {
        ParamChecks.nullNotPermitted(regularTimePeriod, "period");
        Date date = null;
        if (dateTickMarkPosition == DateTickMarkPosition.START) {
            date = new Date(regularTimePeriod.getFirstMillisecond());
        } else if (dateTickMarkPosition == DateTickMarkPosition.MIDDLE) {
            date = new Date(regularTimePeriod.getMiddleMillisecond());
        } else if (dateTickMarkPosition == DateTickMarkPosition.END) {
            date = new Date(regularTimePeriod.getLastMillisecond());
        }
        return date;
    }

    protected Date nextStandardDate(Date date, DateTickUnit dateTickUnit) {
        Date date2 = this.previousStandardDate(date, dateTickUnit);
        Calendar calendar = Calendar.getInstance(this.timeZone, this.locale);
        calendar.setTime(date2);
        calendar.add(dateTickUnit.getCalendarField(), dateTickUnit.getMultiple());
        return calendar.getTime();
    }

    public static TickUnitSource createStandardDateTickUnits() {
        return DateAxis.createStandardDateTickUnits(TimeZone.getDefault(), Locale.getDefault());
    }

    public static TickUnitSource createStandardDateTickUnits(TimeZone timeZone, Locale locale) {
        ParamChecks.nullNotPermitted(timeZone, "zone");
        ParamChecks.nullNotPermitted(locale, "locale");
        TickUnits tickUnits = new TickUnits();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS", locale);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("HH:mm:ss", locale);
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("HH:mm", locale);
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("d-MMM, HH:mm", locale);
        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("d-MMM", locale);
        SimpleDateFormat simpleDateFormat6 = new SimpleDateFormat("MMM-yyyy", locale);
        SimpleDateFormat simpleDateFormat7 = new SimpleDateFormat("yyyy", locale);
        simpleDateFormat.setTimeZone(timeZone);
        simpleDateFormat2.setTimeZone(timeZone);
        simpleDateFormat3.setTimeZone(timeZone);
        simpleDateFormat4.setTimeZone(timeZone);
        simpleDateFormat5.setTimeZone(timeZone);
        simpleDateFormat6.setTimeZone(timeZone);
        simpleDateFormat7.setTimeZone(timeZone);
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 1, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 5, DateTickUnitType.MILLISECOND, 1, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 10, DateTickUnitType.MILLISECOND, 1, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 25, DateTickUnitType.MILLISECOND, 5, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 50, DateTickUnitType.MILLISECOND, 10, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 100, DateTickUnitType.MILLISECOND, 10, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 250, DateTickUnitType.MILLISECOND, 10, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MILLISECOND, 500, DateTickUnitType.MILLISECOND, 50, (DateFormat)simpleDateFormat));
        tickUnits.add(new DateTickUnit(DateTickUnitType.SECOND, 1, DateTickUnitType.MILLISECOND, 50, (DateFormat)simpleDateFormat2));
        tickUnits.add(new DateTickUnit(DateTickUnitType.SECOND, 5, DateTickUnitType.SECOND, 1, (DateFormat)simpleDateFormat2));
        tickUnits.add(new DateTickUnit(DateTickUnitType.SECOND, 10, DateTickUnitType.SECOND, 1, (DateFormat)simpleDateFormat2));
        tickUnits.add(new DateTickUnit(DateTickUnitType.SECOND, 30, DateTickUnitType.SECOND, 5, (DateFormat)simpleDateFormat2));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 1, DateTickUnitType.SECOND, 5, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 2, DateTickUnitType.SECOND, 10, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 5, DateTickUnitType.MINUTE, 1, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 10, DateTickUnitType.MINUTE, 1, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 15, DateTickUnitType.MINUTE, 5, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 20, DateTickUnitType.MINUTE, 5, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MINUTE, 30, DateTickUnitType.MINUTE, 5, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.HOUR, 1, DateTickUnitType.MINUTE, 5, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.HOUR, 2, DateTickUnitType.MINUTE, 10, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.HOUR, 4, DateTickUnitType.MINUTE, 30, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.HOUR, 6, DateTickUnitType.HOUR, 1, (DateFormat)simpleDateFormat3));
        tickUnits.add(new DateTickUnit(DateTickUnitType.HOUR, 12, DateTickUnitType.HOUR, 1, (DateFormat)simpleDateFormat4));
        tickUnits.add(new DateTickUnit(DateTickUnitType.DAY, 1, DateTickUnitType.HOUR, 1, (DateFormat)simpleDateFormat5));
        tickUnits.add(new DateTickUnit(DateTickUnitType.DAY, 2, DateTickUnitType.HOUR, 1, (DateFormat)simpleDateFormat5));
        tickUnits.add(new DateTickUnit(DateTickUnitType.DAY, 7, DateTickUnitType.DAY, 1, (DateFormat)simpleDateFormat5));
        tickUnits.add(new DateTickUnit(DateTickUnitType.DAY, 15, DateTickUnitType.DAY, 1, (DateFormat)simpleDateFormat5));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MONTH, 1, DateTickUnitType.DAY, 1, (DateFormat)simpleDateFormat6));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MONTH, 2, DateTickUnitType.DAY, 1, (DateFormat)simpleDateFormat6));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MONTH, 3, DateTickUnitType.MONTH, 1, (DateFormat)simpleDateFormat6));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MONTH, 4, DateTickUnitType.MONTH, 1, (DateFormat)simpleDateFormat6));
        tickUnits.add(new DateTickUnit(DateTickUnitType.MONTH, 6, DateTickUnitType.MONTH, 1, (DateFormat)simpleDateFormat6));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 1, DateTickUnitType.MONTH, 1, (DateFormat)simpleDateFormat7));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 2, DateTickUnitType.MONTH, 3, (DateFormat)simpleDateFormat7));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 5, DateTickUnitType.YEAR, 1, (DateFormat)simpleDateFormat7));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 10, DateTickUnitType.YEAR, 1, (DateFormat)simpleDateFormat7));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 25, DateTickUnitType.YEAR, 5, (DateFormat)simpleDateFormat7));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 50, DateTickUnitType.YEAR, 10, (DateFormat)simpleDateFormat7));
        tickUnits.add(new DateTickUnit(DateTickUnitType.YEAR, 100, DateTickUnitType.YEAR, 20, (DateFormat)simpleDateFormat7));
        return tickUnits;
    }

    @Override
    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof ValueAxisPlot) {
            long l2;
            ValueAxisPlot valueAxisPlot = (ValueAxisPlot)((Object)plot);
            Range range = valueAxisPlot.getDataRange(this);
            if (range == null) {
                range = this.timeline instanceof SegmentedTimeline ? new DateRange(((SegmentedTimeline)this.timeline).getStartTime(), ((SegmentedTimeline)this.timeline).getStartTime() + 1L) : new DateRange();
            }
            long l3 = this.timeline.toTimelineValue((long)range.getUpperBound());
            long l4 = (long)this.getFixedAutoRange();
            if ((double)l4 > 0.0) {
                l2 = l3 - l4;
            } else {
                long l5;
                l2 = this.timeline.toTimelineValue((long)range.getLowerBound());
                double d2 = l3 - l2;
                if (d2 < (double)(l5 = (long)this.getAutoRangeMinimumSize())) {
                    long l6 = (long)((double)l5 - d2) / 2L;
                    l3 += l6;
                    l2 -= l6;
                }
                l3 += (long)(d2 * this.getUpperMargin());
                l2 -= (long)(d2 * this.getLowerMargin());
            }
            l3 = this.timeline.toMillisecond(l3);
            l2 = this.timeline.toMillisecond(l2);
            DateRange dateRange = new DateRange(new Date(l2), new Date(l3));
            this.setRange(dateRange, false, false);
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            this.selectHorizontalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            this.selectVerticalAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
    }

    protected void selectHorizontalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        long l2 = 0L;
        if (this.timeline instanceof SegmentedTimeline) {
            l2 = ((SegmentedTimeline)this.timeline).getStartTime();
        }
        double d2 = this.valueToJava2D((double)l2 + 0.0, rectangle2D, rectangleEdge);
        double d3 = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnitSource.getCeilingTickUnit(this.getTickUnit());
        double d4 = this.valueToJava2D((double)l2 + tickUnit.getSize(), rectangle2D, rectangleEdge);
        double d5 = Math.abs(d4 - d2);
        double d6 = d3 / d5 * tickUnit.getSize();
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d6);
        double d7 = this.valueToJava2D((double)l2 + dateTickUnit.getSize(), rectangle2D, rectangleEdge);
        double d8 = Math.abs(d7 - d2);
        d3 = this.estimateMaximumTickLabelWidth(graphics2D, dateTickUnit);
        if (d3 > d8) {
            dateTickUnit = (DateTickUnit)tickUnitSource.getLargerTickUnit(dateTickUnit);
        }
        this.setTickUnit(dateTickUnit, false, false);
    }

    protected void selectVerticalAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        double d2;
        double d3;
        double d4;
        double d5;
        TickUnitSource tickUnitSource = this.getStandardTickUnits();
        double d6 = this.valueToJava2D(0.0, rectangle2D, rectangleEdge);
        double d7 = this.getRange().getLength() / 10.0;
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d7);
        double d8 = this.estimateMaximumTickLabelHeight(graphics2D, dateTickUnit);
        double d9 = d8 / (d5 = Math.abs((d4 = this.valueToJava2D(dateTickUnit.getSize(), rectangle2D, rectangleEdge)) - d6)) * dateTickUnit.getSize();
        DateTickUnit dateTickUnit2 = (DateTickUnit)tickUnitSource.getCeilingTickUnit(d9);
        double d10 = this.estimateMaximumTickLabelHeight(graphics2D, dateTickUnit2);
        DateTickUnit dateTickUnit3 = d10 < (d3 = Math.abs((d2 = this.valueToJava2D(dateTickUnit2.getSize(), rectangle2D, rectangleEdge)) - d6)) ? dateTickUnit2 : (DateTickUnit)tickUnitSource.getLargerTickUnit(dateTickUnit2);
        this.setTickUnit(dateTickUnit3, false, false);
    }

    private double estimateMaximumTickLabelWidth(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d2 = rectangleInsets.getLeft() + rectangleInsets.getRight();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (this.isVerticalTickLabels()) {
            d2 += (double)lineMetrics.getHeight();
        } else {
            String string;
            String string2;
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            DateFormat dateFormat = this.getDateFormatOverride();
            if (dateFormat != null) {
                string2 = dateFormat.format(date);
                string = dateFormat.format(date2);
            } else {
                string2 = dateTickUnit.dateToString(date);
                string = dateTickUnit.dateToString(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d3 = fontMetrics.stringWidth(string2);
            double d4 = fontMetrics.stringWidth(string);
            d2 += Math.max(d3, d4);
        }
        return d2;
    }

    private double estimateMaximumTickLabelHeight(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        RectangleInsets rectangleInsets = this.getTickLabelInsets();
        double d2 = rectangleInsets.getTop() + rectangleInsets.getBottom();
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        LineMetrics lineMetrics = font.getLineMetrics("ABCxyz", fontRenderContext);
        if (!this.isVerticalTickLabels()) {
            d2 += (double)lineMetrics.getHeight();
        } else {
            String string;
            String string2;
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            DateFormat dateFormat = this.getDateFormatOverride();
            if (dateFormat != null) {
                string2 = dateFormat.format(date);
                string = dateFormat.format(date2);
            } else {
                string2 = dateTickUnit.dateToString(date);
                string = dateTickUnit.dateToString(date2);
            }
            FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
            double d3 = fontMetrics.stringWidth(string2);
            double d4 = fontMetrics.stringWidth(string);
            d2 += Math.max(d3, d4);
        }
        return d2;
    }

    @Override
    public List refreshTicks(Graphics2D graphics2D, AxisState axisState, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        List list = null;
        if (RectangleEdge.isTopOrBottom(rectangleEdge)) {
            list = this.refreshTicksHorizontal(graphics2D, rectangle2D, rectangleEdge);
        } else if (RectangleEdge.isLeftOrRight(rectangleEdge)) {
            list = this.refreshTicksVertical(graphics2D, rectangle2D, rectangleEdge);
        }
        return list;
    }

    private Date correctTickDateForPosition(Date date, DateTickUnit dateTickUnit, DateTickMarkPosition dateTickMarkPosition) {
        Date date2 = date;
        switch (dateTickUnit.getUnit()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 1: {
                date2 = this.calculateDateForPosition(new Month(date, this.timeZone, this.locale), dateTickMarkPosition);
                break;
            }
            case 0: {
                date2 = this.calculateDateForPosition(new Year(date, this.timeZone, this.locale), dateTickMarkPosition);
                break;
            }
        }
        return date2;
    }

    protected List refreshTicksHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        boolean bl2 = false;
        while (date.before(date2)) {
            if (!bl2) {
                date = this.correctTickDateForPosition(date, dateTickUnit, this.tickMarkPosition);
            }
            long l2 = date.getTime();
            long l3 = dateTickUnit.addToDate(date, this.timeZone).getTime() - l2;
            int n2 = this.getMinorTickCount();
            if (n2 <= 0) {
                n2 = dateTickUnit.getMinorTickCount();
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                long l4 = l2 - l3 * (long)i2 / (long)n2;
                if (l4 <= 0L || !this.getRange().contains(l4) || this.isHiddenValue(l4)) continue;
                arrayList.add(new DateTick(TickType.MINOR, new Date(l4), "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            if (!this.isHiddenValue(date.getTime())) {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                DateFormat dateFormat = this.getDateFormatOverride();
                String string = dateFormat != null ? dateFormat.format(date) : this.tickUnit.dateToString(date);
                double d2 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                    d2 = rectangleEdge == RectangleEdge.TOP ? 1.5707963267948966 : -1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.TOP) {
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                } else {
                    textAnchor2 = TextAnchor.TOP_CENTER;
                    textAnchor = TextAnchor.TOP_CENTER;
                }
                DateTick dateTick = new DateTick(date, string, textAnchor2, textAnchor, d2);
                arrayList.add(dateTick);
                bl2 = false;
                long l5 = date.getTime();
                date = dateTickUnit.addToDate(date, this.timeZone);
                long l6 = date.getTime();
                for (int i3 = 1; i3 < n2; ++i3) {
                    long l7 = l5 + (l6 - l5) * (long)i3 / (long)n2;
                    if (!this.getRange().contains(l7) || this.isHiddenValue(l7)) continue;
                    arrayList.add(new DateTick(TickType.MINOR, new Date(l7), "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
                }
                continue;
            }
            date = dateTickUnit.rollDate(date, this.timeZone);
            bl2 = true;
        }
        return arrayList;
    }

    protected List refreshTicksVertical(Graphics2D graphics2D, Rectangle2D rectangle2D, RectangleEdge rectangleEdge) {
        ArrayList<DateTick> arrayList = new ArrayList<DateTick>();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangleEdge);
        }
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        boolean bl2 = false;
        while (date.before(date2)) {
            if (!bl2) {
                date = this.correctTickDateForPosition(date, dateTickUnit, this.tickMarkPosition);
            }
            long l2 = date.getTime();
            long l3 = dateTickUnit.addToDate(date, this.timeZone).getTime() - l2;
            int n2 = this.getMinorTickCount();
            if (n2 <= 0) {
                n2 = dateTickUnit.getMinorTickCount();
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                long l4 = l2 - l3 * (long)i2 / (long)n2;
                if (l4 <= 0L || !this.getRange().contains(l4) || this.isHiddenValue(l4)) continue;
                arrayList.add(new DateTick(TickType.MINOR, new Date(l4), "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
            }
            if (!this.isHiddenValue(date.getTime())) {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                DateFormat dateFormat = this.getDateFormatOverride();
                String string = dateFormat != null ? dateFormat.format(date) : this.tickUnit.dateToString(date);
                double d2 = 0.0;
                if (this.isVerticalTickLabels()) {
                    textAnchor2 = TextAnchor.BOTTOM_CENTER;
                    textAnchor = TextAnchor.BOTTOM_CENTER;
                    d2 = rectangleEdge == RectangleEdge.LEFT ? -1.5707963267948966 : 1.5707963267948966;
                } else if (rectangleEdge == RectangleEdge.LEFT) {
                    textAnchor2 = TextAnchor.CENTER_RIGHT;
                    textAnchor = TextAnchor.CENTER_RIGHT;
                } else {
                    textAnchor2 = TextAnchor.CENTER_LEFT;
                    textAnchor = TextAnchor.CENTER_LEFT;
                }
                DateTick dateTick = new DateTick(date, string, textAnchor2, textAnchor, d2);
                arrayList.add(dateTick);
                bl2 = false;
                long l5 = date.getTime();
                date = dateTickUnit.addToDate(date, this.timeZone);
                long l6 = date.getTime();
                for (int i3 = 1; i3 < n2; ++i3) {
                    long l7 = l5 + (l6 - l5) * (long)i3 / (long)n2;
                    if (!this.getRange().contains(l7) || this.isHiddenValue(l7)) continue;
                    arrayList.add(new DateTick(TickType.MINOR, new Date(l7), "", TextAnchor.TOP_CENTER, TextAnchor.CENTER, 0.0));
                }
                continue;
            }
            date = dateTickUnit.rollDate(date, this.timeZone);
            bl2 = true;
        }
        return arrayList;
    }

    @Override
    public AxisState draw(Graphics2D graphics2D, double d2, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge, PlotRenderingInfo plotRenderingInfo) {
        if (!this.isVisible()) {
            AxisState axisState = new AxisState(d2);
            List list = this.refreshTicks(graphics2D, axisState, rectangle2D2, rectangleEdge);
            axisState.setTicks(list);
            return axisState;
        }
        AxisState axisState = this.drawTickMarksAndLabels(graphics2D, d2, rectangle2D, rectangle2D2, rectangleEdge);
        axisState = this.getAttributedLabel() != null ? this.drawAttributedLabel(this.getAttributedLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState) : this.drawLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, rectangleEdge, axisState);
        this.createAndAddEntity(d2, axisState, rectangle2D2, rectangleEdge, plotRenderingInfo);
        return axisState;
    }

    @Override
    public void zoomRange(double d2, double d3) {
        long l2;
        long l3;
        double d4 = this.timeline.toTimelineValue((long)this.getRange().getLowerBound());
        double d5 = this.timeline.toTimelineValue((long)this.getRange().getUpperBound());
        double d6 = d5 - d4;
        if (this.isInverted()) {
            l3 = (long)(d4 + d6 * (1.0 - d3));
            l2 = (long)(d4 + d6 * (1.0 - d2));
        } else {
            l3 = (long)(d4 + d6 * d2);
            l2 = (long)(d4 + d6 * d3);
        }
        if (l2 <= l3) {
            l2 = l3 + 1L;
        }
        DateRange dateRange = new DateRange(this.timeline.toMillisecond(l3), this.timeline.toMillisecond(l2));
        this.setRange(dateRange);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DateAxis)) {
            return false;
        }
        DateAxis dateAxis = (DateAxis)object;
        if (!ObjectUtilities.equal(this.timeZone, dateAxis.timeZone)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.locale, dateAxis.locale)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickUnit, dateAxis.tickUnit)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.dateFormatOverride, dateAxis.dateFormatOverride)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.tickMarkPosition, dateAxis.tickMarkPosition)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.timeline, dateAxis.timeline)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Object clone() {
        DateAxis dateAxis = (DateAxis)super.clone();
        if (this.dateFormatOverride != null) {
            dateAxis.dateFormatOverride = (DateFormat)this.dateFormatOverride.clone();
        }
        return dateAxis;
    }

    public static TickUnitSource createStandardDateTickUnits(TimeZone timeZone) {
        return DateAxis.createStandardDateTickUnits(timeZone, Locale.getDefault());
    }

    private static class DefaultTimeline
    implements Serializable,
    Timeline {
        private DefaultTimeline() {
        }

        @Override
        public long toTimelineValue(long l2) {
            return l2;
        }

        @Override
        public long toTimelineValue(Date date) {
            return date.getTime();
        }

        @Override
        public long toMillisecond(long l2) {
            return l2;
        }

        @Override
        public boolean containsDomainValue(long l2) {
            return true;
        }

        @Override
        public boolean containsDomainValue(Date date) {
            return true;
        }

        @Override
        public boolean containsDomainRange(long l2, long l3) {
            return true;
        }

        @Override
        public boolean containsDomainRange(Date date, Date date2) {
            return true;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object == this) {
                return true;
            }
            return object instanceof DefaultTimeline;
        }
    }
}

